/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.zoom;

import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.jump.geom.CoordUtil;
import org.locationtech.jts.jump.geom.EnvelopeUtil;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.renderer.ThreadQueue;
import org.locationtech.jts.util.Assert;

public class ZoomToSelectedItemsPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.zoom(context.getLayerViewPanel().getSelectionManager().getSelectedItems(), context.getLayerViewPanel());
        return true;
    }

    public void zoom(final Collection geometries, final LayerViewPanel panel) throws NoninvertibleTransformException {
        if (this.envelope(geometries).isNull()) {
            return;
        }
        Envelope proposedEnvelope = EnvelopeUtil.bufferByFraction(this.envelope(geometries), this.zoomBufferAsExtentFraction(geometries));
        if (proposedEnvelope.getWidth() > panel.getLayerManager().getEnvelopeOfAllLayers().getWidth() || proposedEnvelope.getHeight() > panel.getLayerManager().getEnvelopeOfAllLayers().getHeight()) {
            proposedEnvelope = panel.getViewport().fullExtent();
            EnvelopeUtil.translate(proposedEnvelope, CoordUtil.subtract(EnvelopeUtil.centre(this.envelope(geometries)), EnvelopeUtil.centre(proposedEnvelope)));
        }
        panel.getViewport().zoom(proposedEnvelope);
        ThreadQueue.Listener listener = new ThreadQueue.Listener(){

            @Override
            public void allRunningThreadsFinished() {
                panel.getRenderingManager().getDefaultRendererThreadQueue().remove(this);
                try {
                    GUIUtil.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ZoomToSelectedItemsPlugIn.this.flash(geometries, panel);
                            }
                            catch (NoninvertibleTransformException noninvertibleTransformException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        };
        panel.getRenderingManager().getDefaultRendererThreadQueue().add(listener);
    }

    private Envelope envelope(Collection geometries) {
        Envelope envelope = new Envelope();
        for (Geometry geometry : geometries) {
            envelope.expandToInclude(geometry.getEnvelopeInternal());
        }
        return envelope;
    }

    private double zoomBufferAsExtentFraction(Collection geometries) {
        double zoomBuffer = 2.0 * this.averageExtent(geometries);
        double averageFullExtent = this.averageFullExtent(geometries);
        if (averageFullExtent == 0.0) {
            return 0.0;
        }
        return zoomBuffer / averageFullExtent;
    }

    private double averageExtent(Collection geometries) {
        Assert.isTrue((!geometries.isEmpty() ? 1 : 0) != 0);
        double extentSum = 0.0;
        for (Geometry geometry : geometries) {
            extentSum += geometry.getEnvelopeInternal().getWidth();
            extentSum += geometry.getEnvelopeInternal().getHeight();
        }
        return extentSum / (2.0 * (double)geometries.size());
    }

    private double averageFullExtent(Collection geometries) {
        Envelope envelope = this.envelope(geometries);
        return (envelope.getWidth() + envelope.getHeight()) / 2.0;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    public void flash(Collection geometries, LayerViewPanel panel) throws NoninvertibleTransformException {
        GeometryCollection gc = this.toGeometryCollection(geometries);
        if (!panel.getViewport().getEnvelopeInModelCoordinates().intersects(gc.getEnvelopeInternal())) {
            return;
        }
        panel.flash(gc);
    }

    private GeometryCollection toGeometryCollection(Collection geometries) {
        return new GeometryFactory().createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("ZoomSelected.gif");
    }
}

