/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui.zoom;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.locationtech.jts.jump.util.MathUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.DragTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;

public class ZoomTool
extends DragTool {
    private static final int BOX_TOLERANCE = 4;
    private static final double ZOOM_IN_FACTOR = 2.0;

    public ZoomTool() {
        this.setColor(Color.black);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Magnify.gif");
    }

    @Override
    public String getName() {
        return "Zoom In/Out";
    }

    @Override
    public Cursor getCursor() {
        return ZoomTool.createCursor(IconLoader.icon("MagnifyCursor.gif").getImage());
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        double minX = Math.min(this.getViewSource().getX(), this.getViewDestination().getX());
        double maxX = Math.max(this.getViewSource().getX(), this.getViewDestination().getX());
        double minY = Math.min(this.getViewSource().getY(), this.getViewDestination().getY());
        double maxY = Math.max(this.getViewSource().getY(), this.getViewDestination().getY());
        double widthOfNewViewAsPerceivedByOldView = maxX - minX;
        double heightOfNewViewAsPerceivedByOldView = maxY - minY;
        if (widthOfNewViewAsPerceivedByOldView == 0.0 && heightOfNewViewAsPerceivedByOldView == 0.0) {
            return;
        }
        if (widthOfNewViewAsPerceivedByOldView < 4.0 && heightOfNewViewAsPerceivedByOldView < 4.0) {
            this.zoomAt(new Point2D.Double(MathUtil.avg(minX, maxX), MathUtil.avg(minY, maxY)), 2.0);
            return;
        }
        Point2D.Double centreOfNewViewAsPerceivedByOldView = new Point2D.Double(minX + widthOfNewViewAsPerceivedByOldView / 2.0, minY + heightOfNewViewAsPerceivedByOldView / 2.0);
        this.getPanel().getViewport().zoom(centreOfNewViewAsPerceivedByOldView, widthOfNewViewAsPerceivedByOldView, heightOfNewViewAsPerceivedByOldView);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            double zoomFactor = SwingUtilities.isRightMouseButton(e) ? 0.5 : 2.0;
            this.zoomAt(e.getPoint(), zoomFactor);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (SwingUtilities.isLeftMouseButton(e)) {
                super.mousePressed(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void zoomAt(Point2D p, double zoomFactor) throws NoninvertibleTransformException {
        this.getPanel().getViewport().zoomToViewPoint(p, zoomFactor);
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }
}

