/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.wms;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.wms.BoundingBox;
import org.locationtech.jts.wms.WMService;

public class MapRequest {
    private WMService service;
    private int imgWidth;
    private int imgHeight;
    private List layerList;
    private BoundingBox bbox;
    private boolean transparent;
    private String format;

    public MapRequest(WMService service) {
        this.service = service;
        this.imgWidth = 100;
        this.imgHeight = 100;
        this.layerList = new ArrayList();
        this.bbox = service.getCapabilities().getTopLayer().getBoundingBox();
        this.transparent = false;
        this.format = null;
    }

    public WMService getService() {
        return this.service;
    }

    public String getFormat() {
        return this.format;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public List getLayers() {
        return Collections.unmodifiableList(this.layerList);
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setFormat(String format) throws IllegalArgumentException {
        String[] formats = this.service.getCapabilities().getMapFormats();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equals(format)) continue;
            this.format = format;
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setImageWidth(int imageWidth) {
        this.imgWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imgHeight = imageHeight;
    }

    public void setImageSize(int imageWidth, int imageHeight) {
        this.imgWidth = imageWidth;
        this.imgHeight = imageHeight;
    }

    public void setLayers(List layerList) {
        this.layerList = layerList;
    }

    public void setBoundingBox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    private String listToString(List list) {
        Iterator it = list.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            String layer = (String)it.next();
            layer = URLEncoder.encode(layer);
            buf.append(layer);
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public URL getURL() throws MalformedURLException {
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(this.service.getServerUrl() + "REQUEST=map&WMTVER=1.0&WIDTH=" + this.imgWidth + "&HEIGHT=" + this.imgHeight);
        urlBuf.append("&LAYERS=" + this.listToString(this.layerList));
        if (this.transparent) {
            urlBuf.append("&TRANSPARENT=TRUE");
        }
        if (this.format != null) {
            urlBuf.append("&FORMAT=" + this.format);
        }
        if (this.bbox != null) {
            urlBuf.append("&BBOX=" + this.bbox.getMinX() + "," + this.bbox.getMinY() + "," + this.bbox.getMaxX() + "," + this.bbox.getMaxY());
            if (this.bbox.getSRS() != null && !this.bbox.getSRS().equals("LatLon")) {
                urlBuf.append("&SRS=" + this.bbox.getSRS());
            }
        }
        return new URL(urlBuf.toString());
    }

    public Image getImage() throws MalformedURLException {
        return Toolkit.getDefaultToolkit().createImage(this.getURL());
    }
}

