/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.wms;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.locationtech.jts.wms.BoundingBox;
import org.locationtech.jts.wms.Capabilities;
import org.locationtech.jts.wms.MapLayer;
import org.locationtech.jts.wms.WMService;
import org.locationtech.jts.wms.util.XMLTools;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser {
    public Capabilities parseCapabilities(WMService service, InputStream inStream) throws IOException {
        Document doc;
        MapLayer topLayer = null;
        String title = null;
        LinkedList<String> formatList = new LinkedList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(inStream);
        }
        catch (ParserConfigurationException | SAXException saxe) {
            throw new IOException(saxe.toString());
        }
        try {
            title = ((CharacterData)XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Service/Title").getFirstChild()).getData();
        }
        catch (Exception saxe) {
            // empty catch block
        }
        Node formatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/Map/Format");
        NodeList nl = formatNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            formatList.add(n.getNodeName());
        }
        topLayer = this.wmsLayerFromNode(XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Layer"));
        return new Capabilities(service, title, topLayer, formatList);
    }

    public MapLayer wmsLayerFromNode(Node layerNode) {
        String name = null;
        String title = null;
        LinkedList<String> srsList = new LinkedList<String>();
        LinkedList<MapLayer> subLayers = new LinkedList<MapLayer>();
        BoundingBox bbox = null;
        NodeList nl = layerNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            try {
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals("Name")) {
                    name = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("Title")) {
                    title = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("SRS")) {
                    String srsStr = ((CharacterData)n.getFirstChild()).getData();
                    while (srsStr.length() > 0) {
                        int ws = srsStr.indexOf(32);
                        if (ws > 0) {
                            srsList.add(srsStr.substring(0, ws));
                            srsStr = srsStr.substring(ws + 1);
                            continue;
                        }
                        if (srsStr.length() <= 0) continue;
                        srsList.add(srsStr);
                        srsStr = "";
                    }
                    continue;
                }
                if (n.getNodeName().equals("LatLonBoundingBox")) {
                    bbox = this.boundingBoxFromNode(n);
                    continue;
                }
                if (!n.getNodeName().equals("Layer")) continue;
                subLayers.add(this.wmsLayerFromNode(n));
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception caught in wmsLayerFromNode(): " + e.toString());
            }
        }
        return new MapLayer(name, title, srsList, subLayers, bbox);
    }

    public BoundingBox boundingBoxFromNode(Node n) throws Exception {
        try {
            String srs;
            NamedNodeMap nm = n.getAttributes();
            if (n.getNodeName().equals("LatLonBoundingBox")) {
                srs = "LatLon";
            } else if (n.getNodeName().equals("BoundingBox")) {
                srs = nm.getNamedItem("SRS").getNodeValue();
            } else {
                throw new Exception("Not a (LatLon)BoundingBox Element");
            }
            float minx = nm.getNamedItem("minx").getNodeValue().equals("inf") ? Float.parseFloat("-Infinity") : Float.parseFloat(nm.getNamedItem("minx").getNodeValue());
            float miny = nm.getNamedItem("miny").getNodeValue().equals("inf") ? Float.parseFloat("-Infinity") : Float.parseFloat(nm.getNamedItem("miny").getNodeValue());
            float maxx = nm.getNamedItem("maxx").getNodeValue().equals("inf") ? Float.parseFloat("+Infinity") : Float.parseFloat(nm.getNamedItem("maxx").getNodeValue());
            float maxy = nm.getNamedItem("maxy").getNodeValue().equals("inf") ? Float.parseFloat("+Infinity") : Float.parseFloat(nm.getNamedItem("maxy").getNodeValue());
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            throw new Exception("Invalid bounding box element node: " + e.toString());
        }
    }
}

