/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.wms;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.locationtech.jts.wms.Capabilities;
import org.locationtech.jts.wms.MapRequest;
import org.locationtech.jts.wms.Parser;

public class WMService {
    private String serverUrl;
    private String wmsVersion;
    private Capabilities cap;

    public WMService(String serverUrl) {
        this.serverUrl = serverUrl;
        this.wmsVersion = null;
        this.cap = null;
    }

    public void initialize() throws IOException {
        String requestUrlString = this.serverUrl + "request=capabilities&WMTVER=1.0";
        URL requestUrl = new URL(requestUrlString);
        InputStream inStream = requestUrl.openStream();
        Parser p = new Parser();
        this.cap = p.parseCapabilities(this, inStream);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getTitle() {
        return this.cap.getTitle();
    }

    public Capabilities getCapabilities() {
        return this.cap;
    }

    public MapRequest createMapRequest() {
        return new MapRequest(this);
    }
}

