/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.accounting.LayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPricing;
import nl.b3p.kaartenbalie.service.GroupParser;
import nl.b3p.kaartenbalie.service.WmsWfsParser;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.wfs.v110.WfsCapabilitiesReader;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class WFSParser
extends WmsWfsParser {
    public String saveProvider(HttpServletRequest request, DynaValidatorForm dynaForm) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WFSParser.getEntityManager();
        WfsServiceProvider newServiceProvider = null;
        WfsServiceProvider oldServiceProvider = this.getServiceProvider(dynaForm, false);
        Integer oldId = null;
        if (oldServiceProvider != null) {
            oldId = oldServiceProvider.getId();
        }
        WfsCapabilitiesReader wfs = new WfsCapabilitiesReader();
        if (!this.isAbbrUnique(oldId, dynaForm, em)) {
            return "error.abbr.notunique";
        }
        String abbreviation = FormUtils.nullIfEmpty((String)dynaForm.getString("abbr"));
        if (!this.isAlphaNumeric(abbreviation)) {
            return "error.abbr.notalphanumeric";
        }
        if (abbreviation.equalsIgnoreCase(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
            return "error.abbr.reserved";
        }
        B3PCredentials credentials = new B3PCredentials();
        String username = dynaForm.getString("username");
        String password = dynaForm.getString("password");
        String url = FormUtils.nullIfEmpty((String)dynaForm.getString("url"));
        if (!username.equals("")) {
            credentials.setUserName(username);
            credentials.setPassword(password);
        }
        try {
            newServiceProvider = wfs.getProvider(url.trim(), credentials);
            newServiceProvider.setAbbr(dynaForm.getString("abbr"));
            newServiceProvider.setGivenName(dynaForm.getString("givenName"));
        }
        catch (IOException e) {
            return "error.serverconnection";
        }
        catch (Exception e) {
            this.exception = e;
            log.error((Object)"Error saving server", (Throwable)e);
            return "Error_saving";
        }
        this.populateServerObject(dynaForm, newServiceProvider);
        Set testSet = newServiceProvider.getWfsLayers();
        em.persist((Object)newServiceProvider);
        em.flush();
        for (WfsLayer wfsLayer : testSet) {
        }
        if (oldServiceProvider != null) {
            try {
                List orgList = em.createQuery("from Organization").getResultList();
                Iterator orgit = orgList.iterator();
                while (orgit.hasNext()) {
                    HashSet<WfsLayer> newOrganizationLayer = new HashSet<WfsLayer>();
                    Organization org = (Organization)orgit.next();
                    Set orgLayers = org.getWfsLayers();
                    for (WfsLayer organizationLayer : orgLayers) {
                        WfsServiceProvider orgLayerServiceProvider = organizationLayer.getWfsServiceProvider();
                        if (orgLayerServiceProvider.getId() == oldId) {
                            WfsLayer newLayer = this.checkLayer(organizationLayer, newServiceProvider.getWfsLayers());
                            if (newLayer == null) continue;
                            newOrganizationLayer.add(newLayer);
                            continue;
                        }
                        newOrganizationLayer.add(organizationLayer);
                    }
                    org.setWfsLayers(newOrganizationLayer);
                    em.flush();
                }
                Set oldLayers = oldServiceProvider.getWfsLayers();
                for (WfsLayer wfsLayer : oldLayers) {
                }
                em.remove((Object)oldServiceProvider);
                em.flush();
            }
            catch (Exception e) {
                this.exception = e;
                log.error((Object)"Error deleting the old serviceprovider", (Throwable)e);
                return "Error_deleting_old_provider";
            }
        }
        FormFile thisFile = (FormFile)dynaForm.get("uploadFile");
        Boolean overwrite = (Boolean)dynaForm.get("overwrite");
        String uploadError = null;
        if (thisFile != null && thisFile.getFileName() != null && !thisFile.getFileName().equals("")) {
            uploadError = this.uploadFile(thisFile, overwrite, abbreviation);
        }
        String[] orgSelected = dynaForm.getStrings("orgSelected");
        GroupParser.addRightsForAllLayers((String[])orgSelected, (WfsServiceProvider)newServiceProvider, (EntityManager)em);
        if (uploadError != null && !uploadError.equals("OK")) {
            return uploadError;
        }
        return "OK";
    }

    public int test(DynaValidatorForm dynaForm) throws Exception {
        EntityManager em = WFSParser.getEntityManager();
        String regexp = FormUtils.nullIfEmpty((String)dynaForm.getString("regexp"));
        String replacement = FormUtils.nullIfEmpty((String)dynaForm.getString("replacement"));
        int fout = 0;
        try {
            List wmsServices = em.createQuery("from WfsServiceProvider").getResultList();
            for (WfsServiceProvider sp : wmsServices) {
                WfsServiceProvider newSp;
                String newUrl = sp.getUrl();
                B3PCredentials credentials = sp.getCredentials();
                if (regexp != null && replacement != null && !regexp.isEmpty() && !replacement.isEmpty()) {
                    newUrl = newUrl.replaceAll(regexp, replacement);
                }
                if ((newSp = this.getTestServiceProvider(newUrl, credentials)) != null) {
                    sp.setStatus("GOED");
                    continue;
                }
                sp.setStatus("FOUT");
                ++fout;
            }
            em.flush();
        }
        catch (Exception ex) {
            log.error((Object)("Er iets iets fout gegaan tijdens het testen van de WFS Services: " + ex));
        }
        return fout;
    }

    protected void populateServerObject(DynaValidatorForm dynaForm, WfsServiceProvider serviceProvider) {
        serviceProvider.setGivenName(FormUtils.nullIfEmpty((String)dynaForm.getString("givenName")));
        serviceProvider.setUpdatedDate(new Date());
        serviceProvider.setAbbr(dynaForm.getString("abbr"));
        serviceProvider.setUsername(FormUtils.nullIfEmpty((String)dynaForm.getString("username")));
        serviceProvider.setPassword(FormUtils.nullIfEmpty((String)dynaForm.getString("password")));
    }

    public int batchUpdate(DynaValidatorForm dynaForm) throws Exception {
        return this.batchUpdate(dynaForm, "");
    }

    public int batchUpdate(DynaValidatorForm dynaForm, String prefix) throws Exception {
        EntityManager em = WFSParser.getEntityManager();
        String regexp = FormUtils.nullIfEmpty((String)dynaForm.getString("regexp"));
        String replacement = FormUtils.nullIfEmpty((String)dynaForm.getString("replacement"));
        int fout = 0;
        try {
            List wmsServices = prefix.equals("") ? em.createQuery("from WfsServiceProvider").getResultList() : em.createQuery("from WfsServiceProvider WHERE abbr=:abbr").setParameter("abbr", (Object)prefix).getResultList();
            for (WfsServiceProvider oldServiceProvider : wmsServices) {
                WfsServiceProvider newServiceProvider;
                String newUrl = oldServiceProvider.getUrl();
                B3PCredentials credentials = oldServiceProvider.getCredentials();
                if (regexp != null && replacement != null && !regexp.isEmpty() && !replacement.isEmpty()) {
                    newUrl = newUrl.replaceAll(regexp, replacement);
                }
                if ((newServiceProvider = this.getTestServiceProvider(newUrl, credentials)) != null) {
                    newServiceProvider.setStatus("GOED");
                } else {
                    oldServiceProvider.setStatus("FOUT");
                    ++fout;
                }
                if (newServiceProvider == null) continue;
                this.updateServiceProvider(oldServiceProvider, newServiceProvider);
            }
            em.flush();
        }
        catch (Exception ex) {
            log.error((Object)("Er iets iets fout gegaan tijdens de batch update van de WFS Services: " + ex));
            this.exception = ex;
        }
        return fout;
    }

    private void updateServiceProvider(WfsServiceProvider oldServiceProvider, WfsServiceProvider newServiceProvider) throws Exception {
        EntityManager em = WFSParser.getEntityManager();
        newServiceProvider.setGivenName(oldServiceProvider.getGivenName());
        newServiceProvider.setUpdatedDate(new Date());
        newServiceProvider.setAbbr(oldServiceProvider.getAbbr());
        newServiceProvider.setAllowed(oldServiceProvider.getAllowed());
        Set testSet = newServiceProvider.getWfsLayers();
        em.persist((Object)newServiceProvider);
        em.flush();
        for (WfsLayer wfsLayer : testSet) {
        }
        try {
            List orgList = em.createQuery("from Organization").getResultList();
            Iterator orgit = orgList.iterator();
            while (orgit.hasNext()) {
                HashSet<WfsLayer> newOrganizationLayer = new HashSet<WfsLayer>();
                Organization org = (Organization)orgit.next();
                Set orgLayers = org.getWfsLayers();
                for (WfsLayer organizationLayer : orgLayers) {
                    WfsServiceProvider orgLayerServiceProvider = organizationLayer.getWfsServiceProvider();
                    if (orgLayerServiceProvider.getId() == oldServiceProvider.getId()) {
                        WfsLayer newLayer = this.checkLayer(organizationLayer, newServiceProvider.getWfsLayers());
                        if (newLayer == null) continue;
                        newOrganizationLayer.add(newLayer);
                        continue;
                    }
                    newOrganizationLayer.add(organizationLayer);
                }
                org.setWfsLayers(newOrganizationLayer);
                em.flush();
            }
            Set oldLayers = oldServiceProvider.getWfsLayers();
            for (WfsLayer wfsLayer : oldLayers) {
            }
            em.remove((Object)oldServiceProvider);
            em.flush();
        }
        catch (Exception e) {
            log.error((Object)"Fout tijdens verwijderen oude serviceprovider", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteConfirm(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        this.parseMessages.clear();
        EntityManager em = WFSParser.getEntityManager();
        WfsServiceProvider serviceProvider = this.getServiceProvider(dynaForm, false);
        if (null == serviceProvider) {
            return "error.notfound";
        }
        Set serviceLayers = serviceProvider.getWfsLayers();
        if (serviceLayers.size() > 0) {
            MessageResources messages = this.getResources(request);
            Locale locale = this.getLocale(request);
            String orgJoinedMessage = messages.getMessage(locale, "beheer.server.org.joined");
            String layerJoinedMessage = messages.getMessage(locale, "beheer.server.layer.joined");
            StringBuffer strMessage = new StringBuffer();
            List orgList = em.createQuery("from Organization").getResultList();
            Iterator orgit = orgList.iterator();
            boolean notFirstOrg = false;
            while (orgit.hasNext()) {
                Organization org = (Organization)orgit.next();
                Set orgLayers = org.getWfsLayers();
                if (orgLayers.size() <= 0) continue;
                Iterator orgLayerIterator = orgLayers.iterator();
                boolean notFirstLayer = false;
                while (orgLayerIterator.hasNext()) {
                    WfsLayer orgLayer = (WfsLayer)orgLayerIterator.next();
                    for (WfsLayer serviceLayer : serviceLayers) {
                        if (!orgLayer.equals(serviceLayer)) continue;
                        if (notFirstLayer) {
                            strMessage.append(", ");
                        } else {
                            if (notFirstOrg) {
                                strMessage.append(", ");
                            } else {
                                strMessage.append(orgJoinedMessage);
                                strMessage.append(": ");
                                notFirstOrg = true;
                            }
                            strMessage.append(org.getName());
                            strMessage.append(" [");
                            strMessage.append(layerJoinedMessage);
                            strMessage.append(": ");
                            notFirstLayer = true;
                        }
                        strMessage.append(orgLayer.getName());
                    }
                }
                if (!notFirstLayer) continue;
                strMessage.append("]");
            }
            if ((strMessage.toString() == null ? "" != null : !strMessage.toString().equals("")) && strMessage != null && strMessage.length() > 0) {
                this.parseMessages.add(strMessage.toString());
            }
            List lpList = null;
            LayerCalculator lc = new LayerCalculator();
            try {
                lpList = lc.getSpLayerPricingList(serviceProvider.getAbbr(), new Date(), "WFS");
            }
            finally {
                lc.closeEntityManager();
            }
            if (lpList != null) {
                Iterator lpit = lpList.iterator();
                strMessage = new StringBuffer();
                String pricingJoinedMessage = messages.getMessage(locale, "beheer.server.pricing.joined");
                boolean notFirstPrice = false;
                while (lpit.hasNext()) {
                    LayerPricing lp = (LayerPricing)lpit.next();
                    String ln = lp.getLayerName();
                    if (strMessage.indexOf(ln) != -1) continue;
                    if (notFirstPrice) {
                        strMessage.append(", ");
                    } else {
                        strMessage.append(pricingJoinedMessage);
                        strMessage.append(": ");
                        notFirstPrice = true;
                    }
                    strMessage.append(ln);
                }
                if ((strMessage.toString() == null ? "" != null : !strMessage.toString().equals("")) && strMessage != null && strMessage.length() > 0) {
                    this.parseMessages.add(strMessage.toString());
                }
            }
        }
        return "OK";
    }

    public String delete(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WFSParser.getEntityManager();
        WfsServiceProvider serviceProvider = this.getServiceProvider(dynaForm, false);
        if (null == serviceProvider) {
            return "error.notfound";
        }
        Set serviceProviderLayers = serviceProvider.getWfsLayers();
        if (serviceProviderLayers.size() > 0) {
            List orgList = em.createQuery("from Organization").getResultList();
            for (Organization org : orgList) {
                Set orgLayers = org.getWfsLayers();
                HashSet clonedOrgLayers = new HashSet();
                clonedOrgLayers.addAll(orgLayers);
                for (WfsLayer organizationLayer : orgLayers) {
                    for (WfsLayer serviceProviderLayer : serviceProviderLayers) {
                        if (organizationLayer == null || organizationLayer.getId() != serviceProviderLayer.getId()) continue;
                        clonedOrgLayers.remove(organizationLayer);
                    }
                }
                if (orgLayers.size() == clonedOrgLayers.size()) continue;
                org.setWfsLayers(clonedOrgLayers);
                em.merge((Object)org);
            }
        }
        em.remove((Object)serviceProvider);
        em.flush();
        return "OK";
    }

    public WfsServiceProvider getServiceProvider(DynaValidatorForm dynaForm, boolean createNew) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WFSParser.getEntityManager();
        WfsServiceProvider serviceProvider = null;
        Integer id = this.getID(dynaForm);
        if (null == id && createNew) {
            serviceProvider = new WfsServiceProvider();
        } else if (null != id) {
            serviceProvider = (WfsServiceProvider)em.find(WfsServiceProvider.class, (Object)new Integer(id));
        }
        return serviceProvider;
    }

    private WfsLayer checkLayer(WfsLayer orgLayer, Set layers) {
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        for (WfsLayer layer : layers) {
            if (orgLayer.getName() == null && layer.getName() == null && orgLayer.getTitle().equalsIgnoreCase(layer.getTitle())) {
                return layer;
            }
            if (orgLayer.getName() == null || layer.getName() == null || !orgLayer.getName().equalsIgnoreCase(layer.getName())) continue;
            return layer;
        }
        return null;
    }

    private WfsServiceProvider getTestServiceProvider(String url, B3PCredentials credentials) throws Exception {
        WfsCapabilitiesReader wfs = new WfsCapabilitiesReader();
        WfsServiceProvider sp = null;
        try {
            sp = wfs.getProvider(url.trim(), credentials);
        }
        catch (IOException ioex) {
            return null;
        }
        catch (SAXException saxex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        return sp;
    }

    public boolean abbrExists(String abbr, EntityManager em) {
        try {
            WfsServiceProvider dbSp = (WfsServiceProvider)em.createQuery("from WfsServiceProvider sp where lower(sp.abbr) = lower(:abbr) ").setParameter("abbr", (Object)abbr).getSingleResult();
            return dbSp != null;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    public static void addRightsForAllLayers(String[] orgSelected, WfsServiceProvider sp, EntityManager em) throws Exception {
        GroupParser.addRightsForAllLayers((String[])orgSelected, (WfsServiceProvider)sp, (EntityManager)em);
    }

    public static void addAllLayersToGroup(Organization org, WfsServiceProvider sp, EntityManager em) throws Exception {
        GroupParser.addAllLayersToGroup((Organization)org, (WfsServiceProvider)sp, (EntityManager)em);
    }

    public List<WfsServiceProvider> getNotAllowedServices(EntityManager em) {
        try {
            List providers = em.createQuery("from WfsServiceProvider sp WHERE sp.allowed=:allowed order by givenName asc").setParameter("allowed", (Object)false).getResultList();
            return providers;
        }
        catch (Exception ex) {
            log.error((Object)"error collecting allowed WfsServiceProviders", (Throwable)ex);
            return null;
        }
    }

    public List<WfsServiceProvider> getAllowedServices(EntityManager em) {
        try {
            List providers = em.createQuery("from WfsServiceProvider sp WHERE sp.allowed=:allowed order by givenName asc").setParameter("allowed", (Object)true).getResultList();
            return providers;
        }
        catch (Exception ex) {
            log.error((Object)"error collecting allowed WfsServiceProviders", (Throwable)ex);
            return null;
        }
    }

    public void addAllowedService(String abbr, EntityManager em) throws Exception {
        WfsServiceProvider sp = this.getProviderByUrl(abbr, em);
        if (sp == null) {
            throw new Exception("Adding unknown WFS service with " + abbr);
        }
        if (sp.getAllowed().booleanValue()) {
            throw new Exception("Trying to add the service " + sp.getAbbr() + " wich is allready added.");
        }
        sp.setAllowed(Boolean.valueOf(true));
        em.persist((Object)sp);
        em.flush();
    }

    public void deleteAllowedService(String abbr, EntityManager em) throws Exception {
        WfsServiceProvider sp = this.getProviderByUrl(abbr, em);
        if (sp == null) {
            throw new Exception("Deleting unknown WFS service with name " + abbr);
        }
        if (!sp.getAllowed().booleanValue()) {
            throw new Exception("Trying to delete the service " + sp.getAbbr() + " wich is not added.");
        }
        sp.setAllowed(Boolean.valueOf(false));
        em.persist((Object)sp);
        em.flush();
    }

    public void deleteAllAllowedServices(EntityManager em) {
        em.createQuery("UPDATE WfsServiceProvider SET allowed=false").executeUpdate();
    }

    private WfsServiceProvider getProviderByUrl(String abbr, EntityManager em) {
        try {
            WfsServiceProvider dbSp = (WfsServiceProvider)em.createQuery("from WfsServiceProvider sp where sp.abbr=:abbr ").setParameter("abbr", (Object)abbr).getSingleResult();
            return dbSp;
        }
        catch (Exception ex) {
            log.error((Object)"error locating WfsServiceProvider", (Throwable)ex);
            return null;
        }
    }
}

