/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DOMValidator;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.kaartenbalie.service.servlet.CallWMSServlet;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.WMSCapabilitiesReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class GetCapabilitiesRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(GetCapabilitiesRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        dw.setHeader("Content-Disposition", "inline; filename=\"GetCapabilities.xml\";");
        dw.setContentType("application/vnd.ogc.wms_xml");
        String spAbbrUrl = dw.getOgcrequest().getServiceProviderName();
        ByteArrayOutputStream output = null;
        if (user != null) {
            this.user = user;
            this.url = user.getPersonalURL(dw.getRequest(), spAbbrUrl);
        }
        if (this.url == null) {
            throw new Exception("No personal url for user found.");
        }
        boolean isAdmin = false;
        if ("true".equalsIgnoreCase(dw.getOgcrequest().getParameter("_VIEWER_CONFIG"))) {
            Set userRoles = user.getRoles();
            for (Roles role : userRoles) {
                if (!role.getRole().equalsIgnoreCase("beheerder")) continue;
                isAdmin = true;
                break;
            }
        }
        if ("true".equalsIgnoreCase(dw.getOgcrequest().getParameter("_FORCE_FETCH"))) {
            this.forceFetch(dw, isAdmin);
        }
        ServiceProvider s = this.getServiceProvider(isAdmin, spAbbrUrl);
        if (user != null) {
            s.setOrganizationCode(user.getOrganisationCodes());
            s.setExpireDate(user.getTimeout());
            s.setUserName(user.getName());
            s.setPersonalCode(user.getPersonalURL());
        }
        HashMap<String, String> conversionValues = new HashMap<String, String>();
        conversionValues.put("url", this.url);
        s.convertValues2KB(conversionValues);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        DOMImplementation di = db.getDOMImplementation();
        DocumentType dt = di.createDocumentType("WMT_MS_Capabilities", null, CallWMSServlet.CAPABILITIES_DTD);
        Document dom = di.createDocument(null, "WMT_MS_Capabilities", dt);
        Element rootElement = dom.getDocumentElement();
        rootElement = s.toElement(dom, rootElement);
        rootElement.setAttribute("version", "1.1.1");
        OutputFormat format = new OutputFormat(dom, "UTF-8", true);
        format.setIndenting(true);
        output = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)output, format);
        serializer.serialize(dom);
        DOMValidator dv = new DOMValidator();
        dv.parseAndValidate(new ByteArrayInputStream(output.toString().getBytes("UTF-8")));
        dw.write(output);
    }

    private void forceFetch(DataWrapper dw, boolean isAdmin) throws Exception {
        DataMonitoring rr = dw.getRequestReporting();
        String spAbbrUrl = dw.getOgcrequest().getServiceProviderName();
        Set serviceProviders = this.getServiceProviders(isAdmin, spAbbrUrl);
        for (Object serviceProvider : serviceProviders) {
            ServiceProvider sp = (ServiceProvider)serviceProvider;
            long startprocestime = System.currentTimeMillis();
            ServiceProviderRequest wmsRequest = new ServiceProviderRequest();
            wmsRequest.setMsSinceRequestStart(new Long(rr.getMSSinceStart()));
            wmsRequest.setServiceProviderId(sp.getId());
            wmsRequest.setWmsVersion(sp.getWmsVersion());
            WMSCapabilitiesReader wms = new WMSCapabilitiesReader();
            try {
                OGCRequest or = new OGCRequest(sp.getUrl());
                or.addOrReplaceParameter("REQUEST", "GetCapabilities");
                or.addOrReplaceParameter("SERVICE", "WMS");
                or.addOrReplaceParameter("VERSION", sp.getWmsVersion());
                String url = or.getUrl();
                wmsRequest.setProviderRequestURI(url);
                wmsRequest.setBytesSent(Long.valueOf(url.getBytes().length));
                ByteArrayOutputStream baos = wms.getCapabilities(url);
                String xml = baos.toString("UTF-8");
                wmsRequest.setResponseStatus(new Integer(200));
                wmsRequest.setRequestResponseTime(Long.valueOf(System.currentTimeMillis() - startprocestime));
                wmsRequest.setBytesReceived(Long.valueOf(xml.getBytes().length));
                wmsRequest.setMessageReceived(xml);
            }
            catch (Exception e) {
                wmsRequest.setExceptionMessage("Failed to send bytes to client: " + e.getMessage());
                wmsRequest.setExceptionClass(e.getClass());
                throw e;
            }
            finally {
                rr.addServiceProviderRequest(wmsRequest);
            }
        }
    }
}

