/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.URLCache;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.servlet.GeneralServlet;
import nl.b3p.ogc.sld.SldWriter;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxySLDServlet
extends GeneralServlet {
    public static final String PARAM_ORIGINAL_SLD_URL = "oriSldUrl";
    public static final String PARAM_ORIGINAL_SLD_BODY = "oriSldBody";
    public static final String PARAM_SERVICEPROVIDER_ID = "servProvId";
    public static final String PARAM_STYLES = "styles";
    public static final String mimeType = "application/xml";
    private static final URLCache cache = new URLCache(60000);
    private static final Log log = LogFactory.getLog(ProxySLDServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            String oriSldBody = request.getParameter(PARAM_ORIGINAL_SLD_BODY);
            log.debug((Object)("Incoming sld body: " + oriSldBody));
            String oriSldUrl = request.getParameter(PARAM_ORIGINAL_SLD_URL);
            log.debug((Object)("Incoming sld url: " + oriSldUrl));
            String styleString = request.getParameter(PARAM_STYLES);
            log.debug((Object)("Incoming sld style id's: " + styleString));
            String spId = request.getParameter(PARAM_SERVICEPROVIDER_ID);
            log.debug((Object)("Incoming sld sp id: " + styleString));
            SldWriter sldFact = new SldWriter();
            if (oriSldBody != null && oriSldBody.length() > 0) {
                sldFact.parseString(oriSldBody, null);
            } else if (oriSldUrl != null && oriSldUrl.length() > 0) {
                String sld = cache.getFromCache(oriSldUrl);
                sldFact.parseString(sld, null);
            } else if (styleString != null && styleString.length() > 0) {
                List styles = em.createQuery("from Style where id in (" + styleString + ")").getResultList();
                sldFact.addNamedLayers(sldFact.createNamedLayersWithKBStyles(styles));
            }
            if (spId != null && spId.length() > 0) {
                String spAbbr = null;
                ArrayList<String> spLayerNames = new ArrayList<String>();
                Integer servProvId = null;
                try {
                    servProvId = new Integer(spId);
                    ServiceProvider sp = (ServiceProvider)em.find(ServiceProvider.class, (Object)servProvId);
                    if (sp != null) {
                        spAbbr = sp.getAbbr();
                        for (Layer l : sp.getAllLayers()) {
                            spLayerNames.add(l.getName());
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)"Fout parsen serviceprovider id.");
                }
                sldFact.replaceAndFilterOnNames(spAbbr, spLayerNames);
            }
            String xml = sldFact.createSLD();
            response.setContentType(mimeType);
            log.debug((Object)("Returned sld: \n" + xml));
            response.getWriter().write(xml);
        }
        catch (Exception ex) {
            response.getWriter().write("Error while getting SLD. Check the log for details");
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
    }

    public static void addSLDToCache(String sldUrl) {
        cache.cacheUrl(sldUrl, false);
    }

    public static void clearCache() {
        cache.clearCache();
    }

    public void parseRequestAndData(DataWrapper data, User user) throws IllegalArgumentException, UnsupportedOperationException, IOException, Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServletInfo() {
        return "";
    }
}

