/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.monitoring;

import java.util.Iterator;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ClientRequest;
import nl.b3p.kaartenbalie.core.server.monitoring.Operation;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataMonitoring {
    private static final Log log = LogFactory.getLog(DataMonitoring.class);
    private User user;
    private Organization organization;
    private ClientRequest clientRequest;
    private long operationStartTime;
    private Operation requestOperation;
    private static boolean enableMonitoring = false;

    public static void setEnableMonitoring(boolean state) {
        enableMonitoring = state;
    }

    public void setUserAndOrganization(User user, Organization organization) {
        this.user = user;
        this.organization = organization;
    }

    public void startClientRequest(String clientRequestURI, int bytesReceivedFromUser, long operationStartTime, String clientIp, String method) {
        if (!DataMonitoring.isEnableMonitoring()) {
            return;
        }
        this.operationStartTime = operationStartTime;
        this.requestOperation = new Operation();
        this.requestOperation.setType(5);
        this.requestOperation.setMsSinceRequestStart(new Long(this.getMSSinceStart()));
        this.requestOperation.setBytesReceivedFromUser(new Integer(bytesReceivedFromUser));
        this.clientRequest = new ClientRequest();
        this.clientRequest.setClientRequestURI(clientRequestURI);
        this.clientRequest.setMethod(method);
        this.clientRequest.setClientIp(clientIp);
    }

    public long getMSSinceStart() {
        return System.currentTimeMillis() - this.operationStartTime;
    }

    public void addServiceProviderRequest(ServiceProviderRequest s) throws Exception {
        if (!DataMonitoring.isEnableMonitoring()) {
            return;
        }
        if (this.clientRequest == null) {
            return;
        }
        this.clientRequest.getServiceProviderRequests().add(s);
    }

    public void addRequestOperation(Operation o) throws Exception {
        if (!DataMonitoring.isEnableMonitoring()) {
            return;
        }
        if (this.clientRequest == null) {
            return;
        }
        this.clientRequest.getRequestOperations().add(o);
    }

    public void setClientRequestException(Exception ex) {
        if (this.clientRequest == null) {
            return;
        }
        this.clientRequest.setExceptionClass(ex.getClass());
        this.clientRequest.setExceptionMessage(ex.getMessage());
    }

    public void endClientRequest(String service, String operation, int bytesSentToUser, long totalResponseTime) {
        if (!DataMonitoring.isEnableMonitoring()) {
            return;
        }
        if (this.clientRequest == null) {
            return;
        }
        try {
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            this.requestOperation.setDuration(new Long(totalResponseTime));
            this.requestOperation.setBytesSentToUser(new Integer(bytesSentToUser));
            this.addRequestOperation(this.requestOperation);
            this.clientRequest.setService(service);
            this.clientRequest.setOperation(operation);
            this.clientRequest.setUser(this.user);
            this.clientRequest.setOrganization(this.organization);
            Iterator iterRO = this.clientRequest.getRequestOperations().iterator();
            while (iterRO.hasNext()) {
                em.persist(iterRO.next());
            }
            Iterator iterSPR = this.clientRequest.getServiceProviderRequests().iterator();
            while (iterSPR.hasNext()) {
                em.persist(iterSPR.next());
            }
            em.persist((Object)this.clientRequest);
            em.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error logging request", (Throwable)e);
        }
        this.clientRequest = null;
    }

    public static Element createElement(Document doc, String createElementName, String textContent) {
        Element tmpElement = doc.createElement(createElementName);
        tmpElement.setTextContent(textContent);
        return tmpElement;
    }

    public static boolean isEnableMonitoring() {
        return enableMonitoring;
    }
}

