/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.dwr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.LayerTreeSupport;
import nl.b3p.ogc.ServiceProviderInterface;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class RightsSupport {
    private static final Log log = LogFactory.getLog(RightsSupport.class);

    public String getRightsTree(Map<String, String> params) throws Exception {
        if (!this.checkAccess()) {
            return null;
        }
        Organization org = this.getOrganization(params);
        ServiceProviderInterface sp = this.getServiceProvider(params);
        JSONObject tree = this.populateRightsTree(sp, org);
        return tree.toString();
    }

    private JSONObject populateRightsTree(ServiceProviderInterface sp, Organization org) throws Exception {
        JSONObject header = new JSONObject();
        header.put("name", (Object)"Tree Header");
        header.put("id", (Object)"header");
        JSONArray headerArray = new JSONArray();
        header.put("children", (Object)headerArray);
        if (sp == null) {
            return header;
        }
        JSONObject root = new JSONObject();
        root.put("name", (Object)sp.getGivenName());
        root.put("id", (Object)("ogc" + sp.getId().toString()));
        root.put("type", (Object)"serviceprovider");
        headerArray.put((Object)root);
        if (org == null) {
            return header;
        }
        HashSet<Layer> layerSet = new HashSet<Layer>();
        if (sp instanceof ServiceProvider) {
            Set orgWmsLayers = org.getLayers();
            Layer topLayer = ((ServiceProvider)sp).getTopLayer();
            if (topLayer != null) {
                layerSet.add(topLayer);
                root = LayerTreeSupport.createTreeList(layerSet, (Set)orgWmsLayers, (JSONObject)root, (boolean)false);
            }
        } else if (sp instanceof WfsServiceProvider) {
            Set orgWfsLayers = org.getWfsLayers();
            Set layers = ((WfsServiceProvider)sp).getWfsLayers();
            layerSet.addAll(layers);
            root = LayerTreeSupport.createWfsTreeList(layerSet, (Set)orgWfsLayers, (JSONObject)root, (boolean)false);
        }
        return header;
    }

    public List<String> submitRightsForm(Map<String, String> params) throws Exception {
        Set orgWfsLayerSet;
        if (!this.checkAccess()) {
            return null;
        }
        Organization org = this.getOrganization(params);
        ServiceProviderInterface sp = this.getServiceProvider(params);
        String selectedLayers = params.get("selectedLayers");
        ArrayList<String> layers = new ArrayList<String>();
        if (org == null) {
            return layers;
        }
        HashSet<Layer> wmsLayers = new HashSet<Layer>();
        HashSet<WfsLayer> wfsLayers = new HashSet<WfsLayer>();
        Set orgWmsLayerSet = org.getLayers();
        if (orgWmsLayerSet != null) {
            for (Layer l : orgWmsLayerSet) {
                ServiceProvider layerSp = l.getServiceProvider();
                if (sp == null || layerSp == null || layerSp.getAbbr().equals(sp.getAbbr())) continue;
                wmsLayers.add(l);
                String label = l.getName();
                if (label == null) {
                    label = l.getTitle() + "(*)";
                }
                String lname = label + " (wms, " + l.getServiceProvider().getAbbr() + ")";
                layers.add(lname);
            }
        }
        if ((orgWfsLayerSet = org.getWfsLayers()) != null) {
            for (WfsLayer l : orgWfsLayerSet) {
                WfsServiceProvider layerSp = l.getWfsServiceProvider();
                if (layerSp.getAbbr().equals(sp.getAbbr())) continue;
                wfsLayers.add(l);
                String label = l.getName();
                if (label == null) {
                    label = l.getTitle() + "(*)";
                }
                String lname = label + " (wfs, " + l.getWfsServiceProvider().getAbbr() + ")";
                layers.add(lname);
            }
        }
        EntityManager em = MyEMFDatabase.getEntityManager((String)"dwrEM");
        if (selectedLayers != null && selectedLayers.length() > 0) {
            for (String layerName : selectedLayers.split(",")) {
                Layer wmsl;
                WfsLayer wfsl = LayerTreeSupport.getWfsLayerByUniqueName((EntityManager)em, (String)layerName);
                if (wfsl != null) {
                    wfsLayers.add(wfsl);
                    String label = wfsl.getName();
                    if (label == null) {
                        label = wfsl.getTitle() + "(*)";
                    }
                    String lname = label + " (wfs, " + wfsl.getWfsServiceProvider().getAbbr() + ")";
                    layers.add(lname);
                }
                if ((wmsl = LayerTreeSupport.getLayerByUniqueName((EntityManager)em, (String)layerName)) == null) continue;
                wmsLayers.add(wmsl);
                String label = wmsl.getName();
                if (label == null) {
                    label = wmsl.getTitle() + "(*)";
                }
                String lname = label + " (wms, " + wmsl.getServiceProvider().getAbbr() + ")";
                layers.add(lname);
            }
        }
        org.setWfsLayers(wfsLayers);
        org.setLayers(wmsLayers);
        Collections.sort(layers);
        return layers;
    }

    public List<String> getValidLayers(Map<String, String> params) throws Exception {
        Set orgWfsLayerSet;
        if (!this.checkAccess()) {
            return null;
        }
        ArrayList<String> layers = new ArrayList<String>();
        Organization org = this.getOrganization(params);
        if (org == null) {
            return layers;
        }
        Set orgWmsLayerSet = org.getLayers();
        if (orgWmsLayerSet != null) {
            for (Layer l : orgWmsLayerSet) {
                String label = l.getName();
                if (label == null) {
                    label = l.getTitle() + "(*)";
                }
                String lname = label + " (wms, " + l.getServiceProvider().getAbbr() + ")";
                layers.add(lname);
            }
        }
        if ((orgWfsLayerSet = org.getWfsLayers()) != null) {
            for (WfsLayer l : orgWfsLayerSet) {
                String label = l.getName();
                if (label == null) {
                    label = l.getTitle() + "(*)";
                }
                String lname = label + " (wfs, " + l.getWfsServiceProvider().getAbbr() + ")";
                layers.add(lname);
            }
        }
        Collections.sort(layers);
        return layers;
    }

    private Organization getOrganization(Map<String, String> params) throws Exception {
        Integer orgId = FormUtils.StringToInteger((String)params.get("orgId"));
        if (orgId == null) {
            return null;
        }
        EntityManager em = MyEMFDatabase.getEntityManager((String)"dwrEM");
        return (Organization)em.find(Organization.class, (Object)orgId);
    }

    private ServiceProviderInterface getServiceProvider(Map<String, String> params) throws Exception {
        Integer spId = FormUtils.StringToInteger((String)params.get("id"));
        String spType = params.get("type");
        if (spId == null || spId == 0) {
            return null;
        }
        if (spType == null) {
            return null;
        }
        EntityManager em = MyEMFDatabase.getEntityManager((String)"dwrEM");
        ServiceProviderInterface sp = null;
        if ("WMS".equalsIgnoreCase(spType)) {
            sp = (ServiceProviderInterface)em.find(ServiceProvider.class, (Object)new Integer(spId));
        } else if ("WFS".equalsIgnoreCase(spType)) {
            sp = (ServiceProviderInterface)em.find(WfsServiceProvider.class, (Object)new Integer(spId));
        }
        return sp;
    }

    private boolean checkAccess() {
        User user;
        WebContext ctx = WebContextFactory.get();
        HttpServletRequest request = null;
        if (ctx != null) {
            request = ctx.getHttpServletRequest();
        }
        return (user = (User)request.getUserPrincipal()) != null && user.checkRole("beheerder");
    }
}

