/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;

public class CachedUrl
extends Thread {
    public static int CREATED = 0;
    public static int LOADING = 1;
    public static int FINISHED = 2;
    public static int ERRORED = 9;
    private Date creationDate;
    private String url;
    private String content;
    private int status = CREATED;
    private String charSet = "UTF-8";
    private Object monitor;

    public CachedUrl(String url, Object monitor) {
        this.url = url;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            URL theUrl = new URL(this.url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(theUrl.openStream(), this.charSet));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            this.content = sb.toString();
            this.status = FINISHED;
        }
        catch (Exception e) {
            this.status = ERRORED;
            this.content = e.toString() + ": " + e.getMessage();
        }
        finally {
            this.creationDate = new Date();
            System.out.println("Notify all!");
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

