/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.annotations.GlobalFilter;

@GlobalFilter
public class DwrTransactionFilter
implements AjaxFilter {
    private static final Log log = LogFactory.getLog(DwrTransactionFilter.class);

    public Object doFilter(Object obj, Method method, Object[] params, AjaxFilterChain chain) throws Exception {
        EntityManager em = null;
        EntityTransaction tx = null;
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"dwrEM");
            em = MyEMFDatabase.getEntityManager((String)"dwrEM");
            tx = em.getTransaction();
            tx.begin();
            Object ret = chain.doFilter(obj, method, params);
            if (tx != null && tx.isActive()) {
                log.debug((Object)"Committing active transaction");
                tx.commit();
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            log.error((Object)("Exception occured during DWR call" + (tx.isActive() ? ", rolling back transaction" : " - no transaction active")), (Throwable)e);
            if (tx.isActive()) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    log.error((Object)"Exception rolling back transaction", (Throwable)e2);
                }
            }
            throw e;
        }
        finally {
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"dwrEM");
        }
    }
}

