/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nl.b3p.kaartenbalie.service.MapFileListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;

public class MapFileScanner
implements ServletContextListener {
    private Log log = LogFactory.getLog(this.getClass());
    private static String scandirectory;
    private static String organization;
    private ServletContext context;
    private FileSystemManager fsManager;
    private DefaultFileMonitor fm;
    private FileObject listendir;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.context = sce.getServletContext();
            this.init();
            this.fsManager = VFS.getManager();
            this.listendir = this.fsManager.resolveFile(scandirectory);
            this.fm = new DefaultFileMonitor((FileListener)new MapFileListener(organization));
            this.fm.setRecursive(true);
            this.fm.addFile(this.listendir);
            this.fm.start();
        }
        catch (FileSystemException ex) {
            this.log.error((Object)"Cannot initialize MapFileScanner: ", (Throwable)ex);
        }
    }

    private void init() {
        scandirectory = this.context.getInitParameter("global.mapfile.dir");
        organization = this.context.getInitParameter("default.organization");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.fm != null) {
            this.fm.stop();
        }
        if (this.fsManager != null && this.listendir != null) {
            this.fsManager.closeFileSystem(this.listendir.getFileSystem());
        }
    }
}

