/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class MapParser {
    private final File mapFile;
    private Map<String, String> webMetadata = new HashMap();

    public MapParser(File mapFile) throws IOException {
        if (!mapFile.getName().toLowerCase().endsWith(".map")) {
            throw new IOException("File is not a .map file");
        }
        this.mapFile = mapFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws FileNotFoundException, IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.mapFile);
            InputStreamReader converter = new InputStreamReader(in);
            BufferedReader buffer = new BufferedReader(converter);
            String line = "";
            line = buffer.readLine();
            if (line != null) {
                this.parseMap(line, buffer);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    private void parseMap(String line, BufferedReader buffer) throws IOException {
        while ((line = buffer.readLine()) != null) {
            if (!line.trim().toUpperCase().equals("WEB")) continue;
            this.parseWeb(line, buffer);
            break;
        }
    }

    private void parseWeb(String line, BufferedReader buffer) throws IOException {
        while ((line = buffer.readLine()) != null) {
            if (!line.trim().toUpperCase().equals("METADATA")) continue;
            this.parseMetaData(line, buffer);
            break;
        }
    }

    private void parseMetaData(String line, BufferedReader buffer) throws IOException {
        while ((line = buffer.readLine()) != null) {
            if (line.trim().toLowerCase().indexOf("wms_title") >= 0) {
                this.webMetadata.put("wms_title", this.lastFromSplitLine(line));
                continue;
            }
            if (line.trim().toLowerCase().indexOf("wms_onlineresource") >= 0) {
                this.webMetadata.put("wms_onlineresource", this.lastFromSplitLine(line));
                continue;
            }
            if (line.trim().toLowerCase().indexOf("wms_srs") >= 0) {
                this.webMetadata.put("wms_srs", this.lastFromSplitLine(line));
                continue;
            }
            if (!line.trim().toUpperCase().equals("END")) continue;
            break;
        }
    }

    private String[] splitLine(String line) {
        if (line == null) {
            return null;
        }
        String[] splitLine = null;
        line = line.replace('\'', '\"');
        splitLine = line.split("\"");
        return splitLine;
    }

    private String lastFromSplitLine(String line) {
        String[] splitLine = this.splitLine(line);
        for (int i = splitLine.length - 1; i >= 0; --i) {
            String lineFrag = splitLine[i].trim();
            if (lineFrag.length() <= 0) continue;
            return lineFrag;
        }
        return null;
    }

    public Map<String, String> getWebMetadata() {
        return this.webMetadata;
    }
}

