/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Layer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(MetadataRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        Layer layer;
        OGCRequest ogcrequest = dw.getOgcrequest();
        String mdLayer = ogcrequest.getParameter("LAYER");
        if (mdLayer == null || mdLayer.length() == 0) {
            throw new Exception("Layer name is required, but not provided!");
        }
        dw.setHeader("Content-Disposition", "inline; filename=\"" + mdLayer + ".xml\";");
        dw.setContentType("text/xml");
        this.user = user;
        String spAbbr = dw.getOgcrequest().getServiceProviderName();
        if (spAbbr != null && !spAbbr.equals("")) {
            mdLayer = OGCCommunication.attachSp((String)spAbbr, (String)mdLayer);
        }
        if ((layer = this.getLayerByUniqueName(mdLayer)) == null) {
            throw new Exception("Layer not found with name: " + mdLayer);
        }
        if (layer.getMetadata() == null) {
            throw new Exception("Metadata for layer not found with name: " + mdLayer);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String md = layer.getMetadata();
        baos.write(md.getBytes());
        dw.write(baos);
    }
}

