/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WFSGetFeatureRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.WFSRequestHandler;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.ogc.utils.WFSTransactionResponse;
import nl.b3p.xml.wfs.v110.Delete;
import nl.b3p.xml.wfs.v110.Insert;
import nl.b3p.xml.wfs.v110.Update;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class WFSTransactionRequestHandler
extends WFSRequestHandler {
    private static final Log log = LogFactory.getLog(WFSGetFeatureRequestHandler.class);

    public List replaceLayerNames(List elementList, String spAbbr) throws Exception {
        ArrayList<Object> newElementList = new ArrayList<Object>();
        for (Object o : elementList) {
            String oldId;
            LayerSummary m;
            if (o instanceof Delete) {
                Delete delete = (Delete)o;
                m = OGCCommunication.splitLayerWithoutNsFix((String)delete.getTypeName(), (spAbbr != null ? 1 : 0) != 0, null, (String)"app");
                delete.setTypeName(OGCCommunication.buildFullLayerName((LayerSummary)m));
                oldId = delete.getFilter().getGmlObjectId().getId().toString();
                delete.getFilter().getGmlObjectId().setId((Object)OGCCommunication.replaceIds((String)oldId, (String)spAbbr, null));
                newElementList.add(delete);
                continue;
            }
            if (o instanceof Update) {
                Update update = (Update)o;
                m = OGCCommunication.splitLayerWithoutNsFix((String)update.getTypeName(), (spAbbr != null ? 1 : 0) != 0, null, (String)"app");
                update.setTypeName(OGCCommunication.buildFullLayerName((LayerSummary)m));
                oldId = update.getFilter().getGmlObjectId().getId().toString();
                update.getFilter().getGmlObjectId().setId((Object)OGCCommunication.replaceIds((String)oldId, (String)spAbbr, null));
                newElementList.add(update);
                continue;
            }
            if (!(o instanceof Insert)) continue;
            Insert insert = (Insert)o;
            StringWriter sw = new StringWriter();
            Marshaller m2 = new Marshaller((Writer)sw);
            m2.marshal((Object)insert);
            String makeInsert = OGCCommunication.replaceIds((String)sw.toString(), (String)spAbbr, (String)"app");
            Insert newInsert = (Insert)Unmarshaller.unmarshal(Insert.class, (Reader)new StringReader(makeInsert));
            newElementList.add(newInsert);
        }
        return newElementList;
    }

    public String prepareRequest4Sp(OGCRequest ogcrequest, SpLayerSummary sp) throws Exception {
        String prefix = sp.getSpAbbr();
        List elementList = ogcrequest.getTransactionElementList(prefix);
        List newElementList = this.replaceLayerNames(elementList, prefix);
        ogcrequest.setTransactionElementList(newElementList, prefix);
        ogcrequest.setAbbr(prefix);
        return null;
    }

    public List<LayerSummary> prepareRequestLayers(OGCRequest ogcrequest) throws Exception {
        if (ogcrequest.getParameter("OPERATION") != null) {
            throw new UnsupportedOperationException("Transaction request with Key value Pairs is not suported yet!");
        }
        List<String> allLayers = null;
        if (ogcrequest.getHttpMethod().equals("POST")) {
            Set layers = ogcrequest.getGetFeatureFilterMap().keySet();
            allLayers.addAll(layers);
        } else {
            String typeName = ogcrequest.getParameter("TYPENAME");
            allLayers = Arrays.asList(typeName.split(","));
        }
        String spInUrl = ogcrequest.getServiceProviderName();
        List lsl = LayerSummary.createLayerSummaryList(allLayers, (String)ogcrequest.getServiceProviderName(), (spInUrl == null ? 1 : 0) != 0);
        if (!this.checkNumberOfSps(lsl, 1)) {
            log.error((Object)"More then 1 service provider addressed. Not supported (yet)");
            throw new UnsupportedOperationException("More then 1 service provider addressed. Not supported (yet)");
        }
        return lsl;
    }

    public OGCResponse getNewOGCResponse() {
        return new WFSTransactionResponse();
    }

    public void getRequest(DataWrapper data, User user) throws IOException, Exception {
        this.writeResponse(data, user);
    }
}

