/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.HtmlEmail;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Mailer {
    protected Log log = LogFactory.getLog(this.getClass());
    private String mailTo = null;
    private String mailFrom = null;
    private String subject = null;
    private String mailCc = null;
    private String mailBcc = null;
    private String mailHost = null;
    private String body = null;
    private String attachment = null;
    private String attachmentName = null;
    private DataSource attachmentDataSource = null;
    private String mailer = null;
    private String footer = null;
    private Hashtable extraParams = null;
    private MessageResources messages = null;
    private Locale locale = null;
    private HttpSession session = null;
    private String xsl = null;
    private boolean returnReceipt = false;

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMailCc() {
        return this.mailCc;
    }

    public void setMailCc(String mailCc) {
        this.mailCc = mailCc;
    }

    public String getMailBcc() {
        return this.mailBcc;
    }

    public void setMailBcc(String mailBcc) {
        this.mailBcc = mailBcc;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String mailHost) {
        this.mailHost = mailHost;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getMailer() {
        return this.mailer;
    }

    public void setMailer(String mailer) {
        this.mailer = mailer;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void send() throws AddressException, MessagingException, IOException, Exception {
        this.send(null);
    }

    public ActionMessages send(ActionMessages errors) throws AddressException, MessagingException, IOException, Exception {
        int i;
        HtmlEmail email = new HtmlEmail();
        String[] ds = null;
        if (this.mailTo != null && this.mailTo.trim().length() != 0) {
            ds = this.mailTo.split(",");
            for (i = 0; i < ds.length; ++i) {
                email.addTo(ds[i]);
            }
        }
        if (this.mailCc != null && this.mailCc.trim().length() != 0) {
            ds = this.mailCc.split(",");
            for (i = 0; i < ds.length; ++i) {
                email.addCc(ds[i]);
            }
        }
        if (this.mailBcc != null && this.mailBcc.trim().length() != 0) {
            ds = this.mailBcc.split(",");
            for (i = 0; i < ds.length; ++i) {
                email.addBcc(ds[i]);
            }
        }
        email.setFrom(this.mailFrom);
        email.setSubject(this.subject);
        email.setHostName(this.mailHost);
        if (this.isReturnReceipt()) {
            email.addHeader("Disposition-Notification-To", this.mailFrom);
        }
        if (this.attachmentName == null) {
            this.attachmentName = "attachment";
        }
        if (this.attachment != null) {
            URL attachUrl = null;
            try {
                attachUrl = new URL(this.attachment);
                email.attach(attachUrl, this.attachmentName, this.attachmentName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.attachmentDataSource != null) {
            email.attach(this.attachmentDataSource, this.attachmentName, this.attachmentName);
        }
        email.setMsg(this.createHTML());
        email.send();
        return errors;
    }

    protected List convertDelim2ArrayList(String delim) {
        if (delim == null) {
            return null;
        }
        String[] ds = delim.split(",");
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < ds.length; ++i) {
            al.add(ds[i]);
        }
        return al;
    }

    public Document createFormDOM() throws DOMException, ParserConfigurationException {
        Document doc = XMLUtils.newDocument();
        Element rootElement = doc.createElement("root");
        doc.appendChild(rootElement);
        Element element = doc.createElement("to");
        Text text = doc.createTextNode(this.mailTo + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("from");
        text = doc.createTextNode(this.mailFrom + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("subject");
        text = doc.createTextNode(this.subject + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("body");
        text = doc.createTextNode(this.body + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("cc");
        text = doc.createTextNode(this.mailCc + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("bcc");
        text = doc.createTextNode(this.mailBcc + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("attachment");
        text = doc.createTextNode(this.attachment + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        element = doc.createElement("footer");
        text = doc.createTextNode(this.footer + "");
        element.appendChild(text);
        rootElement.appendChild(element);
        if (this.extraParams != null) {
            Enumeration cenum = this.extraParams.keys();
            while (cenum.hasMoreElements()) {
                String theParameter = (String)cenum.nextElement();
                if (theParameter == null) continue;
                element = doc.createElement(theParameter);
                text = doc.createTextNode((String)this.extraParams.get(theParameter));
                element.appendChild(text);
                rootElement.appendChild(element);
            }
        }
        return doc;
    }

    protected String createHTML() throws FileNotFoundException, Exception, TransformerConfigurationException, TransformerException, ParserConfigurationException {
        Document xml = this.createFormDOM();
        if (xml == null) {
            throw new Exception("No XML created!");
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        File xslFile = new File(MyEMFDatabase.localPath((String)this.xsl));
        File xmlPath = new File(xslFile.getParent());
        SAXSource xslSource = new SAXSource(new InputSource(new FileInputStream(xslFile)));
        xslSource.setSystemId(xmlPath.toURI().toString());
        Transformer transformer = tf.newTransformer(xslSource);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(xml), new StreamResult(output));
        return output.toString();
    }

    protected String createTxt() {
        StringBuffer ib = new StringBuffer();
        boolean doAdd = false;
        if (this.extraParams.get("fullname") != null && !this.extraParams.get("fullname").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.fullname"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("fullname"));
            doAdd = true;
        }
        if (this.extraParams.get("company") != null && !this.extraParams.get("company").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.company"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("company"));
            doAdd = true;
        }
        if (this.extraParams.get("address") != null && !this.extraParams.get("address").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.address"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("address"));
            doAdd = true;
        }
        if (this.extraParams.get("zipcode") != null && !this.extraParams.get("zipcode").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.zipcode"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("zipcode"));
            doAdd = true;
        }
        if (this.extraParams.get("city") != null && !this.extraParams.get("city").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.city"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("city"));
            doAdd = true;
        }
        if (this.extraParams.get("country") != null && !this.extraParams.get("country").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.country"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("country"));
            doAdd = true;
        }
        if (this.extraParams.get("phone") != null && !this.extraParams.get("phone").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.phone"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("phone"));
            doAdd = true;
        }
        if (this.extraParams.get("fax") != null && !this.extraParams.get("fax").equals("")) {
            ib.append("\n");
            ib.append(this.getMessages().getMessage(this.locale, "message.fax"));
            ib.append(" ");
            ib.append((String)this.extraParams.get("fax"));
            doAdd = true;
        }
        StringBuffer sb = new StringBuffer();
        if (doAdd) {
            sb.append(this.getMessages().getMessage(this.locale, "message.requestor"));
            sb.append("\n");
            sb.append(ib.toString());
            sb.append("\n\n\n");
        }
        ib = new StringBuffer();
        doAdd = false;
        Enumeration cenum = this.extraParams.keys();
        while (cenum.hasMoreElements()) {
            String theParameter = (String)cenum.nextElement();
            if (theParameter == null) continue;
            String theValue = (String)this.extraParams.get(theParameter);
            if (theParameter.equals("fullname") || theParameter.equals("company") || theParameter.equals("address") || theParameter.equals("zipcode") || theParameter.equals("receipt") || theParameter.equals("city") || theParameter.equals("country") || theParameter.equals("phone") || theParameter.equals("fax")) continue;
            ib.append("\n");
            ib.append(theParameter);
            if (!theValue.equals("on")) {
                ib.append(" ");
                ib.append(theValue);
            }
            doAdd = true;
        }
        if (doAdd) {
            sb.append(this.getMessages().getMessage(this.locale, "message.inquiry"));
            sb.append("\n");
            sb.append(ib.toString());
            sb.append("\n\n\n");
        }
        if (this.body != null && !this.body.equals("")) {
            sb.append(this.getMessages().getMessage(this.locale, "message.body"));
            sb.append("\n");
            sb.append(this.body);
        }
        if (this.footer != null) {
            sb.append("\n\n\n");
            sb.append(this.footer);
        }
        return sb.toString();
    }

    public Hashtable getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(Hashtable extraParams) {
        this.extraParams = extraParams;
    }

    public MessageResources getMessages() {
        return this.messages;
    }

    public void setMessages(MessageResources messages) {
        this.messages = messages;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public String getXsl() {
        return this.xsl;
    }

    public void setXsl(String xsl) {
        this.xsl = xsl;
    }

    public boolean isReturnReceipt() {
        return this.returnReceipt;
    }

    public void setReturnReceipt(boolean returnReceipt) {
        this.returnReceipt = returnReceipt;
    }

    public DataSource getAttachmentDataSource() {
        return this.attachmentDataSource;
    }

    public void setAttachmentDataSource(DataSource attachmentDataSource) {
        this.attachmentDataSource = attachmentDataSource;
    }
}

