/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.DirectoryParser;
import nl.b3p.kaartenbalie.service.MapParser;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapServerAction
extends KaartenbalieCrudAction {
    protected static final Log log = LogFactory.getLog(MapServerAction.class);
    protected static final String MAPFILE_EXT_ERRORKEY = "error.mapserver.extention";
    protected static final String MAPFILE_SIZE_ERRORKEY = "error.mapserver.size";
    protected static final String MAPFILE_FORMAT_ERRORKEY = "error.mapserver.format";
    protected static final String MAPFILE_EXISTS_ERRORKEY = "error.mapserver.exists";
    protected static final String MAPPING_ARCHIVE = "archive";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties("archive");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("beheer.mapserver.archive.succes");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("beheer.mapserver.archive.failed");
        map.put("archive", crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormFile thisFile = (FormFile)dynaForm.get("mapFile");
        Boolean overwrite = (Boolean)dynaForm.get("overwrite");
        if (thisFile == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.mapserver.size");
            return this.getAlternateForward(mapping, request);
        }
        int fileSize = thisFile.getFileSize();
        if (fileSize > 0x100000) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.mapserver.size");
            return this.getAlternateForward(mapping, request);
        }
        String fileName = thisFile.getFileName();
        if (fileName == null || !fileName.endsWith(".map")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.mapserver.extention");
            return this.getAlternateForward(mapping, request);
        }
        String mapdir = MyEMFDatabase.getMapfiles();
        File targetFile = new File(mapdir, fileName);
        boolean exists = targetFile.exists();
        boolean doOverwrite = false;
        if (overwrite != null && overwrite.booleanValue()) {
            doOverwrite = true;
        }
        if (exists && !doOverwrite) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.mapserver.exists");
            return this.getAlternateForward(mapping, request);
        }
        InputStream stream = null;
        try {
            stream = thisFile.getInputStream();
            FileOutputStream bos = null;
            try {
                bos = new FileOutputStream(targetFile);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)bos).write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (bos != null) {
                    ((OutputStream)bos).close();
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        Map md = this.collectMetadata(targetFile, 9999);
        if (md == null) {
            targetFile.delete();
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.mapserver.format");
            return this.getAlternateForward(mapping, request);
        }
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) {
        String mapdir = MyEMFDatabase.getMapfiles();
        List mapFiles = new ArrayList();
        File dir = new File(mapdir);
        if (dir.isDirectory()) {
            DirectoryParser directoryParser = new DirectoryParser();
            String[] allowed_files = new String[]{".map"};
            mapFiles = directoryParser.parse2List(dir, allowed_files);
        }
        ArrayList<Map> mapFilesInfoList = new ArrayList<Map>();
        for (String mapFilePath : mapFiles) {
            try {
                Map md = this.collectMetadata(new File(mapFilePath), mapFilesInfoList.size());
                if (md == null) continue;
                mapFilesInfoList.add(md);
            }
            catch (FileNotFoundException ex) {
                log.error((Object)("map file '" + mapFilePath + "' not found:"), (Throwable)ex);
            }
            catch (IOException ex) {
                log.error((Object)("map file '" + mapFilePath + "' not readable:"), (Throwable)ex);
            }
        }
        request.setAttribute("mapfiles", mapFilesInfoList);
    }

    protected Map collectMetadata(File mapPath, int index) throws IOException {
        MapParser mapParser = new MapParser(mapPath);
        mapParser.parse();
        Map md = mapParser.getWebMetadata();
        String url = (String)md.get("wms_onlineresource");
        if (url == null || url.length() == 0) {
            return null;
        }
        md.put("encoded_url", URLEncoder.encode(url, "UTF-8"));
        String title = (String)md.get("wms_title");
        if (title == null || title.length() == 0) {
            title = "title" + index;
        }
        md.put("wms_title", title);
        md.put("encoded_title", URLEncoder.encode(title, "UTF-8"));
        md.put("map", mapPath.getPath());
        md.put("id", "map" + index);
        try {
            md.put("kb_wms", this.findWMSService(url));
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        try {
            md.put("kb_wfs", this.findWFSService(url));
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        md.put("fileName", mapPath.getName());
        return md;
    }

    protected Integer findWMSService(String url) throws Exception {
        if (url == null || url.length() == 0) {
            return null;
        }
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MapServerAction.getEntityManager();
        List serviceproviderlist = em.createQuery("from ServiceProvider sp where lower(sp.url) = lower(:url) ").setParameter("url", (Object)url.trim()).getResultList();
        if (serviceproviderlist == null || serviceproviderlist.isEmpty()) {
            return null;
        }
        ServiceProvider sp = (ServiceProvider)serviceproviderlist.get(0);
        return sp.getId();
    }

    protected Integer findWFSService(String url) throws Exception {
        if (url == null || url.length() == 0) {
            return null;
        }
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MapServerAction.getEntityManager();
        List serviceproviderlist = em.createQuery("from WfsServiceProvider sp where lower(sp.url) = lower(:url) ").setParameter("url", (Object)url.trim()).getResultList();
        if (serviceproviderlist == null || serviceproviderlist.isEmpty()) {
            return null;
        }
        WfsServiceProvider sp = (WfsServiceProvider)serviceproviderlist.get(0);
        return sp.getId();
    }

    public ActionForward archive(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String mapdir = MyEMFDatabase.getMapfiles();
        String fileName = request.getParameter("file");
        File targetFile = new File(mapdir, fileName);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        String datum = df.format(now);
        String append = "_" + datum + ".archive";
        boolean success = targetFile.renameTo(new File(mapdir, fileName + append));
        if (!success) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "failure");
            return this.getAlternateForward(mapping, request);
        }
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }
}

