/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.DirectoryParser;
import nl.b3p.kaartenbalie.service.WMSParser;
import nl.b3p.kaartenbalie.struts.ServerAction;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class WmsServerAction
extends ServerAction {
    private static final Log log = LogFactory.getLog(WmsServerAction.class);
    protected static final String ABBR_WARN_KEY = "warning.abbr.changed";
    protected static final String MAPPING_TEST = "test";
    protected static final String MAPPING_BATCH_UPDATE = "batchUpdate";
    protected static long maxResponseTime = 10000L;
    private String WMS_SERVICE_TEST_FOUT = "beheer.wms.test.fout";
    private String WMS_SERVICE_BATCH_UPDATE_FOUT = "beheer.wms.batchupdate.fout";
    protected WMSParser parser = new WMSParser();

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties("test");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("beheer.wms.test.succes");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("beheer.wms.test.failed");
        map.put("test", crudProp);
        crudProp = new ExtendedMethodProperties("batchUpdate");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("beheer.wms.batchupdate.succes");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("beheer.wms.batchupdate.failed");
        map.put("batchUpdate", crudProp);
        return map;
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceProvider serviceprovider = this.parser.getServiceProvider(dynaForm, false);
        if (serviceprovider == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.spnotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateServiceProviderForm(serviceprovider, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WmsServerAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            super.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        String url = FormUtils.nullIfEmpty((String)dynaForm.getString("url"));
        if (url == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.malformedurl");
            return this.getAlternateForward(mapping, request);
        }
        try {
            URL uRL = new URL(url.trim());
        }
        catch (MalformedURLException mue) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.malformedurl");
            return this.getAlternateForward(mapping, request);
        }
        String username = dynaForm.getString("username");
        String password = dynaForm.getString("password");
        if (!username.equals("") && password.equals("") || username.equals("") && !password.equals("")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.malformedcredentials");
            return this.getAlternateForward(mapping, request);
        }
        String abbreviation = FormUtils.nullIfEmpty((String)dynaForm.getString("abbr"));
        if (!this.isAlphaNumeric(abbreviation)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.abbr.notalphanumeric");
            return this.getAlternateForward(mapping, request);
        }
        if (abbreviation.equalsIgnoreCase(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.abbr.reserved");
            return this.getAlternateForward(mapping, request);
        }
        String code = this.parser.saveProvider(request, dynaForm);
        if (code.equals("Not a WMS URL")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, this.parser.getException().getMessage());
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("error.abbr.notunique")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.abbr.notunique");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("error.serverconnection")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.serverconnection");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("error.malformedcapability")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.malformedcapability");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("Error_saving")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, this.parser.getException().getMessage());
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("error.wmsversion")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.wmsversion");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("Error_deleting_old_provider")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, this.parser.getException().getMessage());
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("Het bestand is niet opgeslagen, omdat deze te groot is.")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, "Het bestand is niet opgeslagen, omdat deze te groot is.");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("Het bestand is niet opgeslagen, omdat deze niet van het type .jpg .png of .sld is.")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, "Het bestand is niet opgeslagen, omdat deze niet van het type .jpg .png of .sld is.");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("Het bestand is niet opgeslagen, omdat het reeds bestaat.")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, "Het bestand is niet opgeslagen, omdat het reeds bestaat.");
            return this.getAlternateForward(mapping, request);
        }
        dynaForm.set("id", null);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public static ServiceProvider saveServiceProvider(String url, B3PCredentials credentials, String givenName, String abbreviation, EntityManager em) throws Exception {
        return WMSParser.saveServiceProvider((String)url, (B3PCredentials)credentials, (String)givenName, (String)abbreviation, (EntityManager)em);
    }

    public static void addRightsForAllLayers(String[] orgSelected, ServiceProvider sp, EntityManager em) throws Exception {
        WMSParser.addRightsForAllLayers((String[])orgSelected, (ServiceProvider)sp, (EntityManager)em);
    }

    public static void addAllLayersToGroup(Organization org, ServiceProvider sp, EntityManager em) throws Exception {
        WMSParser.addAllLayersToGroup((Organization)org, (ServiceProvider)sp, (EntityManager)em);
    }

    public ActionForward test(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int fout = this.parser.test(dynaForm);
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        if (fout > 0) {
            ActionMessages messages = this.getMessages(request);
            ActionMessage message = new ActionMessage(this.WMS_SERVICE_TEST_FOUT, (Object)fout);
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
            this.saveMessages(request, messages);
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward batchUpdate(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int fout = this.parser.batchUpdate(dynaForm);
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        if (fout > 0) {
            ActionMessages messages2 = this.getMessages(request);
            ActionMessage message = new ActionMessage(this.WMS_SERVICE_BATCH_UPDATE_FOUT, (Object)fout);
            messages2.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
            this.saveMessages(request, messages2);
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward deleteConfirm(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String code = this.parser.deleteConfirm(dynaForm, request);
        if (code.equals("error.notfound")) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.prepareMethod(dynaForm, request, "delete", "edit");
        ArrayList parseMessages = this.parser.getMessages();
        for (String message : parseMessages) {
            this.addAlternateMessage(mapping, request, null, message);
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String code = this.parser.delete(dynaForm, request);
        if (code.equals("error.token")) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        if (code.equals("error.notfound")) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WmsServerAction.getEntityManager();
        List serviceproviderlist = em.createQuery("from ServiceProvider order by given_name").getResultList();
        request.setAttribute("serviceproviderlist", (Object)serviceproviderlist);
        List organizationlist = em.createQuery("from Organization order by name").getResultList();
        request.setAttribute("organizationlist", (Object)organizationlist);
    }

    protected ServiceProvider getServiceProvider(DynaValidatorForm dynaForm, HttpServletRequest request, boolean createNew) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WmsServerAction.getEntityManager();
        ServiceProvider serviceProvider = null;
        Integer id = this.getID(dynaForm);
        if (null == id && createNew) {
            serviceProvider = new ServiceProvider();
        } else if (null != id) {
            serviceProvider = (ServiceProvider)em.find(ServiceProvider.class, (Object)new Integer(id));
        }
        return serviceProvider;
    }

    private void populateServiceProviderForm(ServiceProvider serviceProvider, DynaValidatorForm dynaForm, HttpServletRequest request) {
        String[] allowed_files;
        DirectoryParser directoryParser;
        dynaForm.set("id", (Object)serviceProvider.getId().toString());
        dynaForm.set("givenName", (Object)serviceProvider.getGivenName());
        dynaForm.set("url", (Object)serviceProvider.getUrl());
        dynaForm.set("username", (Object)serviceProvider.getUserName());
        dynaForm.set("password", (Object)serviceProvider.getPassword());
        dynaForm.set("updatedDate", (Object)serviceProvider.getUpdatedDate().toString());
        dynaForm.set("abbr", (Object)serviceProvider.getAbbr());
        dynaForm.set("sldUrl", (Object)serviceProvider.getSldUrl());
        dynaForm.set("ignoreResource", (Object)serviceProvider.getIgnoreResource());
        String sep = File.separator;
        String uploaddir = MyEMFDatabase.getUpload() + sep + serviceProvider.getAbbr();
        List uploadFiles = new ArrayList();
        ArrayList<String> fileNames = new ArrayList<String>();
        File dir = new File(uploaddir);
        if (dir.isDirectory() && (uploadFiles = (directoryParser = new DirectoryParser()).parse2List(dir, allowed_files = MyEMFDatabase.getAllowedUploadFiles())) != null && !uploadFiles.isEmpty()) {
            Iterator it = uploadFiles.iterator();
            while (it.hasNext()) {
                String file = it.next().toString();
                int i = file.lastIndexOf(sep);
                fileNames.add(file.substring(i + 1));
            }
            request.setAttribute("fileNames", fileNames);
        }
    }

    protected String checkWmsUrl(String url) throws Exception {
        OGCRequest ogcrequest = new OGCRequest(url);
        if (ogcrequest.containsParameter("REQUEST") && !"GetCapabilities".equalsIgnoreCase(ogcrequest.getParameter("REQUEST"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_REQUEST);
            throw new Exception(KBConfiguration.UNSUPPORTED_REQUEST);
        }
        ogcrequest.addOrReplaceParameter("REQUEST", "GetCapabilities");
        if (ogcrequest.containsParameter("SERVICE") && !"WMS".equalsIgnoreCase(ogcrequest.getParameter("SERVICE"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_SERVICE);
            throw new Exception(KBConfiguration.UNSUPPORTED_SERVICE);
        }
        ogcrequest.addOrReplaceParameter("SERVICE", "WMS");
        if (ogcrequest.containsParameter("VERSION") && !"1.1.1".equalsIgnoreCase(ogcrequest.getParameter("VERSION"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_VERSION);
            throw new Exception(KBConfiguration.UNSUPPORTED_VERSION);
        }
        ogcrequest.addOrReplaceParameter("VERSION", "1.1.1");
        return ogcrequest.getUrl();
    }
}

