/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.Operation;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KBImageTool {
    private static final Log log = LogFactory.getLog(KBImageTool.class);
    private BufferedImage bi;
    private static final String TIFF = "image/tiff";
    private static final String GIF = "image/gif";
    private static final String JPEG = "image/jpeg";
    private static final String PNG = "image/png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(InputStream is, String mime, ServiceProviderRequest wmsRequest) throws Exception {
        String mimeType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        byte[] buffer = new byte[2048];
        while (bytesRead != -1) {
            bytesRead = is.read(buffer, 0, buffer.length);
            if (bytesRead <= 0) continue;
            baos.write(buffer, 0, bytesRead);
        }
        if (mime.indexOf(";") != -1) {
            mime = mime.substring(0, mime.indexOf(";"));
        }
        if ((mimeType = KBImageTool.getMimeType((String)mime)) == null) {
            String message = baos.toString();
            message = message.replaceAll("(\\r|\\n)", "");
            log.error((Object)("Response from server not understood (mime = " + mime + "): " + message));
            throw new Exception("Response from server not understood (mime = " + mime + "): " + message);
        }
        ImageReader ir = KBImageTool.getReader((String)mimeType);
        if (ir == null) {
            log.error((Object)("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1)));
            throw new Exception("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1));
        }
        wmsRequest.setBytesReceived(new Long(baos.size()));
        ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ir.setInput(stream, true);
        try {
            BufferedImage i = ir.read(0);
            if (!i.getColorModel().hasAlpha() && ir.getImageMetadata(0) instanceof PNGMetadata) {
                PNGMetadata metadata = (PNGMetadata)ir.getImageMetadata(0);
                if (metadata.tRNS_present) {
                    int alphaPix = metadata.tRNS_red << 16 | metadata.tRNS_green << 8 | metadata.tRNS_blue;
                    BufferedImage tmp = new BufferedImage(i.getWidth(), i.getHeight(), 2);
                    for (int x = 0; x < i.getWidth(); ++x) {
                        for (int y = 0; y < i.getHeight(); ++y) {
                            int rgb = i.getRGB(x, y);
                            rgb = (rgb & 0xFFFFFF) == alphaPix ? alphaPix : rgb;
                            tmp.setRGB(x, y, rgb);
                        }
                    }
                    i = tmp;
                }
            }
            BufferedImage bufferedImage = i;
            return bufferedImage;
        }
        finally {
            ir.dispose();
        }
    }

    public static void writeImage(BufferedImage[] images, String mime, DataWrapper dw) throws Exception {
        String mimeType = KBImageTool.getMimeType((String)mime);
        if (mimeType == null) {
            log.error((Object)("unsupported mime type: " + mime));
            throw new Exception("unsupported mime type: " + mime);
        }
        DataMonitoring rr = dw.getRequestReporting();
        Operation o = new Operation();
        o.setType(4);
        if (images != null) {
            o.setNumberOfImages(new Integer(images.length));
        } else {
            o.setNumberOfImages(new Integer(-1));
        }
        o.setMsSinceRequestStart(new Long(rr.getMSSinceStart()));
        long startTime = System.currentTimeMillis();
        BufferedImage bufferedImage = KBImageTool.combineImages((BufferedImage[])images, (String)mime);
        Long time = new Long(System.currentTimeMillis() - startTime);
        dw.setHeader("X-Kaartenbalie-CombineImageTime", time.toString());
        o.setDuration(time);
        rr.addRequestOperation(o);
        if (mime.equals("image/tiff")) {
            KBImageTool.writeTIFFImage((BufferedImage)bufferedImage, (DataWrapper)dw);
        } else {
            KBImageTool.writeOtherImage((BufferedImage)bufferedImage, (DataWrapper)dw, (String)mimeType.substring(mimeType.lastIndexOf("/") + 1));
        }
    }

    private static void writeTIFFImage(BufferedImage bufferedImage, DataWrapper dw) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "tif", baos);
        dw.write(baos);
    }

    private static void writeOtherImage(BufferedImage bufferedImage, DataWrapper dw, String extension) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        ImageIO.write((RenderedImage)bufferedImage, extension, ios);
        dw.write(baos);
        ios.flush();
        ios.close();
    }

    public static BufferedImage combineImages(BufferedImage[] images, String mime) {
        if (mime.equals("image/jpeg")) {
            return KBImageTool.combineJPGImages((BufferedImage[])images);
        }
        return KBImageTool.combineOtherImages((BufferedImage[])images);
    }

    private static BufferedImage combineJPGImages(BufferedImage[] images) {
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        BufferedImage newBufIm = new BufferedImage(width, height, 1);
        Graphics2D gbi = newBufIm.createGraphics();
        gbi.drawImage((Image)images[0], 0, 0, null);
        for (int i = 1; i < images.length; ++i) {
            gbi.drawImage((Image)images[i], 0, 0, null);
        }
        return newBufIm;
    }

    private static BufferedImage combineOtherImages(BufferedImage[] images) {
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        BufferedImage newBufIm = new BufferedImage(width, height, 3);
        Graphics2D gbi = newBufIm.createGraphics();
        gbi.drawImage((Image)images[0], 0, 0, null);
        gbi.setComposite(AlphaComposite.getInstance(4, 1.0f));
        for (int i = 1; i < images.length; ++i) {
            gbi.drawImage((Image)images[i], 0, 0, null);
        }
        return newBufIm;
    }

    public static String getMimeType(String mime) {
        String[] mimeTypes = ImageIO.getReaderMIMETypes();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (!mimeTypes[i].equalsIgnoreCase(mime)) continue;
            return mimeTypes[i];
        }
        return null;
    }

    private static ImageReader getReader(String mime) {
        if (mime.equals("image/jpeg") || mime.equals("image/png")) {
            return KBImageTool.getJPGOrPNGReader((String)mime);
        }
        return KBImageTool.getGIFOrTIFFReader((String)mime);
    }

    private static ImageReader getJPGOrPNGReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private static ImageReader getGIFOrTIFFReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
        }
        return imTest;
    }

    private ImageWriter getWriter(String mime) {
        if (mime.equals("image/jpeg") || mime.equals("image/png")) {
            return this.getJPGOrPNGWriter(mime);
        }
        return this.getGIFOrTIFFWriter(mime);
    }

    private ImageWriter getJPGOrPNGWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
            String name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private ImageWriter getGIFOrTIFFWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
        }
        return imTest;
    }
}

