/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import nl.b3p.kaartenbalie.service.CachedUrl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLCache {
    private final int cacheTime;
    private HashMap<String, CachedUrl> cachedUrls = new HashMap();
    private static final Log log = LogFactory.getLog(URLCache.class);

    public URLCache(int cacheTime) {
        this.cacheTime = cacheTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheUrl(String url, boolean forceRenew) {
        HashMap hashMap = this.cachedUrls;
        synchronized (hashMap) {
            this.clearOldCache(this.cacheTime);
            CachedUrl cachedUrl = (CachedUrl)this.cachedUrls.get(url);
            if (cachedUrl == null || forceRenew) {
                this.cachedUrls.put(url, new CachedUrl(url, (Object)this.cachedUrls));
                ((CachedUrl)this.cachedUrls.get(url)).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromCache(String url) throws InterruptedException {
        CachedUrl cachedUrl = null;
        HashMap hashMap = this.cachedUrls;
        synchronized (hashMap) {
            this.clearOldCache(this.cacheTime);
            cachedUrl = (CachedUrl)this.cachedUrls.get(url);
            if (cachedUrl == null) {
                this.cacheUrl(url, false);
                return this.getFromCache(url);
            }
            cachedUrl = (CachedUrl)this.cachedUrls.get(url);
            if (cachedUrl != null && (cachedUrl.getStatus() == CachedUrl.CREATED || cachedUrl.getStatus() == CachedUrl.LOADING)) {
                this.cachedUrls.wait();
                return this.getFromCache(url);
            }
            if (cachedUrl != null) {
                return cachedUrl.getContent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOldCache(int olderThen) {
        HashMap hashMap = this.cachedUrls;
        synchronized (hashMap) {
            Date now = new Date();
            Iterator it = this.cachedUrls.keySet().iterator();
            while (it.hasNext()) {
                String url = (String)it.next();
                CachedUrl cu = (CachedUrl)this.cachedUrls.get(url);
                if (cu.getCreationDate() == null || cu.getCreationDate().getTime() + (long)olderThen >= now.getTime()) continue;
                it.remove();
            }
        }
    }

    public void clearCache() {
        this.clearOldCache(0);
    }
}

