/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.commons.xml.IgnoreEntityResolver;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.ExtLayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.b3pLayering.ConfigLayer;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.Operation;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.core.server.persistence.WFSProviderDAO;
import nl.b3p.kaartenbalie.service.ImageManager;
import nl.b3p.kaartenbalie.service.KBImageTool;
import nl.b3p.kaartenbalie.service.LayerValidator;
import nl.b3p.kaartenbalie.service.ServiceProviderValidator;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.OGCRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.kaartenbalie.service.servlet.CallWMSServlet;
import nl.b3p.kaartenbalie.service.servlet.ProxySLDServlet;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.wms.capabilities.ElementHandler;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import nl.b3p.wms.capabilities.Style;
import nl.b3p.wms.capabilities.Switcher;
import nl.b3p.wms.capabilities.TileSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.LayerDescription;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.wms.response.DescribeLayerResponse;
import org.geotools.ows.ServiceException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class WMSRequestHandler
extends OGCRequestHandler {
    private static final Log log = LogFactory.getLog(WMSRequestHandler.class);
    private XMLReader parser;
    private static Stack stack = new Stack();
    private Switcher s;

    public boolean mayDirectWrite() {
        return false;
    }

    public int getMaxResponseTime() {
        if (this.maxResponseTime <= 0) {
            try {
                this.maxResponseTime = new Integer(KBConfiguration.WMS_RESPONSE_TIME_LIMIT);
            }
            catch (NumberFormatException nfe) {
                this.maxResponseTime = 11111;
            }
        }
        return this.maxResponseTime;
    }

    protected Set getValidLayers(User user, EntityManager em, boolean isAdmin, String spAbbrUrl) throws Exception {
        HashSet organizationLayers = new HashSet();
        List layerlist = null;
        if (isAdmin) {
            layerlist = spAbbrUrl == null ? em.createQuery("from Layer l").getResultList() : em.createQuery("from Layer l where l.serviceProvider.abbr = :spAbbr").setParameter("spAbbr", (Object)spAbbrUrl).getResultList();
        } else {
            Set orgs = user.getAllOrganizations();
            layerlist = spAbbrUrl == null ? em.createQuery("from Layer l where l in (select ol from Organization o join o.layers ol where o in (:orgs)) ").setParameter("orgs", (Object)orgs).getResultList() : em.createQuery("from Layer l where l.serviceProvider.abbr = :spAbbr and l in (select ol from Organization o join o.layers ol where o in (:orgs)) ").setParameter("spAbbr", (Object)spAbbrUrl).setParameter("orgs", (Object)orgs).getResultList();
        }
        organizationLayers.addAll(layerlist);
        return organizationLayers;
    }

    public Set getServiceProviders(boolean isAdmin, String spAbbrUrl) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        User dbUser = null;
        try {
            dbUser = (User)em.createQuery("from User u where u.id = :userid").setParameter("userid", (Object)this.user.getId()).getSingleResult();
        }
        catch (NoResultException nre) {
            log.error((Object)"No serviceprovider for user found.");
            throw new Exception("No serviceprovider for user found.");
        }
        Set organizationLayers = this.getValidLayers(dbUser, em, isAdmin, spAbbrUrl);
        HashSet<ServiceProvider> serviceproviders = null;
        if (organizationLayers != null && !organizationLayers.isEmpty()) {
            serviceproviders = new HashSet<ServiceProvider>();
            for (Layer layer : organizationLayers) {
                ServiceProvider sp = layer.getServiceProvider();
                if (serviceproviders.contains(sp)) continue;
                serviceproviders.add(sp);
            }
        }
        return serviceproviders;
    }

    public ServiceProvider getServiceProvider(boolean isAdmin, String spAbbrUrl) throws Exception {
        Set roles;
        SrsBoundingBox srsbb;
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        User dbUser = null;
        try {
            dbUser = (User)em.createQuery("from User u where u.id = :userid").setParameter("userid", (Object)this.user.getId()).getSingleResult();
        }
        catch (NoResultException nre) {
            log.error((Object)"User not found in database.");
            throw new Exception("User not found in database.");
        }
        Set organizationLayers = this.getValidLayers(dbUser, em, isAdmin, spAbbrUrl);
        HashSet<ServiceProvider> serviceproviders = null;
        Layer kaartenbalieTopLayer = null;
        HashSet<TileSet> tileSets = null;
        if (organizationLayers != null && !organizationLayers.isEmpty()) {
            serviceproviders = new HashSet<ServiceProvider>();
            HashSet<Layer> topLayers = new HashSet<Layer>();
            HashSet<Integer> orgLayerIds = new HashSet<Integer>();
            for (Layer layer : organizationLayers) {
                orgLayerIds.add(layer.getId());
                Layer topLayer = layer.getTopLayer();
                ServiceProvider sp = layer.getServiceProvider();
                sp.setUrlServiceProvideCode(spAbbrUrl);
                if (serviceproviders.contains(sp)) continue;
                serviceproviders.add(sp);
                if (topLayers.contains(topLayer)) continue;
                topLayers.add(topLayer);
            }
            for (ServiceProvider sp : serviceproviders) {
                if (sp.getTileSets() == null) continue;
                for (TileSet ts : sp.getTileSets()) {
                    if (ts.getLayers() == null) continue;
                    Iterator layerIt = ts.getLayers().iterator();
                    boolean hasRight = false;
                    while (layerIt.hasNext()) {
                        Layer l = (Layer)layerIt.next();
                        if (!organizationLayers.contains(l)) {
                            hasRight = false;
                            break;
                        }
                        hasRight = true;
                    }
                    if (!hasRight) continue;
                    if (tileSets == null) {
                        tileSets = new HashSet<TileSet>();
                    }
                    tileSets.add(ts);
                }
            }
            if (!topLayers.isEmpty()) {
                kaartenbalieTopLayer = new Layer();
                kaartenbalieTopLayer.setTitle(KBConfiguration.TOPLAYERNAME);
                LayerValidator lv = new LayerValidator(organizationLayers);
                kaartenbalieTopLayer.addSrsbb(lv.validateLatLonBoundingBox());
                Iterator tlId = topLayers.iterator();
                HashMap<Map, Integer> topLayerDuplicateCounts = new HashMap<Map, Integer>();
                while (tlId.hasNext()) {
                    Map topLayerIdentity;
                    Integer duplicateCount;
                    Layer layer = (Layer)tlId.next();
                    Layer layerCloned = (Layer)layer.clone();
                    HashSet authSubLayers = layerCloned.getAuthSubLayersClone(orgLayerIds);
                    boolean layerAuthorized = orgLayerIds.contains(layer.getId());
                    if (!layerAuthorized && (authSubLayers == null || authSubLayers.isEmpty())) continue;
                    layerCloned.setLayers((Set)authSubLayers);
                    if (!layerAuthorized) {
                        layerCloned.setName(null);
                    }
                    if (authSubLayers == null) {
                        authSubLayers = new HashSet();
                    }
                    if ((duplicateCount = (Integer)topLayerDuplicateCounts.get(topLayerIdentity = layerCloned.getIdentityMap(false))) == null) {
                        topLayerDuplicateCounts.put(topLayerIdentity, new Integer(1));
                    } else {
                        int count = duplicateCount + 1;
                        layerCloned.setTitle(layerCloned.getTitle().trim() + " (" + count + ")");
                        topLayerDuplicateCounts.put(topLayerIdentity, new Integer(count));
                    }
                    kaartenbalieTopLayer.addLayer(layerCloned);
                }
                lv = new LayerValidator(kaartenbalieTopLayer.getLayers());
                String[] supportedSRS = lv.validateSRS();
                for (int i = 0; i < supportedSRS.length; ++i) {
                    SrsBoundingBox srsbb2 = new SrsBoundingBox();
                    srsbb2.setSrs(supportedSRS[i]);
                    kaartenbalieTopLayer.addSrsbb(srsbb2);
                }
            }
        }
        if (kaartenbalieTopLayer != null && (srsbb = this.calcSrsBoundingBox(dbUser)) != null) {
            kaartenbalieTopLayer.addSrsbb(srsbb);
        }
        ServiceProviderValidator spv = new ServiceProviderValidator(serviceproviders);
        ServiceProvider validServiceProvider = spv.getValidServiceProvider();
        validServiceProvider.setTopLayer(kaartenbalieTopLayer);
        if (spAbbrUrl != null && !spAbbrUrl.equals("")) {
            validServiceProvider.setUrlServiceProvideCode(spAbbrUrl);
        }
        boolean allowAccountingLayers = false;
        Set orgs = dbUser.getAllOrganizations();
        for (Organization org : orgs) {
            if (!org.getAllowAccountingLayers()) continue;
            allowAccountingLayers = true;
            break;
        }
        if (allowAccountingLayers && kaartenbalieTopLayer != null) {
            Map configLayers = ConfigLayer.getConfigLayers();
            Iterator iterLayerKeys = configLayers.keySet().iterator();
            while (iterLayerKeys.hasNext()) {
                ConfigLayer configLayer = ConfigLayer.forName((String)((String)iterLayerKeys.next()));
                configLayer.setServiceProvider(validServiceProvider);
                kaartenbalieTopLayer.addLayer((Layer)configLayer);
            }
        }
        if ((roles = dbUser.getRoles()) != null) {
            for (Roles role : roles) {
                validServiceProvider.addRole(role);
            }
        }
        if (tileSets != null) {
            validServiceProvider.setTileSets(tileSets);
        }
        return validServiceProvider;
    }

    private SrsBoundingBox calcSrsBoundingBox(User user) {
        SrsBoundingBox srsbb = new SrsBoundingBox();
        String orgBbox = user.getMainOrganization().getBbox();
        if (orgBbox != null) {
            String[] values = orgBbox.split(",");
            srsbb.setSrs("EPSG:28992");
            srsbb.setMinx(values[0]);
            srsbb.setMiny(values[1]);
            srsbb.setMaxx(values[2]);
            srsbb.setMaxy(values[3]);
        }
        return srsbb;
    }

    protected void getOnlineData(DataWrapper dw, ArrayList urlWrapper, boolean overlay, String REQUEST_TYPE) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object bi = null;
        int size = urlWrapper.size();
        ArrayList swaplist = new ArrayList(size);
        for (int i = size - 1; i >= 0; --i) {
            swaplist.add(urlWrapper.get(i));
            log.debug((Object)("Outgoing url: " + ((ServiceProviderRequest)urlWrapper.get(i)).getProviderRequestURI()));
        }
        urlWrapper = swaplist;
        long startprocestime = System.currentTimeMillis();
        DataMonitoring rr = dw.getRequestReporting();
        if (urlWrapper.size() > 1) {
            if (REQUEST_TYPE.equalsIgnoreCase("GetMap")) {
                Operation o = new Operation();
                o.setType(6);
                o.setMsSinceRequestStart(new Long(rr.getMSSinceStart()));
                ImageManager imagemanager = new ImageManager(urlWrapper, dw);
                imagemanager.process();
                long endprocestime = System.currentTimeMillis();
                Long time = new Long(endprocestime - startprocestime);
                dw.setHeader("X-Kaartenbalie-ImageServerResponseTime", time.toString());
                o.setDuration(time);
                rr.addRequestOperation(o);
                imagemanager.sendCombinedImages(dw);
            } else if (REQUEST_TYPE.equalsIgnoreCase("GetFeatureInfo")) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                dbf.setNamespaceAware(true);
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document destination = builder.newDocument();
                Element rootElement = destination.createElement("msGMLOutput");
                destination.appendChild(rootElement);
                rootElement.setAttribute("xmlns:gml", "http://www.opengis.net/gml");
                rootElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                Document source = null;
                for (int i = 0; i < urlWrapper.size(); ++i) {
                    ServiceProviderRequest wmsRequest = (ServiceProviderRequest)urlWrapper.get(i);
                    String url = wmsRequest.getProviderRequestURI();
                    source = builder.parse(url);
                    WMSRequestHandler.copyElements((Document)source, (Document)destination);
                    wmsRequest.setBytesSent(new Long(url.getBytes().length));
                    wmsRequest.setProviderRequestURI(url);
                    wmsRequest.setMsSinceRequestStart(new Long(rr.getMSSinceStart()));
                    wmsRequest.setBytesReceived(new Long(-1L));
                    wmsRequest.setResponseStatus(new Integer(-1));
                    rr.addServiceProviderRequest(wmsRequest);
                }
                OutputFormat format = new OutputFormat(destination);
                format.setIndenting(true);
                XMLSerializer serializer = new XMLSerializer((OutputStream)baos, format);
                serializer.serialize(destination);
                dw.write(baos);
            } else if (REQUEST_TYPE.equalsIgnoreCase("DescribeLayer")) {
                throw new Exception(REQUEST_TYPE + " request with more then one service url is not supported yet!");
            }
        } else if (!urlWrapper.isEmpty()) {
            this.getOnlineData(dw, (ServiceProviderRequest)urlWrapper.get(0), REQUEST_TYPE);
        } else {
            if (REQUEST_TYPE.equalsIgnoreCase("GetFeatureInfo")) {
                log.error((Object)KBConfiguration.FEATUREINFO_EXCEPTION);
                throw new Exception(KBConfiguration.FEATUREINFO_EXCEPTION);
            }
            if (REQUEST_TYPE.equalsIgnoreCase("GetLegendGraphic")) {
                log.error((Object)KBConfiguration.LEGENDGRAPHIC_EXCEPTION);
                throw new Exception(KBConfiguration.LEGENDGRAPHIC_EXCEPTION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOnlineData(DataWrapper dw, ServiceProviderRequest wmsRequest, String REQUEST_TYPE) throws Exception {
        block23: {
            String url = wmsRequest.getProviderRequestURI();
            DataMonitoring rr = dw.getRequestReporting();
            wmsRequest.setBytesSent(new Long(url.getBytes().length));
            long startTime = System.currentTimeMillis();
            try {
                if (REQUEST_TYPE.equalsIgnoreCase("GetMap") && url.startsWith(KBConfiguration.SERVICEPROVIDER_BASE_HTTP)) {
                    long time = System.currentTimeMillis() - startTime;
                    try {
                        BufferedImage[] bi = new BufferedImage[]{ConfigLayer.handleRequest((String)url, (Map)dw.getLayeringParameterMap())};
                        KBImageTool.writeImage((BufferedImage[])bi, (String)"image/png", (DataWrapper)dw);
                        wmsRequest.setBytesReceived(new Long(dw.getContentLength()));
                        wmsRequest.setResponseStatus(new Integer(200));
                    }
                    catch (Exception e) {
                        wmsRequest.setResponseStatus(new Integer(404));
                        throw e;
                    }
                    wmsRequest.setRequestResponseTime(new Long(time));
                    break block23;
                }
                url = url.replaceAll(" ", "%20");
                url = url.replaceAll("\\\\+", "/");
                log.debug((Object)("Outgoing URL: " + url));
                B3PCredentials credentials = wmsRequest.getCredentials();
                if (credentials != null) {
                    credentials.setUrl(url);
                }
                HttpClientConfigured hcc = new HttpClientConfigured(credentials);
                HttpGet httpget = new HttpGet(url);
                String rhValue = "";
                InputStream instream = null;
                HttpResponse response = hcc.execute((HttpUriRequest)httpget);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    long time = System.currentTimeMillis() - startTime;
                    dw.setHeader("X-Kaartenbalie-ImageServerResponseTime", String.valueOf(time));
                    wmsRequest.setResponseStatus(new Integer(statusCode));
                    wmsRequest.setRequestResponseTime(new Long(time));
                    HttpEntity entity = response.getEntity();
                    if (statusCode != 200 || entity == null) {
                        log.debug((Object)("Error connecting to server. Status code: " + statusCode));
                        throw new Exception("Error connecting to server. Status code: " + statusCode);
                    }
                    instream = entity.getContent();
                    Header h1 = response.getFirstHeader("Content-Type");
                    if (h1 != null && !h1.equals("")) {
                        rhValue = h1.getValue();
                    }
                    if (rhValue.equalsIgnoreCase("application/vnd.ogc.se_xml")) {
                        log.error((Object)("xml error response for request: " + dw.getOgcrequest().toString()));
                        InputStream is = instream;
                        String body = WMSRequestHandler.getServiceException((InputStream)is);
                        log.debug((Object)("error xml body: " + body));
                        throw new Exception(body);
                    }
                    dw.setContentType(rhValue);
                    if (REQUEST_TYPE.equalsIgnoreCase("GetFeatureInfo")) {
                        dw.write(instream);
                        wmsRequest.setBytesReceived(new Long(dw.getContentLength()));
                    } else if (REQUEST_TYPE.equalsIgnoreCase("DescribeLayer")) {
                        DescribeLayerResponse wmsResponse = this.createGeotools8DescribeLayerResponse(url);
                        DescribeLayerData data = new DescribeLayerData(this, wmsRequest.getServiceProviderAbbreviation(), wmsResponse);
                        ArrayList<DescribeLayerData> dataList = new ArrayList<DescribeLayerData>();
                        dataList.add(data);
                        Document newResponse = this.createKBDescribeLayerResponse(dw, dataList);
                        OutputFormat format = new OutputFormat(newResponse, "UTF-8", true);
                        format.setIndenting(true);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        XMLSerializer serializer = new XMLSerializer((OutputStream)baos, format);
                        serializer.serialize(newResponse);
                        dw.write(baos);
                        wmsRequest.setBytesReceived(new Long(dw.getContentLength()));
                    } else {
                        Header cacheControl = response.getFirstHeader("Cache-Control");
                        Header expires = response.getFirstHeader("Expires");
                        Header pragma = response.getFirstHeader("Pragma");
                        if (cacheControl != null) {
                            dw.setHeader(cacheControl.getName(), cacheControl.getValue());
                        }
                        if (expires != null) {
                            dw.setHeader(expires.getName(), expires.getValue());
                        }
                        if (pragma != null) {
                            dw.setHeader(pragma.getName(), pragma.getValue());
                        }
                        dw.setHeader("Keep-Alive", "timeout=15, max=100");
                        dw.setHeader("Connection", "Keep-Alive");
                        dw.write(instream);
                        wmsRequest.setBytesReceived(new Long(dw.getContentLength()));
                    }
                }
                finally {
                    if (instream != null) {
                        instream.close();
                    }
                    hcc.close(response);
                    hcc.close();
                }
            }
            catch (Exception e) {
                wmsRequest.setExceptionMessage(e.getMessage());
                wmsRequest.setExceptionClass(e.getClass());
                throw e;
            }
            finally {
                rr.addServiceProviderRequest(wmsRequest);
            }
        }
    }

    protected StringBuffer createOnlineUrl(SpLayerSummary spInfo, OGCRequest ogc, String serviceUrl) throws UnsupportedEncodingException {
        StringBuffer returnValue = new StringBuffer();
        ArrayList<String> newSldParams = new ArrayList<String>();
        ArrayList<Integer> sldStyleIds = new ArrayList<Integer>();
        String layersString = spInfo.getLayersAsString();
        String kbProxySldUrl = serviceUrl.replace("/services/", "/proxysld/");
        log.debug((Object)("Kb proxy url: " + kbProxySldUrl));
        List layersList = spInfo.getLayers();
        returnValue.append(spInfo.getSpUrl());
        if (returnValue.indexOf("?") != returnValue.length() - 1 && returnValue.indexOf("&") != returnValue.length() - 1) {
            if (returnValue.indexOf("?") >= 0) {
                returnValue.append("&");
            } else {
                returnValue.append("?");
            }
        }
        String[] params = ogc.getParametersArray();
        for (int i = 0; i < params.length; ++i) {
            block32: {
                String[] keyValuePair = new String[2];
                int indexOfIs = params[i].indexOf("=");
                if (indexOfIs == -1) continue;
                keyValuePair[0] = params[i].substring(0, indexOfIs);
                keyValuePair[1] = indexOfIs + 1 < params[i].length() ? params[i].substring(indexOfIs + 1) : "";
                if (keyValuePair[0].equalsIgnoreCase("LAYER")) {
                    returnValue.append("LAYER");
                    returnValue.append("=");
                    returnValue.append(layersString);
                } else if (keyValuePair[0].equalsIgnoreCase("LAYERS")) {
                    returnValue.append("LAYERS");
                    returnValue.append("=");
                    returnValue.append(layersString);
                } else if (keyValuePair[0].equalsIgnoreCase("STYLES")) {
                    returnValue.append("STYLES");
                    returnValue.append("=");
                    try {
                        String layersParameter;
                        int kommaIndex;
                        String stylesParameter;
                        if (layersList == null || layersList.size() <= 0 || (stylesParameter = ogc.getParameter("STYLES")) == null || stylesParameter.length() <= 0) break block32;
                        ArrayList<String> styles = new ArrayList<String>();
                        for (String tempStyles = new StringBuilder().append("").append(stylesParameter).toString(); tempStyles != null; tempStyles = tempStyles.substring(kommaIndex + 1, tempStyles.length())) {
                            if (tempStyles.length() == 0) {
                                styles.add("");
                                tempStyles = null;
                                break;
                            }
                            kommaIndex = tempStyles.indexOf(",");
                            if (kommaIndex < 0) {
                                kommaIndex = tempStyles.length();
                                styles.add(tempStyles.substring(0));
                                tempStyles = null;
                                break;
                            }
                            styles.add(tempStyles.substring(0, kommaIndex));
                        }
                        if ((layersParameter = ogc.getParameter("LAYERS")) != null && layersParameter.length() > 0) {
                            String[] layersArray = layersParameter.split(",");
                            if (styles.size() == layersArray.length) {
                                ArrayList<String> providerStyles = new ArrayList<String>();
                                block4: for (int j = 0; j < layersArray.length; ++j) {
                                    for (Object ls : layersList) {
                                        String completeName = OGCCommunication.buildFullLayerName((LayerSummary)ls);
                                        if (!completeName.equals(layersArray[j])) continue;
                                        String style = (String)styles.get(j);
                                        Style s = spInfo.getStyle(OGCCommunication.buildLayerNameWithoutSp((LayerSummary)ls), style);
                                        if (s != null && s.getSldPart() != null) {
                                            providerStyles.add("");
                                            sldStyleIds.add(s.getId());
                                            continue block4;
                                        }
                                        providerStyles.add(style);
                                        continue block4;
                                    }
                                }
                                String stylesString = "";
                                for (int p = 0; p < providerStyles.size(); ++p) {
                                    if (p != 0) {
                                        stylesString = stylesString + ",";
                                    }
                                    stylesString = stylesString + (String)providerStyles.get(p);
                                }
                                returnValue.append(stylesString);
                                if (sldStyleIds.size() > 0) {
                                    Object ls;
                                    String styleIdParam = "";
                                    ls = sldStyleIds.iterator();
                                    while (ls.hasNext()) {
                                        Integer sldStyleId = (Integer)ls.next();
                                        if (styleIdParam.length() > 0) {
                                            styleIdParam = styleIdParam + ",";
                                        }
                                        styleIdParam = styleIdParam + sldStyleId;
                                    }
                                    StringBuffer sldUrl = new StringBuffer();
                                    sldUrl.append("styles");
                                    sldUrl.append("=");
                                    sldUrl.append(styleIdParam);
                                    newSldParams.add(sldUrl.toString());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                } else if (keyValuePair[0].equalsIgnoreCase("SLD") || keyValuePair[0].equalsIgnoreCase("SLD_BODY")) {
                    if (keyValuePair[0].equalsIgnoreCase("SLD")) {
                        ProxySLDServlet.addSLDToCache((String)keyValuePair[1]);
                    }
                    StringBuffer sldParam = new StringBuffer();
                    if (keyValuePair[0].equalsIgnoreCase("SLD")) {
                        sldParam.append("oriSldUrl");
                    } else {
                        sldParam.append("oriSldBody");
                    }
                    sldParam.append("=");
                    sldParam.append(URLEncoder.encode(keyValuePair[1], "utf-8"));
                    newSldParams.add(sldParam.toString());
                    StringBuffer serviceProviderIds = new StringBuffer();
                    serviceProviderIds.append("servProvId");
                    serviceProviderIds.append("=");
                    serviceProviderIds.append(spInfo.getServiceproviderId());
                    newSldParams.add(serviceProviderIds.toString());
                } else {
                    returnValue.append(params[i]);
                }
            }
            returnValue.append("&");
        }
        if (newSldParams.size() > 0) {
            StringBuffer sldUrl = new StringBuffer();
            sldUrl.append(kbProxySldUrl);
            sldUrl.append(sldUrl.indexOf("?") > 0 ? "&" : "?");
            for (String param : newSldParams) {
                sldUrl.append(param);
                sldUrl.append(sldUrl.indexOf("?") > 0 ? "&" : "?");
            }
            returnValue.append("SLD");
            returnValue.append("=");
            returnValue.append(URLEncoder.encode(sldUrl.toString(), "utf-8"));
            returnValue.append("&");
        }
        return returnValue;
    }

    private DescribeLayerResponse createGeotools8DescribeLayerResponse(String wmsUrl) throws Exception {
        DescribeLayerResponse response = null;
        try {
            URL tempUrl = new URL(wmsUrl);
            HttpURLConnection conn = (HttpURLConnection)tempUrl.openConnection();
            SimpleHttpClient.SimpleHTTPResponse httpResponse = new SimpleHttpClient.SimpleHTTPResponse((URLConnection)conn);
            response = new DescribeLayerResponse((HTTPResponse)httpResponse);
        }
        catch (IOException iox) {
            log.error((Object)"Error getting describe layer response.", (Throwable)iox);
            throw new Exception("Error getting describe layer response.");
        }
        catch (ServiceException svx) {
            log.error((Object)"Error getting describe layer response.", (Throwable)svx);
            throw new Exception("Service error getting describe layer response.");
        }
        return response;
    }

    private Document createKBDescribeLayerResponse(DataWrapper dw, List<DescribeLayerData> describeLayerData) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        DOMImplementation di = db.getDOMImplementation();
        DocumentType dt = di.createDocumentType("WMS_DescribeLayerResponse", null, CallWMSServlet.DESCRIBELAYER_DTD);
        Document dom = di.createDocument(null, "WMS_DescribeLayerResponse", dt);
        Element rootElement = dom.getDocumentElement();
        rootElement.setAttribute("version", "1.1.1");
        String spAbbrUrl = dw.getOgcrequest().getServiceProviderName();
        String personalUrl = this.user.getPersonalURL(dw.getRequest(), spAbbrUrl);
        Integer[] orgIds = this.user.getOrganizationIds();
        WFSProviderDAO wfsProviderDao = new WFSProviderDAO();
        String[] validLayerNames = wfsProviderDao.getAuthorizedFeatureTypeNames(orgIds, null, false);
        ArrayList<SpLayerSummary> spInfo = new ArrayList<SpLayerSummary>();
        for (String name : validLayerNames) {
            SpLayerSummary layerInfo = wfsProviderDao.getAuthorizedFeatureTypeSummary(name, orgIds, false);
            if (layerInfo == null) continue;
            spInfo.add(layerInfo);
        }
        for (DescribeLayerData resp : describeLayerData) {
            for (LayerDescription descr : resp.getDescribeLayerResponse().getLayerDescs()) {
                Element layerDescriptionElement = dom.createElement("LayerDescription");
                if (spAbbrUrl != null && !spAbbrUrl.equals("")) {
                    layerDescriptionElement.setAttribute("name", descr.getName());
                } else {
                    layerDescriptionElement.setAttribute("name", OGCCommunication.attachSp((String)resp.getWmsPrefix(), (String)descr.getName()));
                }
                descr.getOwsURL();
                String wfsPrefix = this.getAuthorizedWFSPrefix(spInfo, descr);
                if (wfsPrefix != null) {
                    layerDescriptionElement.setAttribute("wfs", personalUrl);
                    layerDescriptionElement.setAttribute("owsType", descr.getOwsType());
                    layerDescriptionElement.setAttribute("owsURL", personalUrl);
                    Element queryElement = dom.createElement("Query");
                    queryElement.setAttribute("typeName", OGCCommunication.attachSp((String)wfsPrefix, (String)descr.getName()));
                    layerDescriptionElement.appendChild(queryElement);
                }
                rootElement.appendChild(layerDescriptionElement);
            }
        }
        return dom;
    }

    private String getAuthorizedWFSPrefix(List spLayerSummaries, LayerDescription descr) {
        String wfsPrefix = null;
        for (SpLayerSummary spLayerSummary : spLayerSummaries) {
            String owsUrl;
            String spUrl = spLayerSummary.getSpUrl();
            if (spUrl.endsWith("?")) {
                spUrl = spUrl.substring(0, spUrl.length() - 1);
            }
            if ((owsUrl = descr.getOwsURL().toString()).endsWith("?")) {
                owsUrl = owsUrl.substring(0, owsUrl.length() - 1);
            }
            if (!spUrl.equals(owsUrl) || !descr.getName().equalsIgnoreCase(spLayerSummary.getLayerName())) continue;
            wfsPrefix = spLayerSummary.getSpAbbr();
        }
        return wfsPrefix;
    }

    protected LayerPriceComposition calculateLayerPriceComposition(DataWrapper dw, ExtLayerCalculator lc, String spAbbr, String layerName) throws Exception {
        String operation = dw.getOperation();
        if (operation == null) {
            log.error((Object)"Operation can not be null");
            throw new Exception("Operation can not be null");
        }
        if (operation.equalsIgnoreCase("GetLegendGraphic")) {
            log.debug((Object)"Never pricing for GetLegendGraphic.");
            return null;
        }
        String projection = dw.getOgcrequest().getParameter("SRS");
        BigDecimal scale = new BigDecimal(dw.getOgcrequest().calcScale()).setScale(2, 4);
        int planType = 1;
        String service = "WMS";
        return lc.calculateLayerComplete(spAbbr, layerName, new Date(), projection, scale, new BigDecimal("1"), planType, service, operation);
    }

    protected SpLayerSummary getValidLayerObjects(EntityManager em, LayerSummary m, Integer[] orgIds, boolean b3pLayering) throws Exception {
        String query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, l.queryable,sp) from Layer l, Organization o, ServiceProvider sp join o.layers ol where l = ol and l.serviceProvider = sp and o.id in (:orgIds) and substring(l.name,locate(':',l.name)+1) = :layerName and sp.abbr = :layerCode and sp.allowed = true";
        return this.getValidLayerObjects(em, query, m, orgIds, b3pLayering);
    }

    private static String getServiceException(InputStream byteStream) throws IOException, SAXException {
        Switcher s = new Switcher();
        s.setElementHandler("ServiceException", (ElementHandler)new ServiceExceptionHandler(null));
        XMLReader reader = XMLReaderFactory.createXMLReader();
        IgnoreEntityResolver r = new IgnoreEntityResolver();
        reader.setEntityResolver((EntityResolver)r);
        reader.setContentHandler((ContentHandler)s);
        InputSource is = new InputSource(byteStream);
        is.setEncoding("UTF-8");
        reader.parse(is);
        return (String)stack.pop();
    }

    private static void copyElements(Document source, Document destination) {
        Element root_source = source.getDocumentElement();
        NodeList nodelist_source = root_source.getChildNodes();
        int size_source = nodelist_source.getLength();
        for (int i = 0; i < size_source; ++i) {
            Element element_source;
            String tagName;
            Node node_source = nodelist_source.item(i);
            if (!(node_source instanceof Element) || (tagName = (element_source = (Element)node_source).getTagName()).equalsIgnoreCase("ServiceException")) continue;
            Node importedNode = destination.importNode(element_source, true);
            Element root_destination = destination.getDocumentElement();
            root_destination.appendChild(importedNode);
        }
    }

    private static void prefixElements(Document source, Document destination, String spAbbr) {
        Element root_source = source.getDocumentElement();
        NodeList nodelist_source = root_source.getChildNodes();
        int size_source = nodelist_source.getLength();
        for (int i = 0; i < size_source; ++i) {
            Element element_source;
            String tagName;
            Node node_source = nodelist_source.item(i);
            if (!(node_source instanceof Element) || (tagName = (element_source = (Element)node_source).getTagName()).equalsIgnoreCase("ServiceException")) continue;
            Node importedNode = destination.importNode(element_source, true);
            Node newNode = destination.renameNode(importedNode, importedNode.getNamespaceURI(), OGCCommunication.attachSp((String)spAbbr, (String)tagName));
            Element root_destination = destination.getDocumentElement();
            root_destination.appendChild(newNode);
        }
    }

    static /* synthetic */ Stack access$100() {
        return stack;
    }
}

