/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FileManagerServlet;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.AccessDeniedException;
import nl.b3p.kaartenbalie.service.servlet.GeneralServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpDownloadServlet
extends FileManagerServlet {
    protected static Log log = LogFactory.getLog(UpDownloadServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.locationPrefix == null || this.locationPrefix.isEmpty()) {
            this.locationPrefix = MyEMFDatabase.getUpload();
        }
    }

    protected void checkPostLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            User user = GeneralServlet.checkLogin((HttpServletRequest)request, null);
            log.debug((Object)("Username: " + user == null ? "(null)" : user.getName()));
            if (!(user == null || user.checkRole("beheerder") || user.checkRole("organisatiebeheerder") || user.checkRole("themabeheerder"))) {
                user = null;
            }
            if (user == null) {
                response.sendError(403, "Access forbidden for Kaartenbalie");
            }
        }
        catch (AccessDeniedException ex) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"Kaartenbalie login\"");
            response.sendError(401, "Access denied for Kaartenbalie");
        }
    }

    protected void checkGetLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected static String createBaseUrl(HttpServletRequest request) {
        return GeneralServlet.createBaseUrl((HttpServletRequest)request).toString();
    }
}

