/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.service.LayerValidator;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.ogc.utils.OGCRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class WMSUrlCreatorAction
extends KaartenbalieCrudAction {
    private static final Log log = LogFactory.getLog(WMSUrlCreatorAction.class);
    protected static final String GETMAP = "getMapUrl";
    protected static final String UNKNOWN_SES_USER_ERROR_KEY = "error.sesuser";
    protected static final String UNKNOWN_DB_USER_ERROR_KEY = "error.dbuser";
    protected static final String NO_LAYERS_SELECTED_ERROR_KEY = "error.nolayer";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.createLists(dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws JSONException, Exception {
        super.createLists(form, request);
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WMSUrlCreatorAction.getEntityManager();
        User sesuser = (User)request.getUserPrincipal();
        if (sesuser == null) {
            return;
        }
        User user = (User)em.find(User.class, (Object)sesuser.getId());
        if (user == null) {
            return;
        }
        form.set("personalUrl", (Object)user.getPersonalURL(request));
        String bbox = (String)form.get("bbox");
        if (bbox == null || bbox.length() == 0) {
            form.set("bbox", (Object)"12000,304000,280000,620000");
        }
        String[] formats = new String[]{"image/gif", "image/png", "image/jpeg", "image/bmp", "image/tiff"};
        request.setAttribute("formatList", (Object)formats);
        Set userLayers = user.getLayers();
        JSONObject root = WMSUrlCreatorAction.createTree((String)"Kaartlagen", (Set)userLayers);
        request.setAttribute("layerList", (Object)root);
        LayerValidator lv = new LayerValidator(userLayers);
        String[] alSrsen = lv.validateSRS();
        request.setAttribute("projectieList", (Object)alSrsen);
    }

    public ActionForward getMapUrl(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            super.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        String[] layers = (String[])dynaForm.get("sortedLayers");
        String projectie = (String)dynaForm.get("selectedProjectie");
        String bbox = (String)dynaForm.get("bbox");
        Integer height = (Integer)dynaForm.get("height");
        Integer width = (Integer)dynaForm.get("width");
        String format = (String)dynaForm.get("selectedFormat");
        String pUrl = (String)dynaForm.get("personalUrl");
        if (layers.length == 0) {
            this.prepareMethod(dynaForm, request, "list", "list");
            this.addAlternateMessage(mapping, request, "error.nolayer");
            return this.getAlternateForward(mapping, request);
        }
        User user = (User)request.getUserPrincipal();
        if (user == null) {
            this.prepareMethod(dynaForm, request, "list", "list");
            this.addAlternateMessage(mapping, request, "error.sesuser");
            return this.getAlternateForward(mapping, request);
        }
        StringBuffer layerString = new StringBuffer();
        for (int i = 0; i < layers.length; ++i) {
            layerString.append(layers[i]);
            layerString.append(",");
        }
        String layer = layerString.substring(0, layerString.lastIndexOf(","));
        StringBuffer getMapUrl = new StringBuffer(user.getPersonalURL(request));
        getMapUrl.append("?");
        getMapUrl.append("SERVICE");
        getMapUrl.append("=");
        getMapUrl.append("WMS");
        getMapUrl.append("&");
        getMapUrl.append("VERSION");
        getMapUrl.append("=");
        getMapUrl.append("1.1.1");
        getMapUrl.append("&");
        getMapUrl.append("REQUEST");
        getMapUrl.append("=");
        getMapUrl.append("GetMap");
        getMapUrl.append("&");
        getMapUrl.append("LAYERS");
        getMapUrl.append("=");
        getMapUrl.append(layer);
        getMapUrl.append("&");
        getMapUrl.append("BBOX");
        getMapUrl.append("=");
        getMapUrl.append(bbox);
        getMapUrl.append("&");
        getMapUrl.append("SRS");
        getMapUrl.append("=");
        getMapUrl.append(projectie);
        getMapUrl.append("&");
        getMapUrl.append("HEIGHT");
        getMapUrl.append("=");
        getMapUrl.append(height);
        getMapUrl.append("&");
        getMapUrl.append("WIDTH");
        getMapUrl.append("=");
        getMapUrl.append(width);
        getMapUrl.append("&");
        getMapUrl.append("FORMAT");
        getMapUrl.append("=");
        getMapUrl.append(format);
        getMapUrl.append("&");
        getMapUrl.append("BGCOLOR");
        getMapUrl.append("=");
        getMapUrl.append("0xF0F0F0");
        getMapUrl.append("&");
        getMapUrl.append("EXCEPTIONS");
        getMapUrl.append("=");
        getMapUrl.append("application/vnd.ogc.se_inimage");
        getMapUrl.append("&");
        getMapUrl.append("STYLES");
        getMapUrl.append("=");
        user.setDefaultGetMap(getMapUrl.toString());
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WMSUrlCreatorAction.getEntityManager();
        if (user.getId() == null) {
            em.persist((Object)user);
        } else {
            em.merge((Object)user);
        }
        em.flush();
        this.populateForm(getMapUrl.toString(), dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = new ExtendedMethodProperties("getMapUrl");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("beheer.kaarten.wmsurlcreator.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("beheer.kaarten.wmsurlcreator.failed");
        map.put("getMapUrl", crudProp);
        return map;
    }

    private void populateForm(String getMapUrl, DynaValidatorForm form, HttpServletRequest request) throws JSONException, Exception {
        this.createLists(form, request);
        OGCRequest ogcrequest = new OGCRequest(getMapUrl);
        if (ogcrequest.containsParameter("LAYERS")) {
            form.set("selectedLayers", (Object)ogcrequest.getParameter("LAYERS").split(","));
        }
        if (ogcrequest.containsParameter("BBOX")) {
            form.set("bbox", (Object)ogcrequest.getParameter("BBOX"));
        }
        if (ogcrequest.containsParameter("SRS")) {
            form.set("selectedProjectie", (Object)ogcrequest.getParameter("SRS"));
        }
        if (ogcrequest.containsParameter("WIDTH")) {
            form.set("height", (Object)new Integer(ogcrequest.getParameter("WIDTH")));
        }
        if (ogcrequest.containsParameter("HEIGHT")) {
            form.set("width", (Object)new Integer(ogcrequest.getParameter("HEIGHT")));
        }
        form.set("defaultGetMap", (Object)getMapUrl);
    }
}

