/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.accounting;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.TransactionDeniedException;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Account;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Transaction;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccountManager {
    private static final Log log = LogFactory.getLog(AccountManager.class);
    public static final long serialVersionUID = 856294562L;
    private static boolean enableAccounting = false;
    private BigDecimal balance;
    private static ThreadLocal tluHolder = new ThreadLocal();
    private static Map managers = new HashMap();
    private Integer organizationId;

    private AccountManager() {
    }

    public static synchronized AccountManager getAccountManager(Integer organizationId) throws Exception {
        AccountManager accountManager = (AccountManager)managers.get(organizationId);
        if (accountManager == null) {
            accountManager = new AccountManager(organizationId);
            if (enableAccounting) {
                log.debug((Object)"Getting entity manager ......");
                EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
                Account account = (Account)em.find(Account.class, (Object)organizationId);
                if (account == null) {
                    Organization organization = (Organization)em.find(Organization.class, (Object)organizationId);
                    account = new Account(organization);
                    organization.setAccount(account);
                    em.persist((Object)account);
                    em.flush();
                }
                managers.put(organizationId, accountManager);
            }
        }
        return accountManager;
    }

    public AccountManager(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Transaction prepareTransaction(int type, String description) throws Exception {
        if (!AccountManager.isEnableAccounting()) {
            return null;
        }
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        Account account = (Account)em.find(Account.class, (Object)this.organizationId);
        Transaction transaction = new Transaction();
        transaction.setType(type);
        transaction.setStatus(Transaction.PENDING);
        transaction.setAccount(account);
        transaction.setDescription(description);
        em.persist((Object)transaction);
        em.flush();
        return transaction;
    }

    public Transaction beginTLU() throws Exception {
        Transaction tlu = this.prepareTransaction(Transaction.WITHDRAW, null);
        tluHolder.set(tlu);
        return tlu;
    }

    public Transaction getTLU() {
        return (Transaction)tluHolder.get();
    }

    public void endTLU() throws Exception {
        tluHolder.set(null);
    }

    public synchronized void commitTransaction(Transaction accountTransaction, User user) throws Exception {
        if (!enableAccounting) {
            return;
        }
        if (accountTransaction != null) {
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            Account account = (Account)em.find(Account.class, (Object)this.organizationId);
            this.balance = account.getCreditBalance();
            accountTransaction.setAccount(account);
            accountTransaction.setUser(user);
            try {
                accountTransaction.validate();
                BigDecimal newBalance = null;
                if (accountTransaction.getType() == Transaction.DEPOSIT) {
                    newBalance = this.balance.add(accountTransaction.getCreditAlteration());
                } else if (accountTransaction.getType() == Transaction.WITHDRAW) {
                    newBalance = this.balance.subtract(accountTransaction.getCreditAlteration());
                    if (newBalance.doubleValue() < 0.0) {
                        throw new TransactionDeniedException("Insufficient credits for transaction. Required credits: " + accountTransaction.getCreditAlteration().setScale(2, 4).toString() + ", Current balance: " + this.balance.setScale(2, 4).toString());
                    }
                } else {
                    log.error((Object)"Unsupported transaction type");
                    throw new Exception("Unsupported transaction type");
                }
                account.setCreditBalance(newBalance);
                accountTransaction.setMutationDate(new Date());
                accountTransaction.setStatus(Transaction.ACCEPTED);
                for (LayerPriceComposition lpc : accountTransaction.getLayerPriceCompositions()) {
                    em.persist((Object)lpc);
                }
                em.merge((Object)accountTransaction);
                em.flush();
                this.balance = newBalance;
            }
            catch (TransactionDeniedException tde) {
                accountTransaction.setErrorMessage(tde.getMessage());
                accountTransaction.setStatus(Transaction.REFUSED);
                em.merge((Object)accountTransaction);
                em.flush();
                throw tde;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBalance() throws Exception {
        if (!enableAccounting) {
            return 0.0;
        }
        if (this.balance == null) {
            Object identity = null;
            try {
                identity = MyEMFDatabase.createEntityManager((String)"mainEM");
                log.debug((Object)"Getting entity manager ......");
                EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
                Account account = (Account)em.find(Account.class, (Object)this.organizationId);
                this.balance = account.getCreditBalance();
            }
            finally {
                log.debug((Object)"Closing entity manager .....");
                MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
            }
        }
        if (this.balance != null) {
            return this.balance.setScale(2, 4).doubleValue();
        }
        return 0.0;
    }

    public List getTransactions(int listMax, int type) throws Exception {
        return this.getTransactions(0, listMax, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTransactions(int firstResult, int listMax, int type) throws Exception {
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            List resultList = null;
            StringBuffer q = new StringBuffer();
            q.append("FROM Transaction AS t ");
            q.append(" WHERE t.account.id = :accid");
            q.append(" AND t.type = :type");
            q.append(" ORDER by t.transactionDate DESC");
            Query query = em.createQuery(q.toString());
            query.setParameter("accid", (Object)this.organizationId);
            query.setParameter("type", (Object)type);
            query.setFirstResult(firstResult);
            query.setMaxResults(listMax);
            List list = resultList = query.getResultList();
            return list;
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
    }

    public static void setEnableAccounting(boolean state) {
        enableAccounting = state;
    }

    public static boolean isEnableAccounting() {
        return enableAccounting;
    }
}

