/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.accounting.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.TransactionDeniedException;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Account;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Transaction {
    private static final Log log = LogFactory.getLog(Transaction.class);
    private Integer id;
    private Date transactionDate;
    private Date mutationDate;
    private Account account;
    protected BigDecimal creditAlteration;
    private int status;
    private int type;
    private String errorMessage;
    private String description;
    private Integer userId;
    public static int PENDING = 0;
    public static int ACCEPTED = 1;
    public static int REFUSED = 2;
    public static int WITHDRAW = 1;
    public static int DEPOSIT = 2;
    private static Integer ExchangeRate = new Integer(100);
    private BigDecimal billingAmount;
    private Integer txExchangeRate;
    private Set layerPriceCompositions = new HashSet();
    private Set pricedLayerNames = new HashSet();

    public Transaction() {
        this.setTransactionDate(new Date());
        this.setStatus(PENDING);
        this.setType(WITHDRAW);
        this.creditAlteration = new BigDecimal("0");
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public Date getMutationDate() {
        return this.mutationDate;
    }

    public void setMutationDate(Date mutationDate) {
        this.mutationDate = mutationDate;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BigDecimal getCreditAlteration() {
        return this.creditAlteration;
    }

    public void setCreditAlteration(BigDecimal creditAlteration) {
        this.creditAlteration = creditAlteration;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void validate() throws TransactionDeniedException {
        if (this.getCreditAlteration().doubleValue() < 0.0) {
            throw new TransactionDeniedException("Transaction creditalteration cannot be less then zero.");
        }
        this.setCreditAlteration(this.getCreditAlteration().setScale(2, 4));
        if (this.billingAmount != null && this.billingAmount.doubleValue() > 9999.0) {
            log.error((Object)"Billingamount larger then 9999.");
            throw new TransactionDeniedException("Billingamount larger then 9999.");
        }
        if (this.getType() != WITHDRAW && this.getType() != DEPOSIT) {
            log.error((Object)"Only DEPOSIT or WITHDRAW is allowed for this transaction.");
            throw new TransactionDeniedException("Only DEPOSIT or WITHDRAW is allowed for this transaction.");
        }
    }

    private Integer getUserId() {
        return this.userId;
    }

    private void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setUser(User user) {
        if (user != null) {
            this.setUserId(user.getId());
        } else {
            this.setUserId(null);
        }
    }

    public User getUser(EntityManager em) {
        try {
            return (User)em.find(User.class, (Object)this.getUserId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Integer getExchangeRate() {
        return ExchangeRate;
    }

    public static void setExchangeRate(Integer aExchangeRate) {
        ExchangeRate = aExchangeRate;
    }

    public BigDecimal getBillingAmount() {
        return this.billingAmount;
    }

    public void setBillingAmount(BigDecimal billingAmount) {
        this.billingAmount = billingAmount;
    }

    public Integer getTxExchangeRate() {
        return this.txExchangeRate;
    }

    public void setTxExchangeRate(Integer txExchangeRate) {
        this.txExchangeRate = txExchangeRate;
    }

    public Set getLayerPriceCompositions() {
        return this.layerPriceCompositions;
    }

    public void setLayerPriceCompositions(Set layerPriceCompositions) {
        this.layerPriceCompositions = layerPriceCompositions;
    }

    public void registerUsage(LayerPriceComposition lpc) throws Exception {
        if (lpc == null) {
            log.error((Object)"Not allowed to add a null value to registerUsage.");
            throw new Exception("Not allowed to add a null value to registerUsage.");
        }
        if (lpc.getLayerPrice() == null || lpc.getLayerPrice().compareTo(new BigDecimal("0")) < 0) {
            log.error((Object)("Invalid value for lpc.layerPrice: " + lpc.getLayerPrice()));
            throw new Exception("Invalid value for lpc.layerPrice: " + lpc.getLayerPrice());
        }
        if (lpc.getLayerIsFree() == null || lpc.getLayerIsFree() != null && !lpc.getLayerIsFree().booleanValue()) {
            this.creditAlteration = this.creditAlteration.add(lpc.getLayerPrice());
            this.pricedLayerNames.add(lpc.getLayerName());
        }
        lpc.setTransaction(this);
        this.layerPriceCompositions.add(lpc);
    }

    public String getPricedLayerNames() {
        if (this.pricedLayerNames == null || this.pricedLayerNames.isEmpty()) {
            return null;
        }
        StringBuffer pln = new StringBuffer();
        Iterator it = this.pricedLayerNames.iterator();
        while (it.hasNext()) {
            if (pln.length() > 0) {
                pln.append(", ");
            }
            pln.append((String)it.next());
        }
        return pln.toString();
    }
}

