/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DescribeLayerRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(DescribeLayerRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        dw.setHeader("Content-Disposition", "inline; filename=\"DescribeLayer.xml\";");
        this.user = user;
        this.url = user.getPersonalURL(dw.getRequest(), dw.getOgcrequest().getServiceProviderName());
        Integer[] orgIds = user.getOrganizationIds();
        OGCRequest ogcRequest = dw.getOgcrequest();
        dw.setContentType("application/vnd.ogc.wms_xml");
        Long timeFromStart = new Long(dw.getRequestReporting().getMSSinceStart());
        String requestParam = ogcRequest.getParameter("REQUEST");
        String spInUrl = ogcRequest.getServiceProviderName();
        String[] la = ogcRequest.getParameter("LAYERS").split(",");
        List lsl = LayerSummary.createLayerSummaryList(Arrays.asList(la), (String)spInUrl, (spInUrl == null ? 1 : 0) != 0);
        List spInfo = this.getServiceProviderURLS(lsl, orgIds, false, dw, false);
        if (spInfo == null || spInfo.isEmpty()) {
            log.error((Object)(requestParam + ": no urls qualify for request."));
            throw new Exception("No Serviceprovider available! User might not have rights to any Serviceprovider!");
        }
        ArrayList<ServiceProviderRequest> urlWrapper = new ArrayList<ServiceProviderRequest>();
        for (SpLayerSummary spLayerSummary : spInfo) {
            ServiceProviderRequest dlrWrapper = new ServiceProviderRequest();
            dlrWrapper.setMsSinceRequestStart(timeFromStart);
            dlrWrapper.setWmsVersion(ogcRequest.getParameter("VERSION"));
            Integer serviceProviderId = spLayerSummary.getServiceproviderId();
            if (serviceProviderId != null && serviceProviderId == -1) continue;
            B3PCredentials credentials = new B3PCredentials();
            credentials.setUserName(spLayerSummary.getUsername());
            credentials.setPassword(spLayerSummary.getPassword());
            dlrWrapper.setServiceProviderId(serviceProviderId);
            dlrWrapper.setServiceProviderAbbreviation(spLayerSummary.getSpAbbr());
            dlrWrapper.setCredentials(credentials);
            String layersList = spLayerSummary.getLayersAsString();
            StringBuffer url = new StringBuffer();
            url.append(spLayerSummary.getSpUrl());
            if (url.indexOf("?") != url.length() - 1 && url.indexOf("&") != url.length() - 1) {
                if (url.indexOf("?") >= 0) {
                    url.append("&");
                } else {
                    url.append("?");
                }
            }
            String[] params = dw.getOgcrequest().getParametersArray();
            for (int i = 0; i < params.length; ++i) {
                String[] keyValuePair = params[i].split("=");
                if (keyValuePair[0].equalsIgnoreCase("LAYERS")) {
                    url.append("LAYERS");
                    url.append("=");
                    url.append(layersList);
                    url.append("&");
                    continue;
                }
                url.append(params[i]);
                url.append("&");
            }
            dlrWrapper.setProviderRequestURI(url.toString());
            urlWrapper.add(dlrWrapper);
        }
        this.getOnlineData(dw, urlWrapper, false, "DescribeLayer");
    }
}

