/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.ExtLayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.ProviderException;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.OGCRequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WFSRequestHandler
extends OGCRequestHandler {
    private static final Log log = LogFactory.getLog(WFSRequestHandler.class);

    public boolean mayDirectWrite() {
        return false;
    }

    public int getMaxResponseTime() {
        if (this.maxResponseTime <= 0) {
            try {
                this.maxResponseTime = new Integer(KBConfiguration.WFS_RESPONSE_TIME_LIMIT);
            }
            catch (NumberFormatException nfe) {
                this.maxResponseTime = 33333;
            }
        }
        return this.maxResponseTime;
    }

    public HttpPost createPostMethod(OGCRequest spOgcReq, SpLayerSummary sp, ServiceProviderRequest wfsRequest) throws Exception {
        String oldBody = spOgcReq.getXMLBody();
        String body = "";
        body = oldBody;
        log.debug((Object)("WFS POST to serviceprovider: '" + sp.getSpAbbr() + "' with url: '" + sp.getSpUrl() + "' and body:"));
        log.debug((Object)body);
        if (KBConfiguration.SAVE_MESSAGES) {
            wfsRequest.setMessageSent(body);
        }
        wfsRequest.setBytesSent(new Long(body.getBytes().length));
        OGCRequest tmpReq = new OGCRequest(spOgcReq.fixHttpHost(sp.getSpUrl()));
        tmpReq.removeAllWFSParameters();
        String postUrl = spOgcReq.getUrl(tmpReq.getUrl());
        HttpPost method = new HttpPost(postUrl);
        method.setEntity((HttpEntity)new StringEntity(body));
        return method;
    }

    public HttpGet createGetMethod(OGCRequest spOgcReq, SpLayerSummary sp, ServiceProviderRequest wfsRequest) throws Exception {
        OGCRequest tmpReq = new OGCRequest(spOgcReq.fixHttpHost(sp.getSpUrl()));
        tmpReq.removeAllWFSParameters();
        String getUrl = spOgcReq.getUrl(tmpReq.getUrl());
        log.debug((Object)("WFS GET to serviceprovider: '" + sp.getSpAbbr() + "' with url: '" + getUrl.toString() + "'"));
        if (KBConfiguration.SAVE_MESSAGES) {
            wfsRequest.setMessageSent(getUrl.toString());
        }
        wfsRequest.setBytesSent(new Long(getUrl.length()));
        return new HttpGet(getUrl.toString());
    }

    protected boolean checkNumberOfSps(List<LayerSummary> lsl, int n) {
        ArrayList<String> spl = new ArrayList<String>();
        for (LayerSummary ls : lsl) {
            if (spl.contains(ls.getSpAbbr())) continue;
            spl.add(ls.getSpAbbr());
        }
        return spl.size() == n;
    }

    public abstract String prepareRequest4Sp(OGCRequest var1, SpLayerSummary var2) throws Exception;

    public abstract List<LayerSummary> prepareRequestLayers(OGCRequest var1) throws Exception;

    public abstract OGCResponse getNewOGCResponse();

    public byte[] prepareDirectWrite(InputStream isx) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(DataWrapper data, User user) throws Exception {
        OGCResponse ogcresponse = this.getNewOGCResponse();
        OGCRequest ogcrequest = data.getOgcrequest();
        String version = ogcrequest.getFinalVersion();
        String spInUrl = ogcrequest.getServiceProviderName();
        Integer[] orgIds = user.getOrganizationIds();
        OutputStream os = data.getOutputStream();
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            boolean forAdmin = this.isConfigInUrlAndAdmin(data, user);
            List layerSummaryList = this.prepareRequestLayers(ogcrequest);
            if (layerSummaryList == null) {
                EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
                String[] al = this.getOrganisationLayers(em, orgIds, version, forAdmin);
                layerSummaryList = LayerSummary.createLayerSummaryList(Arrays.asList(al), (String)spInUrl, (boolean)true);
            }
            List spLayerSummaries = null;
            spLayerSummaries = forAdmin ? this.getLayerSummaries(layerSummaryList, spInUrl) : this.getServiceProviderURLS(layerSummaryList, orgIds, false, data, false);
            if (spLayerSummaries == null || spLayerSummaries.isEmpty()) {
                throw new UnsupportedOperationException("No Serviceprovider available! User might not have rights to any Serviceprovider!");
            }
            if (spLayerSummaries.size() > 1 && version.equals("unspecified")) {
                ogcrequest.addOrReplaceParameter("VERSION", "1.1.0");
            }
            DataMonitoring rr = data.getRequestReporting();
            long startprocestime = System.currentTimeMillis();
            String xmlEncoding = "UTF-8";
            for (SpLayerSummary sp : spLayerSummaries) {
                if (spInUrl != null && !spInUrl.equals(sp.getSpAbbr())) continue;
                sp.setSpInUrl(spInUrl);
                OGCRequest sprequest = (OGCRequest)ogcrequest.clone();
                this.prepareRequest4Sp(sprequest, sp);
                String lurl = sp.getSpUrl();
                if (lurl.length() == 0) {
                    throw new UnsupportedOperationException("No Serviceprovider for this service available!");
                }
                ServiceProviderRequest wfsRequest = this.createServiceProviderRequest(data, lurl, sp.getServiceproviderId(), Long.valueOf(0L));
                B3PCredentials credentials = new B3PCredentials();
                credentials.setUserName(sp.getUsername());
                credentials.setPassword(sp.getPassword());
                credentials.setUrl(lurl);
                HttpClientConfigured hcc = new HttpClientConfigured(credentials);
                Object method = null;
                method = sprequest.getHttpMethod().equalsIgnoreCase("POST") ? this.createPostMethod(sprequest, sp, wfsRequest) : this.createGetMethod(sprequest, sp, wfsRequest);
                try {
                    HttpResponse response = hcc.execute((HttpUriRequest)method);
                    try {
                        int statusCode = response.getStatusLine().getStatusCode();
                        wfsRequest.setResponseStatus(Integer.valueOf(statusCode));
                        HttpEntity entity = response.getEntity();
                        if (statusCode != 200) {
                            log.error((Object)("Failed to connect with " + method.getURI() + " Using body: " + sprequest.getXMLBody()));
                            throw new UnsupportedOperationException("Failed to connect with " + method.getURI() + " Using body: " + sprequest.getXMLBody());
                        }
                        wfsRequest.setRequestResponseTime(Long.valueOf(System.currentTimeMillis() - startprocestime));
                        data.setContentType("text/xml");
                        InputStream is = entity.getContent();
                        Object isx = null;
                        byte[] bytes = null;
                        int rsl = 0;
                        try {
                            rsl = new Integer(KBConfiguration.RESPONSE_SIZE_LIMIT);
                        }
                        catch (NumberFormatException nfe) {
                            log.debug((Object)("KBConfiguration.RESPONSE_SIZE_LIMIT not properly configured: " + nfe.getLocalizedMessage()));
                        }
                        if (KBConfiguration.SAVE_MESSAGES) {
                            int len = 1;
                            byte[] buffer = new byte[2024];
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                                bos.write(buffer, 0, len);
                                if (buffer.length <= rsl || rsl <= 0) continue;
                                throw new ProviderException("Response size exceeds maximum set in configuration:" + buffer.length + ", max is: " + rsl);
                            }
                            bytes = bos.toByteArray();
                            isx = new ByteArrayInputStream(bytes);
                        } else {
                            isx = new CountingInputStream(is);
                        }
                        if (KBConfiguration.SAVE_MESSAGES || spInUrl == null || !this.mayDirectWrite()) {
                            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                            dbf.setNamespaceAware(true);
                            DocumentBuilder builder = dbf.newDocumentBuilder();
                            Document doc = builder.parse((InputStream)isx);
                            String docEncoding = doc.getXmlEncoding();
                            if (docEncoding != null) {
                                xmlEncoding = docEncoding;
                            }
                            int len = 0;
                            if (KBConfiguration.SAVE_MESSAGES) {
                                wfsRequest.setMessageReceived(new String(bytes));
                            } else {
                                len = new Integer(isx.getCount());
                                wfsRequest.setBytesReceived(new Long(len));
                            }
                            if (len > rsl && rsl > 0) {
                                throw new ProviderException("Response size exceeds maximum set in configuration:" + len + ", max is: " + rsl);
                            }
                            String prefix = sp.getSpAbbr();
                            if (spInUrl != null && !spInUrl.isEmpty()) {
                                prefix = null;
                            }
                            if (OGCResponse.isWfsV100ErrorResponse((Element)doc.getDocumentElement())) {
                                ogcresponse.rebuildWfsV100ErrorResponse(doc, sprequest, prefix);
                                continue;
                            }
                            if (OGCResponse.isOwsV100ErrorResponse((Element)doc.getDocumentElement())) {
                                ogcresponse.rebuildOwsV100ErrorResponse(doc, sprequest, prefix);
                                continue;
                            }
                            ogcresponse.rebuildResponse(doc, sprequest, prefix);
                            continue;
                        }
                        byte[] h = this.prepareDirectWrite((InputStream)isx);
                        if (h != null) {
                            os.write(h);
                        }
                        IOUtils.copy((InputStream)isx, (OutputStream)os);
                        wfsRequest.setBytesReceived(new Long(isx.getCount()));
                        ogcresponse.setAlreadyDirectWritten(true);
                        break;
                    }
                    finally {
                        hcc.close(response);
                        hcc.close();
                    }
                }
                catch (Exception e) {
                    wfsRequest.setExceptionMessage("Failed to send bytes to client: " + e.getMessage());
                    wfsRequest.setExceptionClass(e.getClass());
                    throw e;
                }
                finally {
                    rr.addServiceProviderRequest(wfsRequest);
                }
            }
            if (!ogcresponse.isAlreadyDirectWritten()) {
                String responseBody = ogcresponse.getResponseBody(spLayerSummaries, ogcrequest, xmlEncoding);
                if (responseBody != null && !responseBody.equals("")) {
                    byte[] buffer = responseBody.getBytes(xmlEncoding);
                    os.write(buffer);
                } else {
                    throw new UnsupportedOperationException("XMLbody empty!");
                }
            }
            this.doAccounting(user.getMainOrganizationId(), data, user);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
    }

    protected LayerPriceComposition calculateLayerPriceComposition(DataWrapper dw, ExtLayerCalculator lc, String spAbbr, String layerName) throws Exception {
        String operation = dw.getOperation();
        if (operation == null) {
            log.error((Object)"Operation can not be null");
            throw new Exception("Operation can not be null");
        }
        String projection = dw.getOgcrequest().getParameter("SRSNAME");
        BigDecimal scale = new BigDecimal(dw.getOgcrequest().calcScale()).setScale(2, 4);
        int planType = 1;
        String service = "WFS";
        return lc.calculateLayerComplete(spAbbr, layerName, new Date(), projection, scale, new BigDecimal("1"), planType, service, operation);
    }

    protected SpLayerSummary getValidLayerObjects(EntityManager em, LayerSummary m, Integer[] orgIds, boolean b3pLayering) throws Exception {
        String query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true',sp) from WfsLayer l, Organization o, WfsServiceProvider sp join o.wfsLayers ol where l = ol and l.wfsServiceProvider = sp and o.id in (:orgIds) and l.name = :layerName and sp.abbr = :layerCode and sp.allowed = true";
        return this.getValidLayerObjects(em, query, m, orgIds, b3pLayering);
    }

    protected String[] getOrganisationLayers(EntityManager em, Integer[] orgIds, String version, boolean isAdmin) throws Exception {
        Query q;
        String query;
        List spLayers = null;
        if (!isAdmin) {
            query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true',sp) from Organization o join o.wfsLayers l join l.wfsServiceProvider sp where o.id in (:orgIds) and sp.allowed = true";
            if (version != null && !version.equals("unspecified")) {
                query = query + " and sp.wfsVersion = :version";
            }
            q = em.createQuery(query);
            if (orgIds != null) {
                List<Integer> lijst = Arrays.asList(orgIds);
                q.setParameter("orgIds", lijst);
            } else {
                q.setParameter("orgIds", null);
            }
            if (version != null && !version.equals("unspecified")) {
                q.setParameter("version", (Object)version);
            }
            spLayers = q.getResultList();
        } else {
            query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true',sp) from WfsLayer l join l.wfsServiceProvider sp";
            if (version != null && !version.equals("unspecified")) {
                query = query + " where sp.wfsVersion = :version";
            }
            q = em.createQuery(query);
            if (version != null && !version.equals("unspecified")) {
                q.setParameter("version", (Object)version);
            }
            spLayers = q.getResultList();
        }
        ArrayList<String> layers = new ArrayList<String>();
        for (SpLayerSummary spls : spLayers) {
            String ln = OGCCommunication.attachSp((String)spls.getSpAbbr(), (String)spls.getLayerName());
            layers.add(ln);
        }
        return layers.toArray(new String[0]);
    }

    protected String createUriString(OGCRequest ogcrequest, String lurl, String version) {
        StringBuffer url = new StringBuffer(lurl);
        if (!lurl.endsWith("?")) {
            url.append("?");
        }
        String[] params = ogcrequest.getParametersArray();
        for (int i = 0; i < params.length; ++i) {
            String key = params[i].split("=")[0];
            if (key.equalsIgnoreCase("VERSION")) {
                if (version != null) {
                    url.append("VERSION");
                    url.append("=");
                    url.append(version);
                }
            } else {
                url.append(params[i]);
            }
            url.append("&");
        }
        return url.toString();
    }

    protected ServiceProviderRequest createServiceProviderRequest(DataWrapper data, String url, Integer spId, Long bytesSent) {
        DataMonitoring rr = data.getRequestReporting();
        OGCRequest ogcrequest = data.getOgcrequest();
        ServiceProviderRequest wfsRequest = new ServiceProviderRequest();
        wfsRequest.setMsSinceRequestStart(new Long(rr.getMSSinceStart()));
        wfsRequest.setServiceProviderId(spId);
        String version = ogcrequest.getFinalVersion();
        if (version.equals("unspecified")) {
            version = null;
        }
        String uri = this.createUriString(ogcrequest, url, version);
        wfsRequest.setProviderRequestURI(uri);
        wfsRequest.setWmsVersion(version);
        wfsRequest.setBytesSent(bytesSent);
        return wfsRequest;
    }

    protected List<SpLayerSummary> getLayerSummaries(List<LayerSummary> lsl) throws Exception {
        return this.getLayerSummaries(LayerSummary.getLayersAsArray(lsl), null);
    }

    protected List<SpLayerSummary> getLayerSummaries(List<LayerSummary> lsl, String serviceName) throws Exception {
        return this.getLayerSummaries(LayerSummary.getLayersAsArray(lsl), serviceName);
    }

    private List<SpLayerSummary> getLayerSummaries(String[] layers) throws Exception {
        return this.getLayerSummaries(layers, null);
    }

    private List<SpLayerSummary> getLayerSummaries(String[] layers, String serviceName) throws Exception {
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        ArrayList<SpLayerSummary> eventualSPList = new ArrayList<SpLayerSummary>();
        for (int i = 0; i < layers.length; ++i) {
            String layer = layers[i];
            boolean splitName = serviceName == null || serviceName.isEmpty();
            LayerSummary m = OGCCommunication.splitLayerWithoutNsFix((String)layer, (boolean)splitName, (String)serviceName, null);
            String abbr = m.getSpAbbr();
            String name = OGCCommunication.buildLayerNameWithoutSp((LayerSummary)m);
            List matchingLayers = em.createQuery("from WfsLayer l where l.name = :name and l.wfsServiceProvider.abbr = :abbr").setParameter("name", (Object)name).setParameter("abbr", (Object)abbr).getResultList();
            if (matchingLayers.isEmpty()) {
                log.error((Object)("layer not found: " + layer));
                throw new Exception(KBConfiguration.REQUEST_NORIGHTS_EXCEPTION + ": " + layer);
            }
            if (matchingLayers.size() > 1) {
                log.error((Object)("layers with duplicate names, name: " + layer));
                throw new Exception(KBConfiguration.GETMAP_EXCEPTION);
            }
            WfsLayer l = (WfsLayer)matchingLayers.get(0);
            SpLayerSummary layerInfo = new SpLayerSummary(l, "true");
            this.addToServerProviderList(eventualSPList, layerInfo, false);
        }
        return eventualSPList;
    }
}

