/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.accounting;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.accounting.AccountManager;
import nl.b3p.kaartenbalie.core.server.accounting.LayerNotAvailableException;
import nl.b3p.kaartenbalie.core.server.accounting.NoPrizingException;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPricing;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LayerCalculator {
    private static final Log log = LogFactory.getLog(LayerCalculator.class);
    protected EntityManager em;
    protected Object identity = MyEMFDatabase.createEntityManager((String)"mainEM");

    public LayerCalculator() throws Exception {
        log.debug((Object)"Getting entity manager ......");
        this.em = MyEMFDatabase.getEntityManager((String)"mainEM");
    }

    public LayerPriceComposition calculateLayerComplete(String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) {
        long startTime = System.currentTimeMillis();
        if (!AccountManager.isEnableAccounting()) {
            return null;
        }
        LayerPriceComposition tLC = new LayerPriceComposition(spAbbr, layerName, validationDate, scale, projection, planType, units, service, operation);
        tLC.setService(service);
        BigDecimal layerPrice = null;
        try {
            try {
                layerPrice = this.calculateLayer(tLC, spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
            }
            catch (NoPrizingException npe) {
                tLC.setMethod(3);
            }
        }
        catch (LayerNotAvailableException lnae) {
            tLC.setMethod(-1);
        }
        tLC.setLayerIsFree(new Boolean(layerPrice == null));
        if (layerPrice == null) {
            tLC.setLayerPrice(new BigDecimal("0"));
        } else {
            tLC.setLayerPrice(layerPrice);
        }
        tLC.setCalculationTime(System.currentTimeMillis() - startTime);
        return tLC;
    }

    protected BigDecimal calculateLayer(LayerPriceComposition tLC, String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws LayerNotAvailableException, NoPrizingException {
        BigDecimal layerPrice = null;
        layerPrice = this.calculateLayer(spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
        tLC.setMethod(0);
        return layerPrice;
    }

    public List getSpLayerPricingList(String spabbr, Date validationDate, String service) {
        return this.em.createQuery("FROM LayerPricing AS lp WHERE (lp.deletionDate IS null OR lp.deletionDate > :validationDate) AND lp.serverProviderPrefix = :serverProviderPrefix AND lp.creationDate <= :validationDate AND (lp.validFrom <= :validationDate OR lp.validFrom IS null) AND (lp.validUntil >= :validationDate OR lp.validUntil IS null) AND (lp.service = :service) ORDER BY lp.creationDate DESC").setParameter("serverProviderPrefix", (Object)spabbr).setParameter("validationDate", (Object)validationDate).setParameter("service", (Object)service).getResultList();
    }

    protected List getActiveLayerPricingList(String spAbbr, String layerName, Date validationDate, int planType, String service, String operation) {
        return this.em.createQuery("FROM LayerPricing AS lp WHERE (lp.deletionDate IS null OR lp.deletionDate > :validationDate) AND lp.planType = :planType AND lp.layerName = :layerName AND lp.serverProviderPrefix = :serverProviderPrefix AND lp.creationDate <= :validationDate AND (lp.validFrom <= :validationDate OR lp.validFrom IS null) AND (lp.validUntil >= :validationDate OR lp.validUntil IS null) AND (lp.service = :service) AND (lp.operation = :operation OR lp.operation IS null) ORDER BY lp.creationDate DESC").setParameter("layerName", (Object)layerName).setParameter("serverProviderPrefix", (Object)spAbbr).setParameter("validationDate", (Object)validationDate).setParameter("planType", (Object)new Integer(planType)).setParameter("operation", (Object)operation).setParameter("service", (Object)service).getResultList();
    }

    public boolean ActiveLayerPricingExists(String spAbbr, String layerName, Date validationDate, int planType, String service, String operation) {
        try {
            List possibleLayerPricings = this.getActiveLayerPricingList(spAbbr, layerName, validationDate, planType, service, operation);
            return possibleLayerPricings != null && possibleLayerPricings.size() != 0;
        }
        catch (Exception e) {
            log.error((Object)"Error collecting layer pricings: ", (Throwable)e);
            return false;
        }
    }

    public LayerPricing getActiveLayerPricing(String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, int planType, String service, String operation) throws LayerNotAvailableException, NoPrizingException {
        LayerPricing plp;
        List possibleLayerPricings = this.getActiveLayerPricingList(spAbbr, layerName, validationDate, planType, service, operation);
        Iterator layerPricingIter = possibleLayerPricings.iterator();
        LayerPricing layerPricing = null;
        boolean requireProjection = false;
        while (layerPricingIter.hasNext()) {
            plp = (LayerPricing)layerPricingIter.next();
            if (layerPricing == null) {
                layerPricing = plp;
            }
            if (plp.getProjection() == null) continue;
            requireProjection = true;
            break;
        }
        if (requireProjection) {
            if (projection == null) {
                log.error((Object)"Projection cannot be null");
                throw new LayerNotAvailableException("Projection cannot be null");
            }
            if (scale == null) {
                log.error((Object)"Scale cannot be null");
                throw new LayerNotAvailableException("Scale cannot be null");
            }
            while (layerPricingIter.hasNext()) {
                plp = (LayerPricing)layerPricingIter.next();
                if (plp.getProjection() == null || plp.getMinScale() != null && plp.getMinScale().compareTo(scale) > 0 || plp.getMaxScale() != null && plp.getMaxScale().compareTo(scale) < 0 || !plp.getProjection().equalsIgnoreCase(projection)) continue;
                layerPricing = plp;
                break;
            }
            if (layerPricing == null) {
                throw new LayerNotAvailableException();
            }
        }
        if (layerPricing == null) {
            throw new NoPrizingException();
        }
        return layerPricing;
    }

    public BigDecimal calculateLayer(String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws NoPrizingException, LayerNotAvailableException {
        log.debug((Object)("spAbbr: " + spAbbr + ", layerName: " + layerName + ", validationDate: " + validationDate + ", projection: " + projection + ", scale: " + scale + ", units: " + units + ", planType: " + planType + ", service: " + service + ", operation: " + operation));
        if (spAbbr == null) {
            log.error((Object)"spAbbr is required!");
            throw new LayerNotAvailableException("spAbbr is required!");
        }
        if (validationDate == null) {
            log.error((Object)"ValidationDate is a required field!");
            throw new LayerNotAvailableException("ValidationDate is a required field!");
        }
        if (units == null) {
            log.error((Object)"Units is a required field!");
            throw new LayerNotAvailableException("Units is a required field!");
        }
        if (planType <= 0) {
            log.error((Object)"PlanType is a required field!");
            throw new LayerNotAvailableException("PlanType is a required field!");
        }
        if (layerName == null || layerName.trim().length() == 0) {
            throw new NoPrizingException("Layer is a placeholder and therefor cannot hold pricingInformation.");
        }
        BigDecimal layerPrice = null;
        LayerPricing layerPricing = this.getActiveLayerPricing(spAbbr, layerName, validationDate, projection, scale, planType, service, operation);
        if (layerPricing.getUnitPrice() != null && (layerPricing.getLayerIsFree() == null || layerPricing.getLayerIsFree() != null && !layerPricing.getLayerIsFree().booleanValue())) {
            layerPrice = layerPricing.getUnitPrice().multiply(units);
        }
        if (layerPrice != null && layerPrice.compareTo(new BigDecimal(0)) < 0) {
            layerPrice = new BigDecimal("0");
        }
        return layerPrice;
    }

    public void closeEntityManager() throws Exception {
        log.debug((Object)"Closing entity manager .....");
        MyEMFDatabase.closeEntityManager((Object)this.identity, (String)"mainEM");
    }
}

