/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.KBCrypter;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(ProxyRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        Integer[] orgIds = user.getOrganizationIds();
        OGCRequest ogcrequest = dw.getOgcrequest();
        String spInUrl = ogcrequest.getServiceProviderName();
        String[] la = ogcrequest.getParameter("LAYER").split(",");
        List lsl = LayerSummary.createLayerSummaryList(Arrays.asList(la), (String)spInUrl, (spInUrl == null ? 1 : 0) != 0);
        if (lsl == null || lsl.size() != 1) {
            log.error((Object)"Only one layer for proxy.");
            throw new Exception(KBConfiguration.KB_PROXY_EXECPTION);
        }
        List spUrls = this.getServiceProviderURLS(lsl, orgIds, false, dw, false);
        if (spUrls == null || spUrls.size() != 1) {
            log.error((Object)"Only one layer for proxy.");
            throw new Exception(KBConfiguration.KB_PROXY_EXECPTION);
        }
        SpLayerSummary spInfo = (SpLayerSummary)spUrls.get(0);
        if (spInfo == null) {
            log.error((Object)"No urls found!");
            throw new Exception(KBConfiguration.KB_PROXY_EXECPTION);
        }
        B3PCredentials credentials = new B3PCredentials();
        credentials.setUserName(spInfo.getUsername());
        credentials.setPassword(spInfo.getPassword());
        String decodedUrl = ogcrequest.getParameter("PURL");
        if (decodedUrl == null || decodedUrl.length() == 0) {
            log.error((Object)KBConfiguration.KB_PROXY_EXECPTION);
            throw new Exception(KBConfiguration.KB_PROXY_EXECPTION);
        }
        String encodedUrl = URLEncoder.encode(decodedUrl);
        String purl = KBCrypter.decryptText((String)encodedUrl);
        OGCRequest proxyrequest = new OGCRequest(purl);
        String proxyUrl = proxyrequest.getUrl();
        ServiceProviderRequest proxyWrapper = new ServiceProviderRequest();
        proxyWrapper.setProviderRequestURI(proxyUrl);
        proxyWrapper.setServiceName(dw.getOgcrequest().getServiceProviderName());
        proxyWrapper.setCredentials(credentials);
        ArrayList<ServiceProviderRequest> urlWrapper = new ArrayList<ServiceProviderRequest>();
        urlWrapper.add(proxyWrapper);
        this.getOnlineData(dw, urlWrapper, false, KBConfiguration.KB_PROXY);
    }
}

