/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.b3pLayering;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import nl.b3p.kaartenbalie.core.server.b3pLayering.AllowTransactionsLayer;
import nl.b3p.kaartenbalie.core.server.b3pLayering.KBTitleLayer;
import nl.b3p.kaartenbalie.service.KBImageTool;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ConfigLayer
extends Layer {
    private static final Log log = LogFactory.getLog(ConfigLayer.class);
    private static Map configLayers = new HashMap();

    protected ConfigLayer() {
    }

    protected ConfigLayer(String name, String title) {
        this.setName(name.toLowerCase());
        this.setTitle(title);
        SrsBoundingBox srsbb1 = new SrsBoundingBox();
        srsbb1.setLayer((Layer)this);
        srsbb1.setMinx("3.3");
        srsbb1.setMiny("50.5");
        srsbb1.setMaxx("7.2");
        srsbb1.setMaxy("53.5");
        this.addSrsbb(srsbb1);
        SrsBoundingBox srsbb2 = new SrsBoundingBox();
        srsbb2.setLayer((Layer)this);
        srsbb2.setSrs("EPSG:28992");
        srsbb2.setMinx("12000");
        srsbb2.setMiny("304000");
        srsbb2.setMaxx("280000");
        srsbb2.setMaxy("620000");
        this.addSrsbb(srsbb2);
        this.setMetadata(KBConfiguration.SERVICEPROVIDER_BASE_HTTP);
        this.setQueryable("0");
        this.setCascaded("0");
        this.setOpaque("0");
    }

    public static ConfigLayer forName(String configLayerName) throws Exception {
        if (configLayerName == null || configLayerName.trim().length() == 0) {
            log.error((Object)"ConfigLayerName is a required field!");
            throw new Exception("ConfigLayerName is a required field!");
        }
        Class configLayerClass = (Class)configLayers.get(configLayerName = configLayerName.trim());
        if (configLayerClass == null) {
            log.error((Object)("Trying to fetch unregistered or non-existing configLayer ' " + configLayerName + "'."));
            throw new Exception("Trying to fetch unregistered or non-existing configLayer ' " + configLayerName + "'.");
        }
        return (ConfigLayer)configLayerClass.newInstance();
    }

    public static BufferedImage handleRequest(String url, Map parameterMap) throws Exception {
        String mime = "image/png";
        parameterMap.put("showname", new Boolean(false));
        parameterMap.put("transparant", new Boolean(true));
        OGCRequest ogcrequest = new OGCRequest(url);
        String[] layers = ogcrequest.getParameter("LAYERS").split(",");
        BufferedImage[] bufImages = new BufferedImage[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            ConfigLayer configLayer = ConfigLayer.forName((String)layers[i]);
            bufImages[i] = configLayer.drawImage(ogcrequest, parameterMap);
        }
        String mimeType = KBImageTool.getMimeType((String)"image/png");
        if (mimeType == null) {
            log.error((Object)("unsupported mime type: " + mime));
            throw new Exception("unsupported mime type: " + mime);
        }
        return KBImageTool.combineImages((BufferedImage[])bufImages, (String)mimeType);
    }

    public static Map getConfigLayers() {
        return configLayers;
    }

    public BufferedImage drawImage(OGCRequest ogcrequest, Map parameterMap) throws Exception {
        Boolean transparant;
        if (parameterMap == null) {
            parameterMap = new HashMap<String, Boolean>();
        }
        if ((transparant = (Boolean)parameterMap.get("transparant")) == null) {
            transparant = new Boolean(false);
            parameterMap.put("transparant", transparant);
        }
        return this.imageHandler(ogcrequest, parameterMap);
    }

    protected BufferedImage createBaseImage(OGCRequest ogcrequest, Map parameterMap) throws Exception {
        Boolean transparant = (Boolean)parameterMap.get("transparant");
        int width = Integer.parseInt(ogcrequest.getParameter("WIDTH"));
        int height = Integer.parseInt(ogcrequest.getParameter("HEIGHT"));
        BufferedImage bufImage = null;
        bufImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bufImage.createGraphics();
        if (!transparant.booleanValue()) {
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, width, height);
        }
        return bufImage;
    }

    protected void addTagsToImage(BufferedImage bufImage, Map parameterMap) {
        Graphics2D g2d = (Graphics2D)bufImage.getGraphics();
        Boolean showName = (Boolean)parameterMap.get("showname");
        if (showName != null && showName.booleanValue()) {
            this.drawTitledMessageBox(g2d, "KaartenBalie", "Message for Layer '" + super.getUniqueName() + "'", 20, 20, 300, 30);
        }
    }

    public BufferedImage imageHandler(OGCRequest ogcrequest, Map parameterMap) throws Exception {
        BufferedImage bufImage = this.createBaseImage(ogcrequest, parameterMap);
        this.addTagsToImage(bufImage, parameterMap);
        return this.modifyBaseImage(bufImage, parameterMap);
    }

    public void sendImage(DataWrapper data, BufferedImage bufImage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OGCRequest ogcrequest = data.getOgcrequest();
        String requestedImageType = ogcrequest.getParameter("FORMAT");
        String imageType = null;
        if (requestedImageType.equalsIgnoreCase("image/jpeg")) {
            imageType = "JPEG";
        } else if (requestedImageType.equalsIgnoreCase("image/png")) {
            imageType = "PNG";
        } else if (requestedImageType.equalsIgnoreCase("image/gif")) {
            imageType = "GIF";
        } else {
            log.error((Object)("Unsupported ImageType: " + requestedImageType));
            throw new Exception("Unsupported ImageType: " + requestedImageType);
        }
        ImageIO.write((RenderedImage)bufImage, imageType, baos);
        data.write(baos);
    }

    protected abstract BufferedImage modifyBaseImage(BufferedImage var1, Map var2) throws Exception;

    public abstract void processConfig(Map var1) throws Exception;

    private void conditionalWrite(Graphics2D g2d, String line, int x, int y, int maxY) {
        if ((line = line.trim()).length() > 0 && y < maxY) {
            g2d.drawString(line, x, y);
        }
    }

    protected void drawEdgedBox(Graphics g2d, int x, int y, int w, int h) {
        g2d.setColor(KBConfiguration.OHD_borderBoxBackground);
        g2d.fillRect(x, y, w, h);
        g2d.setColor(KBConfiguration.OHD_borderBoxTopLeft);
        g2d.drawLine(x, y, x + w, y);
        g2d.drawLine(x, y + h, x, y);
        g2d.setColor(KBConfiguration.OHD_borderBoxBottomRight);
        g2d.drawLine(x + w, y + h, x, y + h);
        g2d.drawLine(x + w, y, x + w, y + h);
    }

    protected void drawTitledMessageBox(Graphics2D g2d, String title, String message, int x, int y, int w, int h) {
        int labelHeight;
        g2d.setFont(KBConfiguration.OHD_messageBoxFont);
        FontMetrics fm = g2d.getFontMetrics();
        int angling = labelHeight = KBConfiguration.OHD_messageBoxFont.getSize() + KBConfiguration.OHD_padding * 2;
        Rectangle2D testRectangle = fm.getStringBounds(title, g2d);
        int labelWidth = (int)testRectangle.getWidth();
        if (w < labelWidth + 2 * angling) {
            w = labelWidth + 2 * angling;
        }
        this.drawMessageBox(g2d, message, x, y += labelHeight, w, h);
        g2d.setColor(KBConfiguration.OHD_labelBoxColor);
        GeneralPath label = new GeneralPath();
        label.moveTo(x, y);
        label.lineTo(x + angling, y - labelHeight);
        label.lineTo(x + angling + labelWidth, y - labelHeight);
        label.lineTo(x + angling * 2 + labelWidth, y);
        label.closePath();
        g2d.fill(label);
        g2d.setColor(KBConfiguration.OHD_borderBoxTopLeft);
        g2d.drawLine(x, y, x + angling, y - labelHeight);
        g2d.drawLine(x + angling, y - labelHeight, x + angling + labelWidth, y - labelHeight);
        g2d.setColor(KBConfiguration.OHD_borderBoxBottomRight);
        g2d.drawLine(x + angling + labelWidth, y - labelHeight, x + angling * 2 + labelWidth, y);
        g2d.setColor(KBConfiguration.OHD_borderBoxBackground);
        g2d.drawLine(x + angling * 2 + labelWidth, y, x, y);
        g2d.setColor(KBConfiguration.OHD_labelFontBoxColor);
        g2d.drawString(title, x + angling, y - KBConfiguration.OHD_padding);
    }

    protected void drawMessageBox(Graphics2D g2d, String message, int x, int y, int w, int h) {
        this.drawEdgedBox((Graphics)g2d, x, y, w, h);
        if (message == null) {
            message = "null";
        }
        x += KBConfiguration.OHD_padding;
        y += KBConfiguration.OHD_padding;
        w -= KBConfiguration.OHD_padding;
        h -= KBConfiguration.OHD_padding;
        g2d.setFont(KBConfiguration.OHD_messageBoxFont);
        g2d.setColor(KBConfiguration.OHD_fontBoxColor);
        FontMetrics fm = g2d.getFontMetrics();
        int fontHeight = KBConfiguration.OHD_messageBoxFont.getSize();
        int yOffset = y;
        String[] lines = message.split("\n");
        for (int j = 0; j < lines.length; ++j) {
            String[] words = lines[j].split(" ");
            String line = "";
            for (int i = 0; i < words.length; ++i) {
                String testLine = new String(line + " " + words[i]);
                Rectangle2D testRectangle = fm.getStringBounds(testLine, g2d);
                if (testRectangle.getWidth() > (double)w) {
                    this.conditionalWrite(g2d, line, x, yOffset + fontHeight, y + h);
                    line = words[i];
                    yOffset += fontHeight;
                    continue;
                }
                line = testLine;
            }
            this.conditionalWrite(g2d, line, x, yOffset + fontHeight, y + h);
            yOffset += fontHeight + KBConfiguration.OHD_lineSpacing;
        }
    }

    static {
        configLayers.put("allowwithdrawals", AllowTransactionsLayer.class);
        configLayers.put("kaartenbalie", KBTitleLayer.class);
    }
}

