/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.accounting.LayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPricing;
import nl.b3p.kaartenbalie.service.GroupParser;
import nl.b3p.kaartenbalie.service.WmsWfsParser;
import nl.b3p.ogc.sld.SldWriter;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.WMSCapabilitiesReader;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class WMSParser
extends WmsWfsParser {
    private ServiceProvider oldServiceProvider = null;

    public String saveProvider(HttpServletRequest request, DynaValidatorForm dynaForm) throws Exception {
        Boolean updateRights;
        Set layerSet;
        OGCRequest ogcu;
        EntityManager em = WMSParser.getEntityManager();
        String url = FormUtils.nullIfEmpty((String)dynaForm.getString("url"));
        Boolean ignoreResource = (Boolean)dynaForm.get("ignoreResource");
        try {
            ogcu = this.checkWmsUrl(url.trim());
        }
        catch (Exception e) {
            this.exception = e;
            return "Not a WMS URL";
        }
        ServiceProvider newServiceProvider = null;
        this.oldServiceProvider = this.getServiceProvider(dynaForm, false);
        Integer oldId = null;
        if (this.oldServiceProvider != null) {
            oldId = this.oldServiceProvider.getId();
        }
        if (!this.isAbbrUnique(oldId, dynaForm, em)) {
            return "error.abbr.notunique";
        }
        B3PCredentials credentials = new B3PCredentials();
        String username = dynaForm.getString("username");
        String password = dynaForm.getString("password");
        String abbreviation = FormUtils.nullIfEmpty((String)dynaForm.getString("abbr"));
        if (username != null && !username.equals("")) {
            credentials.setUserName(username);
            credentials.setPassword(password);
        }
        try {
            String givenName = FormUtils.nullIfEmpty((String)dynaForm.getString("givenName"));
            newServiceProvider = WMSParser.saveServiceProvider((String)ogcu.getUrl(), (B3PCredentials)credentials, (String)givenName, (String)abbreviation, (EntityManager)em);
        }
        catch (IOException e) {
            log.error((Object)"Error saving server", (Throwable)e);
            return "error.serverconnection";
        }
        catch (SAXException e) {
            log.error((Object)"Error saving server", (Throwable)e);
            return "error.malformedcapability";
        }
        catch (Exception e) {
            log.error((Object)"Error saving server", (Throwable)e);
            this.exception = e;
            return "Error_saving";
        }
        if (ignoreResource != null && ignoreResource.booleanValue()) {
            newServiceProvider.setUrl(ogcu.getUrlWithNonOGCparams());
        }
        if (username != null) {
            newServiceProvider.setUserName(username);
            newServiceProvider.setPassword(password);
        }
        this.populateServerObject(dynaForm, newServiceProvider);
        em.persist((Object)newServiceProvider);
        em.flush();
        SldWriter sldWriter = new SldWriter();
        String sldUrl = FormUtils.nullIfEmpty((String)dynaForm.getString("sldUrl"));
        if (sldUrl != null) {
            sldWriter.parseByUrl(sldUrl.trim(), credentials);
        }
        if ((layerSet = newServiceProvider.getAllLayers()) == null) {
            String error_duplicate = "Controleer het mapserver bestand en kijk of er geen dubbele LAYER NAMES in voorkomen. De MAP NAME mag ook niet hetzelfde zijn als een LAYER NAME.";
            log.error((Object)error_duplicate);
            throw new Exception(error_duplicate);
        }
        for (Layer layer : layerSet) {
            sldWriter.addSldStylesSet(layer);
            HashSet<Layer> topLayerSet = new HashSet<Layer>();
            if (this.oldServiceProvider != null) {
                topLayerSet.add(this.oldServiceProvider.getTopLayer());
            }
            Layer oldLayer = this.checkLayer(layer, topLayerSet);
            this.setMetadataFromLayerSource(layer, oldLayer, credentials);
        }
        if (this.oldServiceProvider != null) {
            List orgList = em.createQuery("from Organization").getResultList();
            Iterator orgit = orgList.iterator();
            while (orgit.hasNext()) {
                HashSet<Layer> newOrganizationLayer = new HashSet<Layer>();
                Organization org = (Organization)orgit.next();
                Set orgLayers = org.getLayers();
                for (Layer organizationLayer : orgLayers) {
                    ServiceProvider orgLayerServiceProvider = organizationLayer.getServiceProvider();
                    if (orgLayerServiceProvider.getId() == this.oldServiceProvider.getId()) {
                        HashSet<Layer> topLayerSet = new HashSet<Layer>();
                        topLayerSet.add(newServiceProvider.getTopLayer());
                        Layer newLayer = this.checkLayer(organizationLayer, topLayerSet);
                        if (newLayer == null) continue;
                        newOrganizationLayer.add(newLayer);
                        continue;
                    }
                    newOrganizationLayer.add(organizationLayer);
                }
                org.setLayers(newOrganizationLayer);
                em.flush();
            }
            try {
                Set oldLayers = this.oldServiceProvider.getAllLayers();
                for (Set orgLayers : oldLayers) {
                }
                em.remove((Object)this.oldServiceProvider);
                em.flush();
            }
            catch (Exception e) {
                this.exception = e;
                return "Error_deleting_old_provider";
            }
        }
        FormFile thisFile = (FormFile)dynaForm.get("uploadFile");
        Boolean overwrite = (Boolean)dynaForm.get("overwrite");
        String uploadError = null;
        if (thisFile != null && thisFile.getFileName() != null && !thisFile.getFileName().equals("")) {
            uploadError = this.uploadFile(thisFile, overwrite, abbreviation);
        }
        if ((updateRights = (Boolean)dynaForm.get("updateRights")) != null && updateRights.booleanValue()) {
            String[] orgSelected = dynaForm.getStrings("orgSelected");
            GroupParser.addRightsForAllLayers((String[])orgSelected, (ServiceProvider)newServiceProvider, (EntityManager)em);
        }
        if (uploadError != null && !uploadError.equals("OK")) {
            return uploadError;
        }
        return "OK";
    }

    public int test(DynaValidatorForm dynaForm) throws Exception {
        EntityManager em = WMSParser.getEntityManager();
        String regexp = FormUtils.nullIfEmpty((String)dynaForm.getString("regexp"));
        String replacement = FormUtils.nullIfEmpty((String)dynaForm.getString("replacement"));
        int fout = 0;
        try {
            List wmsServices = em.createQuery("from ServiceProvider").getResultList();
            for (ServiceProvider sp : wmsServices) {
                ServiceProvider newSp;
                String newUrl = sp.getUrl();
                B3PCredentials credentials = sp.getCredentials();
                if (regexp != null && replacement != null && !regexp.isEmpty() && !replacement.isEmpty()) {
                    newUrl = newUrl.replaceAll(regexp, replacement);
                }
                if ((newSp = this.getTestServiceProvider(newUrl, credentials)) != null) {
                    sp.setStatus("GOED");
                    continue;
                }
                sp.setStatus("FOUT");
                ++fout;
            }
            em.flush();
        }
        catch (Exception ex) {
            log.error((Object)("Er iets iets fout gegaan tijdens het testen van de WMS Services: " + ex));
        }
        return fout;
    }

    public int batchUpdate(DynaValidatorForm dynaForm) throws Exception {
        return this.batchUpdate(dynaForm, "");
    }

    public int batchUpdate(DynaValidatorForm dynaForm, String prefix) throws Exception {
        EntityManager em = WMSParser.getEntityManager();
        String regexp = FormUtils.nullIfEmpty((String)dynaForm.getString("regexp"));
        String replacement = FormUtils.nullIfEmpty((String)dynaForm.getString("replacement"));
        int fout = 0;
        try {
            List wmsServices = prefix.equals("") ? em.createQuery("from ServiceProvider").getResultList() : em.createQuery("from ServiceProvider WHERE abbr=:abbr").setParameter("abbr", (Object)prefix).getResultList();
            for (ServiceProvider serviceProvider : wmsServices) {
                ServiceProvider newServiceProvider;
                String newUrl = serviceProvider.getUrl();
                B3PCredentials credentials = serviceProvider.getCredentials();
                if (regexp != null && replacement != null && !regexp.isEmpty() && !replacement.isEmpty()) {
                    newUrl = newUrl.replaceAll(regexp, replacement);
                }
                if ((newServiceProvider = this.getTestServiceProvider(newUrl, credentials)) != null) {
                    newServiceProvider.setStatus("GOED");
                } else {
                    serviceProvider.setStatus("FOUT");
                    ++fout;
                }
                if (newServiceProvider == null) continue;
                this.updateServiceProvider(serviceProvider, newServiceProvider);
            }
            em.flush();
        }
        catch (Exception ex) {
            log.error((Object)("Er iets iets fout gegaan tijdens de batch update van de WMS Services: " + ex));
            this.exception = ex;
        }
        return fout;
    }

    protected OGCRequest checkWmsUrl(String url) throws Exception {
        OGCRequest ogcrequest = new OGCRequest(url);
        if (ogcrequest.containsParameter("REQUEST") && !"GetCapabilities".equalsIgnoreCase(ogcrequest.getParameter("REQUEST"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_REQUEST);
            throw new Exception(KBConfiguration.UNSUPPORTED_REQUEST);
        }
        ogcrequest.addOrReplaceParameter("REQUEST", "GetCapabilities");
        if (ogcrequest.containsParameter("SERVICE") && !"WMS".equalsIgnoreCase(ogcrequest.getParameter("SERVICE"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_SERVICE);
            throw new Exception(KBConfiguration.UNSUPPORTED_SERVICE);
        }
        ogcrequest.addOrReplaceParameter("SERVICE", "WMS");
        if (ogcrequest.containsParameter("VERSION") && !"1.1.1".equalsIgnoreCase(ogcrequest.getParameter("VERSION"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_VERSION);
            throw new Exception(KBConfiguration.UNSUPPORTED_VERSION);
        }
        ogcrequest.addOrReplaceParameter("VERSION", "1.1.1");
        return ogcrequest;
    }

    public ServiceProvider getServiceProvider(DynaValidatorForm dynaForm, boolean createNew) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WMSParser.getEntityManager();
        Integer id = this.getInt(dynaForm, "id");
        ServiceProvider serviceProvider = null;
        if (null == id && createNew) {
            serviceProvider = new ServiceProvider();
        } else if (null != id) {
            serviceProvider = (ServiceProvider)em.find(ServiceProvider.class, (Object)new Integer(id));
        }
        return serviceProvider;
    }

    public static ServiceProvider saveServiceProvider(String url, B3PCredentials credentials, String givenName, String abbreviation, EntityManager em) throws Exception {
        WMSCapabilitiesReader wms = new WMSCapabilitiesReader();
        ServiceProvider serviceProvider = wms.getProvider(url, credentials);
        serviceProvider.setGivenName(givenName);
        serviceProvider.setAbbr(abbreviation);
        serviceProvider.setUpdatedDate(new Date());
        serviceProvider.setUserName("");
        serviceProvider.setPassword("");
        Set layerSet = serviceProvider.getAllLayers();
        em.persist((Object)serviceProvider);
        em.flush();
        return serviceProvider;
    }

    public void populateServerObject(DynaValidatorForm dynaForm, ServiceProvider serviceProvider) {
        serviceProvider.setUpdatedDate(new Date());
        serviceProvider.setUserName(FormUtils.nullIfEmpty((String)dynaForm.getString("username")));
        serviceProvider.setPassword(FormUtils.nullIfEmpty((String)dynaForm.getString("password")));
        String sldUrl = FormUtils.nullIfEmpty((String)dynaForm.getString("sldUrl"));
        serviceProvider.setSldUrl(sldUrl);
        Boolean ignoreResource = (Boolean)dynaForm.get("ignoreResource");
        if (ignoreResource != null && ignoreResource.booleanValue()) {
            serviceProvider.setIgnoreResource(ignoreResource);
        } else {
            serviceProvider.setIgnoreResource(Boolean.valueOf(false));
        }
    }

    private void updateServiceProvider(ServiceProvider oldServiceProvider, ServiceProvider newServiceProvider) throws Exception {
        EntityManager em = WMSParser.getEntityManager();
        if (oldServiceProvider.getIgnoreResource() != null && oldServiceProvider.getIgnoreResource().booleanValue()) {
            newServiceProvider.setIgnoreResource(oldServiceProvider.getIgnoreResource());
            newServiceProvider.setUrl(oldServiceProvider.getUrl());
        }
        String username = oldServiceProvider.getUserName();
        String password = oldServiceProvider.getPassword();
        newServiceProvider.setGivenName(oldServiceProvider.getGivenName());
        newServiceProvider.setUpdatedDate(new Date());
        newServiceProvider.setAbbr(oldServiceProvider.getAbbr());
        newServiceProvider.setUserName(username);
        newServiceProvider.setPassword(password);
        newServiceProvider.setAllowed(oldServiceProvider.getAllowed());
        B3PCredentials credentials = oldServiceProvider.getCredentials();
        Set layerSet = newServiceProvider.getAllLayers();
        em.persist((Object)newServiceProvider);
        em.flush();
        for (Layer layer : layerSet) {
            HashSet<Layer> topLayerSet = new HashSet<Layer>();
            if (oldServiceProvider != null) {
                topLayerSet.add(oldServiceProvider.getTopLayer());
            }
            Layer oldLayer = this.checkLayer(layer, topLayerSet);
            this.setMetadataFromLayerSource(layer, oldLayer, credentials);
        }
        if (oldServiceProvider != null) {
            List orgList = em.createQuery("from Organization").getResultList();
            Iterator orgit = orgList.iterator();
            while (orgit.hasNext()) {
                HashSet<Layer> newOrganizationLayer = new HashSet<Layer>();
                Organization org = (Organization)orgit.next();
                Set orgLayers = org.getLayers();
                for (Layer organizationLayer : orgLayers) {
                    ServiceProvider orgLayerServiceProvider = organizationLayer.getServiceProvider();
                    if (orgLayerServiceProvider.getId() == oldServiceProvider.getId()) {
                        HashSet<Layer> topLayerSet = new HashSet<Layer>();
                        topLayerSet.add(newServiceProvider.getTopLayer());
                        Layer newLayer = this.checkLayer(organizationLayer, topLayerSet);
                        if (newLayer == null) continue;
                        newOrganizationLayer.add(newLayer);
                        continue;
                    }
                    newOrganizationLayer.add(organizationLayer);
                }
                org.setLayers(newOrganizationLayer);
                em.flush();
            }
            try {
                Set oldLayers = oldServiceProvider.getAllLayers();
                for (Layer layer : oldLayers) {
                }
                em.remove((Object)oldServiceProvider);
                em.flush();
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens verwijderen oude serviceprovider", (Throwable)e);
            }
        }
    }

    private ServiceProvider getTestServiceProvider(String url, B3PCredentials credentials) throws Exception {
        OGCRequest ogcu = this.checkWmsUrl(url.trim());
        WMSCapabilitiesReader wms = new WMSCapabilitiesReader();
        ServiceProvider sp = null;
        try {
            sp = wms.getProvider(ogcu.getUrl(), credentials);
        }
        catch (IOException ioex) {
            return null;
        }
        catch (SAXException saxex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteConfirm(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        this.parseMessages.clear();
        EntityManager em = WMSParser.getEntityManager();
        ServiceProvider serviceProvider = this.getServiceProvider(dynaForm, false);
        if (null == serviceProvider) {
            return "error.notfound";
        }
        Layer serviceProviderTopLayer = serviceProvider.getTopLayer();
        if (serviceProviderTopLayer != null) {
            MessageResources messages = this.getResources(request);
            Locale locale = this.getLocale(request);
            String orgJoinedMessage = messages.getMessage(locale, "beheer.server.org.joined");
            String layerJoinedMessage = messages.getMessage(locale, "beheer.server.layer.joined");
            StringBuffer strMessage = new StringBuffer();
            List orgList = em.createQuery("from Organization").getResultList();
            Iterator orgit = orgList.iterator();
            boolean notFirstOrg = false;
            while (orgit.hasNext()) {
                Organization org = (Organization)orgit.next();
                Set orgLayers = org.getLayers();
                Iterator orgLayerIterator = orgLayers.iterator();
                boolean notFirstLayer = false;
                while (orgLayerIterator.hasNext()) {
                    Layer organizationLayer = (Layer)orgLayerIterator.next();
                    Layer organizationLayerTopLayer = organizationLayer.getTopLayer();
                    if (organizationLayerTopLayer == null || organizationLayerTopLayer.getId() != serviceProviderTopLayer.getId()) continue;
                    if (notFirstLayer) {
                        strMessage.append(", ");
                    } else {
                        if (notFirstOrg) {
                            strMessage.append(", ");
                        } else {
                            strMessage.append(orgJoinedMessage);
                            strMessage.append(": ");
                            notFirstOrg = true;
                        }
                        strMessage.append(org.getName());
                        strMessage.append(" [");
                        strMessage.append(layerJoinedMessage);
                        strMessage.append(": ");
                        notFirstLayer = true;
                    }
                    strMessage.append(organizationLayer.getName());
                }
                if (!notFirstLayer) continue;
                strMessage.append("]");
            }
            if (strMessage.length() > 0) {
                this.parseMessages.add(strMessage.toString());
            }
            List lpList = null;
            LayerCalculator lc = new LayerCalculator();
            try {
                lpList = lc.getSpLayerPricingList(serviceProvider.getAbbr(), new Date(), "WMS");
            }
            finally {
                lc.closeEntityManager();
            }
            if (lpList != null) {
                Iterator lpit = lpList.iterator();
                strMessage = new StringBuffer();
                String pricingJoinedMessage = messages.getMessage(locale, "beheer.server.pricing.joined");
                boolean notFirstPrice = false;
                while (lpit.hasNext()) {
                    LayerPricing lp = (LayerPricing)lpit.next();
                    String ln = lp.getLayerName();
                    if (strMessage.indexOf(ln) != -1) continue;
                    if (notFirstPrice) {
                        strMessage.append(", ");
                    } else {
                        strMessage.append(pricingJoinedMessage);
                        strMessage.append(": ");
                        notFirstPrice = true;
                    }
                    strMessage.append(ln);
                }
                if (strMessage.length() > 0) {
                    this.parseMessages.add(strMessage.toString());
                }
            }
        }
        return "acknowledgeMessages";
    }

    public String delete(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WMSParser.getEntityManager();
        if (!this.isTokenValid(request)) {
            return "error.token";
        }
        ServiceProvider serviceProvider = this.getServiceProvider(dynaForm, false);
        if (null == serviceProvider) {
            return "error.notfound";
        }
        Layer serviceProviderTopLayer = serviceProvider.getTopLayer();
        if (serviceProviderTopLayer != null) {
            List orgList = em.createQuery("from Organization").getResultList();
            for (Organization org : orgList) {
                Set orgLayers = org.getLayers();
                HashSet clonedOrgLayers = new HashSet();
                clonedOrgLayers.addAll(orgLayers);
                for (Layer organizationLayer : orgLayers) {
                    Layer organizationLayerTopLayer = organizationLayer.getTopLayer();
                    if (organizationLayerTopLayer == null || organizationLayerTopLayer.getId() != serviceProviderTopLayer.getId()) continue;
                    clonedOrgLayers.remove(organizationLayer);
                }
                if (orgLayers.size() == clonedOrgLayers.size()) continue;
                org.setLayers(clonedOrgLayers);
                em.merge((Object)org);
            }
        }
        em.remove((Object)serviceProvider);
        em.flush();
        return "OK";
    }

    public ServiceProvider getOldServiceProvider() {
        return this.oldServiceProvider;
    }

    public boolean abbrExists(String abbr, EntityManager em) {
        try {
            ServiceProvider dbSp = (ServiceProvider)em.createQuery("from ServiceProvider sp where lower(sp.abbr) = lower(:abbr) ").setParameter("abbr", (Object)abbr).getSingleResult();
            return dbSp != null;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    public static void addRightsForAllLayers(String[] orgSelected, ServiceProvider sp, EntityManager em) throws Exception {
        GroupParser.addRightsForAllLayers((String[])orgSelected, (ServiceProvider)sp, (EntityManager)em);
    }

    public static void addAllLayersToGroup(Organization org, ServiceProvider sp, EntityManager em) throws Exception {
        GroupParser.addAllLayersToGroup((Organization)org, (ServiceProvider)sp, (EntityManager)em);
    }

    public List<ServiceProvider> getNotAllowedServices(EntityManager em) {
        try {
            List providers = em.createQuery("from ServiceProvider sp WHERE sp.allowed=:allowed order by givenName asc").setParameter("allowed", (Object)false).getResultList();
            return providers;
        }
        catch (Exception ex) {
            log.error((Object)"error collecting allowed ServiceProviders", (Throwable)ex);
            return null;
        }
    }

    public List<ServiceProvider> getAllowedServices(EntityManager em) {
        try {
            List providers = em.createQuery("from ServiceProvider sp WHERE sp.allowed=:allowed order by givenName asc").setParameter("allowed", (Object)true).getResultList();
            return providers;
        }
        catch (Exception ex) {
            log.error((Object)"error collecting allowed ServiceProviders", (Throwable)ex);
            return null;
        }
    }

    public void addAllowedService(String abbr, EntityManager em) throws Exception {
        ServiceProvider sp = this.getProviderByUrl(abbr, em);
        if (sp == null) {
            throw new Exception("Adding unknown WMS service with name " + abbr);
        }
        if (sp.getAllowed().booleanValue()) {
            throw new Exception("Trying to add the service " + sp.getAbbr() + " wich is allready added.");
        }
        sp.setAllowed(Boolean.valueOf(true));
        em.persist((Object)sp);
        em.flush();
    }

    public void deleteAllowedService(String abbr, EntityManager em) throws Exception {
        ServiceProvider sp = this.getProviderByUrl(abbr, em);
        if (sp == null) {
            throw new Exception("Deleting unknown WMS service with name " + abbr);
        }
        if (!sp.getAllowed().booleanValue()) {
            throw new Exception("Trying to delete the service " + sp.getAbbr() + " wich is not added.");
        }
        sp.setAllowed(Boolean.valueOf(false));
        em.persist((Object)sp);
        em.flush();
    }

    public void deleteAllAllowedServices(EntityManager em) {
        em.createQuery("UPDATE ServiceProvider SET allowed=false").executeUpdate();
    }

    private ServiceProvider getProviderByUrl(String abbr, EntityManager em) {
        try {
            ServiceProvider dbSp = (ServiceProvider)em.createQuery("from ServiceProvider sp where sp.abbr=:abbr ").setParameter("abbr", (Object)abbr).getSingleResult();
            return dbSp;
        }
        catch (Exception ex) {
            log.error((Object)"error locating ServiceProvider", (Throwable)ex);
            return null;
        }
    }
}

