/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.Operation;
import nl.b3p.ogc.utils.OGCRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataWrapper {
    private static final Log log = LogFactory.getLog(DataWrapper.class);
    private String errorContentType;
    private int contentLength;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private OutputStream sos;
    private String operation;
    private String service;
    private DataMonitoring requestReporting;
    private Map layeringParameterMap;
    private OGCRequest ogcrequest;

    public DataWrapper(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        this.sos = response.getOutputStream();
        this.layeringParameterMap = new HashMap();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public String getErrorContentType() {
        return this.errorContentType;
    }

    public void setErrorContentType(String errorContentType) {
        this.errorContentType = errorContentType;
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void setBufferSize(int buffer) {
        this.response.setBufferSize(buffer);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.response.setCharacterEncoding(characterEncoding);
    }

    private void setContentLength(int lenght) {
        this.response.setContentLength(lenght);
        this.contentLength = lenght;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setDateHeader(String name, long date) {
        this.response.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public OutputStream getOutputStream() {
        return this.sos;
    }

    public void write(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = 0;
        while ((bytesRead = is.read()) != -1) {
            baos.write(bytesRead);
        }
        this.write(baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteArrayOutputStream baos) throws IOException {
        if (this.response.isCommitted()) {
            String contentType = this.response.getContentType();
            log.error((Object)String.format("Response already committed, can't send %d bytes of content type %s", baos.size(), contentType));
            if (log.isDebugEnabled() && (contentType == null || !contentType.startsWith("image/"))) {
                log.error((Object)("Full content: " + baos.toString()));
            }
            return;
        }
        Operation o = new Operation();
        o.setType(3);
        if (this.requestReporting != null) {
            o.setDataSize(new Long(baos.size()));
            o.setMsSinceRequestStart(new Long(this.requestReporting.getMSSinceStart()));
        }
        long startTime = System.currentTimeMillis();
        this.setContentLength(baos.size());
        try {
            this.sos.write(baos.toByteArray());
            this.sos.flush();
        }
        finally {
            if (this.sos != null) {
                this.sos.close();
            }
        }
        if (this.requestReporting != null) {
            o.setDuration(new Long(System.currentTimeMillis() - startTime));
            try {
                this.requestReporting.addRequestOperation(o);
            }
            catch (Throwable t) {
                log.warn((Object)"", t);
            }
        }
    }

    public Map getLayeringParameterMap() {
        return this.layeringParameterMap;
    }

    public DataMonitoring getRequestReporting() {
        return this.requestReporting;
    }

    public void setRequestReporting(DataMonitoring requestReporting) {
        this.requestReporting = requestReporting;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public OGCRequest getOgcrequest() {
        return this.ogcrequest;
    }

    public void setOgcrequest(OGCRequest ogcrequest) {
        this.ogcrequest = ogcrequest;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

