/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetLegendGraphicRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(GetLegendGraphicRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        this.user = user;
        this.url = user.getPersonalURL(dw.getRequest(), dw.getOgcrequest().getServiceProviderName());
        Integer[] orgIds = user.getOrganizationIds();
        OGCRequest ogc = dw.getOgcrequest();
        String value = "";
        if (ogc.containsParameter("FORMAT")) {
            value = ogc.getParameter("FORMAT");
            if (value != null && value.length() > 0) {
                dw.setContentType(value);
            } else {
                dw.setContentType("application/vnd.ogc.wms_xml");
            }
        }
        String spInUrl = ogc.getServiceProviderName();
        String[] la = ogc.getParameter("LAYER").split(",");
        List lsl = LayerSummary.createLayerSummaryList(Arrays.asList(la), (String)spInUrl, (spInUrl == null ? 1 : 0) != 0);
        if (lsl == null || lsl.size() != 1) {
            log.error((Object)"Only one layer for legend graphic.");
            throw new Exception(KBConfiguration.LEGENDGRAPHIC_EXCEPTION);
        }
        List spUrls = this.getServiceProviderURLS(lsl, orgIds, false, dw, false);
        if (spUrls == null || spUrls.size() != 1) {
            log.error((Object)"Only one layer for legend graphic.");
            throw new Exception(KBConfiguration.LEGENDGRAPHIC_EXCEPTION);
        }
        SpLayerSummary spInfo = (SpLayerSummary)spUrls.get(0);
        if (spInfo == null) {
            log.error((Object)"No urls found!");
            throw new Exception(KBConfiguration.LEGENDGRAPHIC_EXCEPTION);
        }
        ArrayList<ServiceProviderRequest> urlWrapper = new ArrayList<ServiceProviderRequest>();
        ServiceProviderRequest lgrWrapper = new ServiceProviderRequest();
        Integer serviceProviderId = spInfo.getServiceproviderId();
        if (serviceProviderId == null || serviceProviderId != -1) {
            B3PCredentials credentials = new B3PCredentials();
            credentials.setUserName(spInfo.getUsername());
            credentials.setPassword(spInfo.getPassword());
            lgrWrapper.setCredentials(credentials);
            lgrWrapper.setServiceProviderId(serviceProviderId);
            StringBuffer url = this.createOnlineUrl(spInfo, ogc, dw.getRequest().getRequestURL().toString());
            String serviceRequestURI = url.toString();
            lgrWrapper.setProviderRequestURI(serviceRequestURI);
            urlWrapper.add(lgrWrapper);
            this.getOnlineData(dw, urlWrapper, false, "GetLegendGraphic");
        }
    }
}

