/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WFSRequestHandler;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.ogc.utils.WFSGetFeatureResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WFSGetFeatureRequestHandler
extends WFSRequestHandler {
    private static final Log log = LogFactory.getLog(WFSGetFeatureRequestHandler.class);

    public boolean mayDirectWrite() {
        return true;
    }

    public byte[] prepareDirectWrite(InputStream isx) throws IOException {
        int posQC;
        int posQO;
        byte[] buffer = new byte[2024];
        int len = isx.read(buffer, 0, buffer.length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(buffer, 0, len);
        String header = new String(bos.toByteArray());
        int posSL = header.toLowerCase().indexOf("schemalocation");
        String newHeader = header;
        if (posSL > 0 && (posQO = header.indexOf("\"", posSL)) > 0 && (posQC = header.indexOf("\"", posQO + 1)) > 0) {
            newHeader = header.substring(0, posQO + 1) + header.substring(posQC);
        }
        return newHeader.getBytes();
    }

    private String repairIntersects(String version, String filter) {
        if (filter != null && version != null && version.equals("1.0.0") && filter.contains("<Intersects>") && filter.contains("</Intersects>")) {
            return filter.replace("<Intersects>", "<Intersect>").replace("</Intersects>", "</Intersect>");
        }
        return filter;
    }

    public String prepareRequest4Sp(OGCRequest ogcrequest, SpLayerSummary sp) {
        if (ogcrequest.getHttpMethod().equalsIgnoreCase("POST")) {
            LayerSummary l = null;
            try {
                l = OGCCommunication.splitLayerWithoutNsFix((String)sp.getLayerName(), (boolean)false, (String)sp.getSpAbbr(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l != null) {
                String propertyNames;
                String filter = ogcrequest.getGetFeatureFilter(OGCCommunication.buildFullLayerName(l));
                filter = this.repairIntersects(ogcrequest.getFinalVersion(), filter);
                if (filter != null) {
                    ogcrequest.addOrReplaceParameter("FILTER", filter);
                }
                if ((propertyNames = ogcrequest.getGetFeaturePropertyNameList(OGCCommunication.buildFullLayerName((LayerSummary)l))) != null) {
                    ogcrequest.addOrReplaceParameter("PROPERTYNAME", propertyNames);
                }
            }
        } else {
            String filter = ogcrequest.getParameter("FILTER");
            filter = this.repairIntersects(ogcrequest.getFinalVersion(), filter);
            ogcrequest.addOrReplaceParameter("FILTER", filter);
        }
        String layerParam = "";
        List lsl = sp.getLayers();
        for (LayerSummary ls : lsl) {
            if (!layerParam.isEmpty()) {
                layerParam = layerParam + ",";
            }
            layerParam = layerParam + OGCCommunication.buildLayerNameWithoutSp((LayerSummary)ls);
        }
        ogcrequest.addOrReplaceParameter("TYPENAME", layerParam);
        return null;
    }

    public List<LayerSummary> prepareRequestLayers(OGCRequest ogcrequest) throws Exception {
        List<String> allLayers = null;
        if (ogcrequest.getHttpMethod().equals("POST")) {
            Set layers = ogcrequest.getGetFeatureFilterMap().keySet();
            allLayers.addAll(layers);
        } else {
            String typeName = ogcrequest.getParameter("TYPENAME");
            allLayers = Arrays.asList(typeName.split(","));
        }
        String spInUrl = ogcrequest.getServiceProviderName();
        List lsl = LayerSummary.createLayerSummaryList(allLayers, (String)ogcrequest.getServiceProviderName(), (spInUrl == null ? 1 : 0) != 0);
        if (!this.checkNumberOfSps(lsl, 1)) {
            log.error((Object)"More then 1 service provider addressed. Not supported (yet)");
            throw new UnsupportedOperationException("More then 1 service provider addressed. Not supported (yet)");
        }
        return lsl;
    }

    public OGCResponse getNewOGCResponse() {
        return new WFSGetFeatureResponse();
    }

    public void getRequest(DataWrapper data, User user) throws IOException, Exception {
        this.writeResponse(data, user);
    }
}

