/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.AccessDeniedException;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.util.LDAPUtil;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.KBCrypter;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OgcWfsClient;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class GeneralServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog(GeneralServlet.class);
    private static boolean updateUserLastLoginStatus;

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public static StringBuffer createBaseUrl(HttpServletRequest request) {
        return GeneralServlet.createBaseUrl((HttpServletRequest)request, (boolean)false);
    }

    public static StringBuffer createBaseUrl(HttpServletRequest request, boolean useInternal) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = useInternal ? KBConfiguration.KB_SERVICES_INTERNAL_CONTEXT_PATH : KBConfiguration.KB_SERVICES_CONTEXT_PATH;
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = request.getContextPath();
        }
        StringBuffer theUrl = new StringBuffer();
        String serverURI = useInternal ? KBConfiguration.KB_SERVICES_INTERNAL_SERVER_URI : KBConfiguration.KB_SERVICES_SERVER_URI;
        if (serverURI != null && serverURI.length() > 5) {
            theUrl.append(serverURI);
        } else {
            theUrl.append(scheme);
            theUrl.append("://");
            theUrl.append(serverName);
            if (scheme.equals("http") && serverPort != 80 || scheme.equals("https") && serverPort != 443) {
                theUrl.append(":");
                theUrl.append(serverPort);
            }
        }
        theUrl.append(contextPath);
        return theUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User checkLogin(HttpServletRequest request, String pcode) throws Exception {
        User user = null;
        Object identity = null;
        EntityTransaction tx = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            tx = em.getTransaction();
            tx.begin();
            user = GeneralServlet.checkLogin((HttpServletRequest)request, (String)pcode, (EntityManager)em);
            tx.commit();
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
        return user;
    }

    public static User checkLogin(HttpServletRequest request, String pcode, EntityManager em) throws AccessDeniedException {
        boolean isValidIp;
        boolean wasAlreadyLoggedIn;
        User user = GeneralServlet.checkLoginAlreadyLoggedIn((HttpServletRequest)request, (EntityManager)em, (String)pcode);
        boolean bl = wasAlreadyLoggedIn = user != null;
        if (user == null && (user = GeneralServlet.checkLoginPersonalCode((HttpServletRequest)request, (EntityManager)em, (String)pcode)) != null && !(isValidIp = GeneralServlet.checkValidIpAddress((HttpServletRequest)request, (User)user))) {
            GeneralServlet.setDetachedUserLastLoginStatus((User)user, (String)"Ongeldig IP", (EntityManager)em);
            user = null;
        }
        if (user == null) {
            user = GeneralServlet.checkLoginPreemptiveAuthentication((HttpServletRequest)request, (EntityManager)em);
        }
        if (user == null) {
            user = GeneralServlet.checkLoginLDAP((HttpServletRequest)request, (EntityManager)em);
        }
        if (user == null) {
            throw new AccessDeniedException("Ongeldige inloggegevens");
        }
        boolean expired = GeneralServlet.isUserTimeoutExpired((EntityManager)em, (User)user);
        if (expired) {
            GeneralServlet.setDetachedUserLastLoginStatus((User)user, (String)"Account verlopen", (EntityManager)em);
            throw new AccessDeniedException("Gebruikersaccount \"" + user.getName() + "\" is verlopen");
        }
        if (!wasAlreadyLoggedIn) {
            log.debug((Object)("Gebruiker " + user.getName() + " succesvol ingelogd"));
            GeneralServlet.setDetachedUserLastLoginStatus((User)user, null, (EntityManager)em);
        } else {
            log.debug((Object)("Gebruiker " + user.getName() + " was al ingelogd (sessie of cookie)"));
        }
        return user;
    }

    protected static User checkLoginAlreadyLoggedIn(HttpServletRequest request, EntityManager em, String pcode) {
        User user = (User)request.getUserPrincipal();
        if (user != null) {
            String userCode = user.getPersonalURL();
            if (pcode != null && userCode != null && !pcode.equals(userCode)) {
                user = null;
            }
        }
        if (user != null) {
            log.debug((Object)("Gebruiker " + user.getName() + " al ingelogd via cookie."));
        }
        return user;
    }

    protected static User checkLoginPersonalCode(HttpServletRequest request, EntityManager em, String pcode) {
        User user = null;
        if (pcode != null) {
            try {
                user = (User)em.createQuery("from User u where u.personalURL = :personalURL").setParameter("personalURL", (Object)pcode).getSingleResult();
            }
            catch (NonUniqueResultException nue) {
                log.debug((Object)("Meerdere gebruikers gevonden bij persoonlijke code: " + pcode));
                user = null;
            }
            catch (NoResultException nre) {
                log.debug((Object)"Persoonlijke code niet gevonden.");
                user = null;
            }
            if (user != null) {
                log.debug((Object)("Persoonlijke code gevonden bij gebruiker: " + user.getName()));
            }
        }
        return user;
    }

    protected static User checkLoginPreemptiveAuthentication(HttpServletRequest request, EntityManager em) {
        User user = null;
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null) {
            String decoded = GeneralServlet.decodeBasicAuthorizationString((String)authorizationHeader);
            String username = GeneralServlet.parseUsername((String)decoded);
            String password = GeneralServlet.parsePassword((String)decoded);
            String encpw = null;
            try {
                encpw = KBCrypter.encryptText((String)password);
            }
            catch (Exception ex) {
                log.error((Object)"Fout tijdens encrypten wachtwoord: ", (Throwable)ex);
            }
            try {
                user = (User)em.createQuery("from User u where lower(u.username) = lower(:username) and u.password = :password").setParameter("username", (Object)username).setParameter("password", (Object)encpw).getSingleResult();
            }
            catch (NonUniqueResultException nue) {
                log.error((Object)"Meerdere gebruikers gevonden via encrypted wachtwoord.");
                user = null;
            }
            catch (NoResultException nre) {
                log.debug((Object)"Geen gebruiker gevonden via encrypted wachtwoord.");
                user = null;
            }
            if (user == null) {
                try {
                    user = (User)em.createQuery("from User u where lower(u.username) = lower(:username) ").setParameter("username", (Object)username).getSingleResult();
                }
                catch (NoResultException nre) {
                    log.debug((Object)("Gebruiker " + username + " niet gevonden in db."));
                    user = null;
                }
                if (user != null && !user.getPassword().equals(encpw)) {
                    user.setLastLoginStatus("Verkeerd wachtwoord");
                    em.merge((Object)user);
                    em.flush();
                    log.debug((Object)("Wachtwoord voor gebruiker " + username + " verkeerd."));
                    user = null;
                }
            }
        }
        if (user != null) {
            log.debug((Object)("Basic authentication gelukt voor gebruiker: " + user.getName()));
        }
        return user;
    }

    protected static User checkLoginLDAP(HttpServletRequest request, EntityManager em) {
        User user = null;
        String authorizationHeader = request.getHeader("Authorization");
        if (MyEMFDatabase.getLdapUseLdap() != null && MyEMFDatabase.getLdapUseLdap().booleanValue() && authorizationHeader != null) {
            LDAPUtil ldapUtil = new LDAPUtil();
            String decoded = GeneralServlet.decodeBasicAuthorizationString((String)authorizationHeader);
            String username = GeneralServlet.parseUsername((String)decoded);
            String password = GeneralServlet.parsePassword((String)decoded);
            boolean inLdap = ldapUtil.userInLdap(MyEMFDatabase.getLdapHost(), MyEMFDatabase.getLdapPort().intValue(), username, password, MyEMFDatabase.getLdapUserSuffix());
            user = ldapUtil.getUserByName(em, username);
            if (inLdap && user == null) {
                user = new User();
                user.setUsername(username);
                user.setPassword(User.createCode());
                List gebruikerRol = ldapUtil.getGebruikerRol(em);
                user.getRoles().retainAll(gebruikerRol);
                user.getRoles().addAll(gebruikerRol);
                HashSet<String> ips = new HashSet<String>(1);
                ips.add("0.0.0.0");
                user.setIps(ips);
                String personalUrl = User.createCode();
                user.setPersonalURL(personalUrl);
                if (MyEMFDatabase.getLdapDefaultGroup() != null && !MyEMFDatabase.getLdapDefaultGroup().isEmpty()) {
                    Organization org = ldapUtil.getLDAPOrg(em, MyEMFDatabase.getLdapDefaultGroup());
                    user.setMainOrganization(org);
                }
                Date userTimeOut = ldapUtil.getDefaultTimeOut(36);
                user.setTimeout(userTimeOut);
                user.setLastLoginStatus(null);
                em.persist((Object)user);
                em.flush();
                log.debug((Object)("Gebruiker " + username + " in Ldap maar nog niet in db."));
                return user;
            }
            if (inLdap && user != null) {
                user.setLastLoginStatus(null);
                em.flush();
                log.debug((Object)("Gebruiker " + username + " in Ldap en al in db."));
                return user;
            }
            if (!inLdap && user != null) {
                user.setLastLoginStatus("Verkeerd wachtwoord");
                em.flush();
                log.debug((Object)("Gebruiker " + username + " niet in Ldap maar wel in db."));
                return null;
            }
            log.debug((Object)("Gebruiker " + username + " niet in Ldap en niet in db."));
        }
        return user;
    }

    private static void setDetachedUserLastLoginStatus(User user, String status, EntityManager em) {
        if (!updateUserLastLoginStatus) {
            return;
        }
        if (!em.contains((Object)user)) {
            em.createQuery("update User set lastLoginStatus = :status where id = :id").setParameter("status", (Object)status).setParameter("id", (Object)user.getId()).executeUpdate();
        } else {
            user.setLastLoginStatus(status);
        }
    }

    private static boolean checkValidIpAddress(HttpServletRequest request, User user) {
        return false;
    }

    private static boolean isUserTimeoutExpired(EntityManager em, User user) {
        if (user.getTimeout() != null && user.getTimeout().before(new Date())) {
            log.info((Object)("Account van " + user.getUsername() + " is verlopen"));
            return true;
        }
        return false;
    }

    protected static boolean isRemoteAddressWithinIpRange(String ip, String remote) {
        if (ip == null || remote == null) {
            return false;
        }
        String[] arrIp = ip.split("\\.");
        String[] arrRemote = remote.split("\\.");
        if (arrIp == null || arrIp.length < 1 || arrRemote == null || arrRemote.length < 1) {
            return false;
        }
        for (int i = 0; i < arrIp.length; ++i) {
            if (arrIp[i].equalsIgnoreCase("*") || arrIp[i].equalsIgnoreCase(arrRemote[i])) continue;
            return false;
        }
        return true;
    }

    public abstract void parseRequestAndData(DataWrapper var1, User var2) throws IllegalArgumentException, UnsupportedOperationException, IOException, Exception;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected OGCRequest calcOGCRequest(HttpServletRequest request) throws UnsupportedEncodingException, ParserConfigurationException, SAXException, IOException, ValidationException, Exception {
        OGCRequest ogcrequest;
        StringBuffer baseUrl = GeneralServlet.createBaseUrl((HttpServletRequest)request);
        String iUrl = this.completeUrl(baseUrl, request).toString();
        if (request.getMethod().equalsIgnoreCase("GET")) {
            ogcrequest = new OGCRequest(iUrl);
            log.debug((Object)("Incoming Get URL: " + iUrl));
        } else if (request.getMethod().equalsIgnoreCase("POST") && request.getParameter("SERVICE") != null && request.getParameter("SERVICE").equalsIgnoreCase("WMS")) {
            ogcrequest = new OGCRequest(iUrl);
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                String paramName = (String)params.nextElement();
                String paramValue = request.getParameter(paramName);
                if (paramName.equalsIgnoreCase("onload") || paramName.equalsIgnoreCase("ondata") || paramName.equalsIgnoreCase("loadmovie") || paramName.equalsIgnoreCase("oldloadmovie")) continue;
                ogcrequest.addOrReplaceParameter(paramName, paramValue);
            }
            log.debug((Object)("Incoming POST converted to GET URL: " + ogcrequest.getUrlWithNonOGCparams()));
        } else {
            log.debug((Object)("Incoming POST URL (content follows): " + iUrl));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse((InputStream)request.getInputStream());
            ogcrequest = new OGCRequest(doc.getDocumentElement(), baseUrl.toString());
            log.debug((Object)("Incoming POST content: \n" + OgcWfsClient.elementToString((Element)doc.getDocumentElement())));
        }
        ogcrequest.setHttpMethod(request.getMethod());
        return ogcrequest;
    }

    protected StringBuffer requestUrl(StringBuffer baseUrl, HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (servletPath != null && servletPath.length() != 0) {
            baseUrl.append(servletPath);
        }
        if (pathInfo != null && pathInfo.length() != 0) {
            baseUrl.append(pathInfo);
        }
        return baseUrl;
    }

    protected StringBuffer completeUrl(StringBuffer baseUrl, HttpServletRequest request) {
        baseUrl = this.requestUrl(baseUrl, request);
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() != 0) {
            baseUrl.append("?");
            baseUrl.append(queryString);
        }
        return baseUrl;
    }

    protected static String parseUsername(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(0, colon).trim();
    }

    protected static String parsePassword(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(colon + 1).trim();
    }

    protected static String decodeBasicAuthorizationString(String authorization) {
        if (authorization == null || !authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        return new String(Base64.decodeBase64((byte[])authorization.getBytes()));
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log = LogFactory.getLog(this.getClass());
        log.debug((Object)"Initializing GeneralServlet");
        updateUserLastLoginStatus = "true".equalsIgnoreCase(config.getInitParameter("user.updateLastLoginStatus"));
    }

    public abstract String getServletInfo();
}

