/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server;

import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.service.servlet.CallWMSServlet;
import nl.b3p.wms.capabilities.Roles;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class User
implements Principal {
    private static final Log log = LogFactory.getLog(User.class);
    private Integer id;
    private String firstName;
    private String surname;
    private String emailAddress;
    private String username;
    private String password;
    private String personalURL;
    private String defaultGetMap;
    private Date timeout;
    private Organization mainOrganization;
    private Set organizations = new HashSet();
    private Set roles = new HashSet();
    private Set ips = new HashSet();
    private String lastLoginStatus;
    public static final String LOGIN_STATE_INVALID_IP = "Ongeldig IP";
    public static final String LOGIN_STATE_EXPIRED = "Account verlopen";
    public static final String LOGIN_STATE_WRONG_PASSW = "Verkeerd wachtwoord";
    Object o = null;

    public Integer getId() {
        return this.id;
    }

    protected void setId(Integer id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set getOrganizations() {
        return this.organizations;
    }

    public Set getAllOrganizations() {
        Organization mainOrg;
        HashSet<Organization> orgs = new HashSet<Organization>();
        Set lorgs = this.getOrganizations();
        if (lorgs != null && !lorgs.isEmpty()) {
            orgs.addAll(lorgs);
        }
        if ((mainOrg = this.getMainOrganization()) != null && !orgs.contains(mainOrg)) {
            orgs.add(mainOrg);
        }
        return orgs;
    }

    public void setOrganizations(Set organizations) {
        this.organizations = organizations;
    }

    public void addOrganization(Organization o) {
        this.organizations.add(o);
    }

    public String getOrganisationCodes() {
        Set orgs = this.getAllOrganizations();
        StringBuilder codes = new StringBuilder();
        Iterator it = orgs.iterator();
        while (it.hasNext()) {
            Organization org;
            if (codes.length() > 0) {
                codes.append(",");
            }
            if ((org = (Organization)it.next()).getCode() == null) continue;
            codes.append(org.getCode());
        }
        return codes.toString();
    }

    public Integer getMainOrganizationId() {
        return this.getMainOrganization().getId();
    }

    public Integer[] getOrganizationIds() {
        Set orgs = this.getAllOrganizations();
        ArrayList<Integer> oidList = new ArrayList<Integer>();
        for (Organization org : orgs) {
            oidList.add(org.getId());
        }
        Integer[] orgIds = new Integer[oidList.size()];
        orgIds = oidList.toArray(orgIds);
        return orgIds;
    }

    public void setMainOrganization(Organization mainOrganization) {
        this.mainOrganization = mainOrganization;
    }

    public Organization getMainOrganization() {
        return this.mainOrganization;
    }

    public Set getLayers() {
        Set orgs = this.getAllOrganizations();
        HashSet layerSet = new HashSet();
        for (Organization org : orgs) {
            layerSet.addAll(org.getLayers());
        }
        if (layerSet.size() == 0) {
            return null;
        }
        return layerSet;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getPersonalURL(HttpServletRequest request) {
        return this.getPersonalURL(request, null);
    }

    public String getPersonalURL(HttpServletRequest request, String serviceProviderCode) {
        if (this.personalURL == null) {
            return null;
        }
        if (this.personalURL.startsWith("http")) {
            return this.personalURL;
        }
        StringBuffer baseUrl = CallWMSServlet.createBaseUrl((HttpServletRequest)request);
        baseUrl.append("/services/");
        if (serviceProviderCode != null && !serviceProviderCode.equals("")) {
            baseUrl.append(serviceProviderCode + "/");
        }
        baseUrl.append(this.personalURL);
        return baseUrl.toString();
    }

    public String getPersonalURL() {
        return this.personalURL;
    }

    public void setPersonalURL(String personalURL) {
        this.personalURL = personalURL;
    }

    public Date getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Date timeout) {
        this.timeout = timeout;
    }

    public String getDefaultGetMap() {
        return this.defaultGetMap;
    }

    public void setDefaultGetMap(String s) {
        this.defaultGetMap = s;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roles) {
        this.roles = roles;
    }

    public void addRole(Roles role) {
        if (this.roles == null) {
            this.roles = new HashSet();
        }
        this.roles.add(role);
    }

    public void deleteRole(Roles role) {
        if (this.roles != null) {
            this.roles.remove(role);
        }
    }

    public boolean checkRole(String role) {
        if (this.roles == null) {
            return false;
        }
        for (Roles theUserroles : this.roles) {
            if (!role.equalsIgnoreCase(theUserroles.getRole())) continue;
            return true;
        }
        return false;
    }

    public String getRolesAsString() {
        String rolesStr = "";
        for (Roles theUserroles : this.roles) {
            rolesStr = rolesStr + theUserroles.getRole() + " ";
        }
        return rolesStr;
    }

    public Set getIps() {
        return this.ips;
    }

    public void setIps(Set ips) {
        this.ips = ips;
    }

    public void addIps(String ip) {
        if (this.ips == null) {
            this.ips = new HashSet();
        }
        this.ips.add(ip);
    }

    public String getLastLoginStatus() {
        return this.lastLoginStatus;
    }

    public void setLastLoginStatus(String lastLoginStatus) {
        this.lastLoginStatus = lastLoginStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof User) || o == null) {
            return false;
        }
        User ouser = (User)o;
        if (this.username == null) {
            return false;
        }
        return this.username.equals(ouser.getUsername());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.username != null ? this.username.hashCode() : 0);
        return hash;
    }

    public static boolean isValidCode(String code) {
        if (code == null || code.length() != 32) {
            return false;
        }
        try {
            Hex.decodeHex((char[])code.toCharArray());
        }
        catch (DecoderException ex) {
            return false;
        }
        return true;
    }

    public static String createCode() {
        Random rd = new Random();
        StringBuilder toBeHashedString = new StringBuilder();
        toBeHashedString.append(new Date().toString());
        toBeHashedString.append(rd.nextLong());
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(toBeHashedString.toString().getBytes("UTF-8"));
            hash = md.digest();
        }
        catch (Exception ex) {
            log.info((Object)("Can not create hash (ignoring): " + ex.getLocalizedMessage()));
            hash = toBeHashedString.toString().getBytes();
        }
        return new String(Hex.encodeHex((byte[])hash));
    }
}

