/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.monitoring;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;

public class ClientRequest {
    private Integer id;
    private Date timestamp;
    private String clientRequestURI;
    private Set serviceProviderRequests;
    private Set requestOperations;
    private String clientIp;
    private String method;
    private Integer userId;
    private Integer organizationId;
    private String service;
    private String operation;
    private Class exceptionClass;
    private String exceptionMessage;
    public static final int MAX_LEN = 4000;

    public ClientRequest() {
        this.setTimestamp(new Date());
        this.setServiceProviderRequests(new HashSet());
        this.setRequestOperations(new HashSet());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Set getServiceProviderRequests() {
        return this.serviceProviderRequests;
    }

    public void setServiceProviderRequests(Set serviceProviderRequests) {
        this.serviceProviderRequests = serviceProviderRequests;
    }

    public String getClientRequestURI() {
        return this.clientRequestURI;
    }

    public void setClientRequestURI(String clientRequestURI) {
        if (clientRequestURI != null && clientRequestURI.length() > 4000) {
            clientRequestURI = clientRequestURI.substring(0, 4000);
        }
        this.clientRequestURI = clientRequestURI;
    }

    public Set getRequestOperations() {
        return this.requestOperations;
    }

    public void setRequestOperations(Set requestOperations) {
        this.requestOperations = requestOperations;
    }

    private Integer getUserId() {
        return this.userId;
    }

    private void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setUser(User user) {
        if (user != null) {
            this.setUserId(user.getId());
        } else {
            this.setUserId(null);
        }
    }

    public User getUser(EntityManager em) {
        try {
            return (User)em.find(User.class, (Object)this.getUserId());
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer getOrganizationId() {
        return this.organizationId;
    }

    private void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrganization(Organization organization) {
        if (organization != null) {
            this.setOrganizationId(organization.getId());
        } else {
            this.setOrganizationId(null);
        }
    }

    public Organization getOrganization(EntityManager em) {
        try {
            return (Organization)em.find(Organization.class, (Object)this.getOrganizationId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Class getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(Class exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }
}

