/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.core.webdav.MetadataResource;
import nl.b3p.kaartenbalie.core.webdav.MetadataResourceFactory;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.wms.capabilities.Layer;

public class MetadataFileResource
extends MetadataResource
implements GetableResource {
    protected Layer layer = null;

    public MetadataFileResource(Layer l) {
        this.init(l);
    }

    public MetadataFileResource(String layerCode) {
        try {
            this.init(this.getLayerByUniqueName(layerCode));
        }
        catch (Exception ex) {
            this.log.error((Object)("no layer found for metadata resource, cause: " + ex.getLocalizedMessage()));
        }
    }

    protected void init(Layer l) {
        if (l == null) {
            return;
        }
        this.layer = l;
        String uid = MetadataResourceFactory.createName((Layer)l);
        Date date = this.layer.getServiceProvider().getUpdatedDate();
        super.init(uid, date, new Date());
    }

    public void sendContent(OutputStream out, Range arg1, Map<String, String> arg2) throws IOException {
        if (this.layer == null || this.layer.getMetadata() == null) {
            throw new IOException("No metadata found!");
        }
        out.write(this.layer.getMetadata().getBytes("utf-8"));
    }

    public Long getMaxAgeSeconds() {
        return 60L;
    }

    public String getContentType(String arg0) {
        return "text/xml";
    }

    public Long getContentLength() {
        if (this.layer == null || this.layer.getMetadata() == null) {
            return new Long("0");
        }
        return new Long(this.layer.getMetadata().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (!super.authorise(request, method, auth)) {
            return false;
        }
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            this.log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            User lUser = (User)em.find(User.class, (Object)this.user.getId());
            Set orgs = lUser.getAllOrganizations();
            for (Organization org : orgs) {
                Set ll = org.getLayers();
                for (Layer l : ll) {
                    if (!l.equals(this.layer)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Error creating EntityManager: ", e);
        }
        finally {
            this.log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer getLayerByUniqueName(String uniqueName) throws Exception {
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            this.log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            String[] ln = OGCCommunication.toCodeAndName((String)uniqueName);
            String spAbbr = ln[0];
            String layerName = ln[1];
            String query = "from Layer where name = :layerName and serviceProvider.abbr = :spAbbr";
            List ll = em.createQuery(query).setParameter("layerName", (Object)layerName).setParameter("spAbbr", (Object)spAbbr).getResultList();
            if (ll == null || ll.isEmpty()) {
                Layer layer = null;
                return layer;
            }
            for (Layer l : ll) {
                String dbLayerName = l.getName();
                String dbSpAbbr = l.getSpAbbr();
                if (dbLayerName == null || dbSpAbbr == null || !dbLayerName.equals(layerName) || !dbSpAbbr.equals(spAbbr)) continue;
                Layer layer = l;
                return layer;
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Error creating EntityManager: ", e);
        }
        finally {
            this.log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
        return null;
    }
}

