/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class DirectoryParser {
    protected int fileId;

    public DirectoryParser() {
        this.reset();
    }

    public void reset() {
        this.fileId = 0;
    }

    public JSONArray parse2JSON(File directory) throws JSONException {
        return this.parse2JSON(directory, null);
    }

    public JSONArray parse2JSON(File directory, String[] filter) throws JSONException {
        if (directory == null) {
            return null;
        }
        JSONArray nodes = new JSONArray();
        if (directory.isDirectory() && directory.listFiles() != null) {
            File[] files = DirectoryParser.sortFiles((File[])directory.listFiles());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                ++this.fileId;
                if (file.isDirectory()) {
                    JSONObject folder = new JSONObject();
                    folder.put("id", (Object)Integer.toString(this.fileId));
                    folder.put("title", (Object)file.getName());
                    folder.put("children", (Object)this.parse2JSON(file, filter));
                    folder.put("isChild", false);
                    nodes.put((Object)folder);
                    continue;
                }
                if (!DirectoryParser.allowedFile((File)file, (String[])filter)) continue;
                JSONObject child = new JSONObject();
                child.put("id", (Object)Integer.toString(this.fileId));
                child.put("title", (Object)file.getName());
                child.put("path", (Object)file.getPath());
                child.put("isChild", true);
                nodes.put((Object)child);
            }
        }
        return nodes;
    }

    public List parse2List(File directory) {
        return this.parse2List(directory, null);
    }

    public List parse2List(File directory, String[] filter) {
        return this.parse2List(directory, filter, new ArrayList());
    }

    public List parse2List(File directory, String[] filter, List results) {
        if (directory == null || results == null) {
            return null;
        }
        if (!directory.isDirectory()) {
            return results;
        }
        File[] files = DirectoryParser.sortFiles((File[])directory.listFiles());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                results = this.parse2List(file, filter, results);
                continue;
            }
            if (!DirectoryParser.allowedFile((File)file, (String[])filter)) continue;
            results.add(file.getPath());
        }
        return results;
    }

    protected static File[] sortFiles(File[] files) {
        TreeMap<String, File> mapDirs = new TreeMap<String, File>();
        TreeMap<String, File> mapFiles = new TreeMap<String, File>();
        if (files == null || files.length < 1) {
            return new File[0];
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                mapDirs.put(file.getAbsolutePath(), file);
                continue;
            }
            mapFiles.put(file.getAbsolutePath(), file);
        }
        Iterator it = mapDirs.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            files[i++] = (File)mapDirs.get(key);
        }
        for (String key : mapFiles.keySet()) {
            files[i++] = (File)mapFiles.get(key);
        }
        return files;
    }

    public static boolean allowedFile(File file, String[] extensions) {
        if (extensions == null || extensions.length == 0) {
            return true;
        }
        String filename = file.getName();
        for (int i = 0; i < extensions.length; ++i) {
            String endFix = extensions[i];
            if (!filename.toLowerCase().endsWith(endFix.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

