/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class LayerTreeSupport {
    private static final Log log = LogFactory.getLog(LayerTreeSupport.class);

    public static boolean hasVisibility(Layer layer, Set organizationLayers) {
        if (layer == null || organizationLayers == null) {
            return false;
        }
        for (Layer organizationLayer : organizationLayers) {
            if (!layer.getId().equals(organizationLayer.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisibility(WfsLayer layer, Set organizationLayers) {
        if (layer == null || organizationLayers == null) {
            return false;
        }
        for (WfsLayer organizationLayer : organizationLayers) {
            if (layer.getId() != organizationLayer.getId()) continue;
            return true;
        }
        return false;
    }

    public static JSONObject createTreeList(Set layers, Set organizationLayers, JSONObject parent, boolean checkLayers) throws JSONException {
        Iterator layerIterator = layers.iterator();
        JSONArray parentArray = new JSONArray();
        while (layerIterator.hasNext()) {
            Layer layer = (Layer)layerIterator.next();
            boolean visible = LayerTreeSupport.hasVisibility((Layer)layer, (Set)organizationLayers);
            JSONObject layerObj = LayerTreeSupport.layerToJSON((Layer)layer, (boolean)visible);
            Set childLayers = layer.getLayers();
            if (childLayers != null && !childLayers.isEmpty()) {
                layerObj = LayerTreeSupport.createTreeList((Set)childLayers, (Set)organizationLayers, (JSONObject)layerObj, (boolean)checkLayers);
            }
            if (checkLayers && !visible && !layerObj.has("children")) continue;
            parentArray.put((Object)layerObj);
        }
        if (parentArray.length() > 0) {
            parent.put("children", (Object)parentArray);
        }
        return parent;
    }

    public static JSONObject createWfsTreeList(Set layers, Set organizationLayers, JSONObject parent, boolean checkLayers) throws JSONException {
        Iterator layerIterator = layers.iterator();
        JSONArray parentArray = new JSONArray();
        while (layerIterator.hasNext()) {
            WfsLayer layer = (WfsLayer)layerIterator.next();
            boolean visible = LayerTreeSupport.hasVisibility((WfsLayer)layer, (Set)organizationLayers);
            JSONObject layerObj = LayerTreeSupport.layerToJSON((WfsLayer)layer, (boolean)visible);
            if (checkLayers && !visible) continue;
            parentArray.put((Object)layerObj);
        }
        if (parentArray.length() > 0) {
            parent.put("children", (Object)parentArray);
        }
        LayerTreeSupport.alphabetizeWfsRightsTree((JSONObject)parent);
        return parent;
    }

    private static void alphabetizeWfsRightsTree(JSONObject treeObject) throws JSONException {
        if (!treeObject.isNull("children")) {
            JSONArray childArray = treeObject.getJSONArray("children");
            TreeMap<String, JSONObject> tm = new TreeMap<String, JSONObject>();
            for (int i = 0; i < childArray.length(); ++i) {
                JSONObject childObject = childArray.getJSONObject(i);
                LayerTreeSupport.alphabetizeWfsRightsTree((JSONObject)childObject);
                String title = childObject.getString("name");
                tm.put(title, childObject);
            }
            Collection c = tm.values();
            treeObject.put("children", c);
        }
    }

    public static JSONObject serviceProviderToJSON(WfsServiceProvider serviceProvider) throws JSONException {
        JSONObject root = new JSONObject();
        root.put("id", (Object)("wfs" + serviceProvider.getId()));
        root.put("name", (Object)serviceProvider.getGivenName());
        root.put("type", (Object)"serviceprovider");
        return root;
    }

    public static JSONObject serviceProviderToJSON(ServiceProvider serviceProvider) throws JSONException {
        JSONObject root = new JSONObject();
        root.put("id", (Object)("wms" + serviceProvider.getId()));
        root.put("name", (Object)serviceProvider.getGivenName());
        root.put("type", (Object)"serviceprovider");
        return root;
    }

    private static JSONObject layerToJSON(WfsLayer layer, boolean visible) throws JSONException {
        JSONObject jsonLayer = new JSONObject();
        jsonLayer.put("name", (Object)layer.getTitle());
        String name = layer.getUniqueName();
        if (name == null) {
            String title = layer.getTitle();
            jsonLayer.put("id", (Object)MyEMFDatabase.uniqueName((String)title, null));
            jsonLayer.put("title", (Object)title);
            jsonLayer.put("type", (Object)"placeholder");
        } else {
            jsonLayer.put("id", (Object)name);
            jsonLayer.put("type", (Object)"layer");
            if (visible) {
                jsonLayer.put("visible", (Object)"true");
            } else {
                jsonLayer.put("visible", (Object)"false");
            }
        }
        return jsonLayer;
    }

    private static JSONObject layerToJSON(Layer layer, boolean visible) throws JSONException {
        JSONObject jsonLayer = new JSONObject();
        jsonLayer.put("name", (Object)layer.getTitle());
        String name = layer.getUniqueName();
        if (name == null) {
            String title = layer.getCompleteTitle();
            jsonLayer.put("id", (Object)MyEMFDatabase.uniqueName((String)title, null));
            jsonLayer.put("title", (Object)title);
            jsonLayer.put("type", (Object)"placeholder");
        } else {
            jsonLayer.put("id", (Object)name);
            jsonLayer.put("type", (Object)"layer");
            if (visible) {
                jsonLayer.put("visible", (Object)"true");
            } else {
                jsonLayer.put("visible", (Object)"false");
            }
        }
        return jsonLayer;
    }

    public static Layer getLayerByUniqueName(EntityManager em, String uniqueName) throws Exception {
        String[] ln = OGCCommunication.toCodeAndName((String)uniqueName);
        String spAbbr = ln[0];
        String layerName = ln[1];
        String query = "from Layer where name = :layerName and serviceProvider.abbr = :spAbbr";
        List ll = em.createQuery(query).setParameter("layerName", (Object)layerName).setParameter("spAbbr", (Object)spAbbr).getResultList();
        if (ll == null || ll.isEmpty()) {
            return null;
        }
        for (Layer l : ll) {
            String dbLayerName = l.getName();
            String dbSpAbbr = l.getSpAbbr();
            if (dbLayerName == null || dbSpAbbr == null || !dbLayerName.equals(layerName) || !dbSpAbbr.equals(spAbbr)) continue;
            return l;
        }
        return null;
    }

    public static WfsLayer getWfsLayerByUniqueName(EntityManager em, String uniqueName) throws Exception {
        String[] ln = OGCCommunication.toCodeAndName((String)uniqueName);
        String spAbbr = ln[0];
        String layerName = ln[1];
        String query = "from WfsLayer where name = :layerName and wfsServiceProvider.abbr = :spAbbr";
        List ll = em.createQuery(query).setParameter("layerName", (Object)layerName).setParameter("spAbbr", (Object)spAbbr).getResultList();
        if (ll == null || ll.isEmpty()) {
            return null;
        }
        return (WfsLayer)ll.get(0);
    }

    public static JSONObject createTree(EntityManager em, String rootName, Set organizationLayers, boolean checkLayers) throws Exception {
        JSONObject root = new JSONObject();
        root.put("name", (Object)rootName);
        root.put("id", (Object)("wms" + rootName));
        List serviceProviders = em.createQuery("from ServiceProvider sp order by sp.abbr").getResultList();
        JSONArray rootArray = new JSONArray();
        for (ServiceProvider sp : serviceProviders) {
            JSONObject parentObj = LayerTreeSupport.serviceProviderToJSON((ServiceProvider)sp);
            HashSet<Layer> set = new HashSet<Layer>();
            Layer topLayer = sp.getTopLayer();
            if (topLayer != null) {
                set.add(topLayer);
                if (!(parentObj = LayerTreeSupport.createTreeList(set, (Set)organizationLayers, (JSONObject)parentObj, (boolean)checkLayers)).has("children")) continue;
                rootArray.put((Object)parentObj);
                continue;
            }
            String name = sp.getGivenName();
            if (name == null) {
                name = "onbekend";
            }
            log.debug((Object)("Toplayer is null voor serviceprovider: " + name));
        }
        root.put("children", (Object)rootArray);
        return root;
    }

    public static JSONObject createWfsTree(EntityManager em, String rootName, Set organizationLayers, boolean checkLayers) throws Exception {
        JSONObject root = new JSONObject();
        root.put("name", (Object)rootName);
        root.put("id", (Object)("wfs" + rootName));
        List serviceProviders = em.createQuery("from WfsServiceProvider sp order by sp.abbr").getResultList();
        JSONArray rootArray = new JSONArray();
        for (WfsServiceProvider sp : serviceProviders) {
            JSONObject parentObj = LayerTreeSupport.serviceProviderToJSON((WfsServiceProvider)sp);
            HashSet set = new HashSet();
            Set layers = sp.getWfsLayers();
            set.addAll(layers);
            if (!(parentObj = LayerTreeSupport.createWfsTreeList(set, (Set)organizationLayers, (JSONObject)parentObj, (boolean)checkLayers)).has("children")) continue;
            rootArray.put((Object)parentObj);
        }
        root.put("children", (Object)rootArray);
        return root;
    }
}

