/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.GroupParser;
import nl.b3p.kaartenbalie.service.WMSParser;
import nl.b3p.kaartenbalie.struts.ServerAction;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.LayerDomainResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorForm;

public abstract class WmsWfsParser
extends ServerAction {
    protected static final Log log = LogFactory.getLog(WMSParser.class);
    public static final String OK = "OK";
    public static final String SAVE_ERRORKEY = "Error_saving";
    public static final String ERROR_DELETE_OLD_PROVIDER = "Error_deleting_old_provider";
    protected Exception exception;
    public static final String ERROR_INVALID_URL = "Not a WMS URL";
    public static final String SERVICE_STATUS_ERROR = "FOUT";
    public static final String SERVICE_STATUS_OK = "GOED";
    public static final String SERVER_CONNECTION_ERROR = "error.serverconnection";
    public static final String MALFORMED_CAPABILITY_ERROR = "error.malformedcapability";
    public static final String UNSUPPORTED_WMSVERSION_ERROR = "error.wmsversion";
    public static final String UPLOADFILE_SIZE_ERRORKEY = "Het bestand is niet opgeslagen, omdat deze te groot is.";
    public static final String UPLOADFILE_FORMAT_ERRORKEY = "Het bestand is niet opgeslagen, omdat deze niet van het type .jpg .png of .sld is.";
    public static final String UPLOADFILE_EXISTS_ERRORKEY = "Het bestand is niet opgeslagen, omdat het reeds bestaat.";
    protected ArrayList<String> parseMessages = new ArrayList();
    protected GroupParser groupParser = new GroupParser();

    public abstract String saveProvider(HttpServletRequest var1, DynaValidatorForm var2) throws Exception;

    public abstract int test(DynaValidatorForm var1) throws Exception;

    public abstract int batchUpdate(DynaValidatorForm var1) throws Exception;

    public abstract int batchUpdate(DynaValidatorForm var1, String var2) throws Exception;

    public abstract String deleteConfirm(DynaValidatorForm var1, HttpServletRequest var2) throws Exception;

    public abstract String delete(DynaValidatorForm var1, HttpServletRequest var2) throws Exception;

    protected Layer checkLayer(Layer orgLayer, Set layers) {
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        for (Layer layer : layers) {
            if (orgLayer.getName() == null && layer.getName() == null && orgLayer.getTitle().equalsIgnoreCase(layer.getTitle())) {
                return layer;
            }
            if (orgLayer.getName() != null && layer.getName() != null && orgLayer.getName().equalsIgnoreCase(layer.getName())) {
                return layer;
            }
            Layer foundLayer = this.checkLayer(orgLayer, layer.getLayers());
            if (foundLayer == null) continue;
            return foundLayer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadFile(FormFile thisFile, Boolean overwrite, String abbreviation) throws Exception {
        String[] allowed_files = MyEMFDatabase.getAllowedUploadFiles();
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.addAll(Arrays.asList(allowed_files));
        String sep = File.separator;
        int fileSize = thisFile.getFileSize();
        if (fileSize > 0x100000) {
            return UPLOADFILE_SIZE_ERRORKEY;
        }
        String fileName = thisFile.getFileName();
        int point = fileName.indexOf(".");
        String extention = fileName.substring(point);
        if (fileName == null || !allowed.contains(extention.toLowerCase())) {
            return UPLOADFILE_FORMAT_ERRORKEY;
        }
        String uploaddir = MyEMFDatabase.getUpload() + sep + abbreviation;
        File dir = new File(uploaddir);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        File targetFile = new File(uploaddir, fileName);
        boolean exists = targetFile.exists();
        boolean doOverwrite = false;
        if (overwrite != null && overwrite.booleanValue()) {
            doOverwrite = true;
        }
        if (exists && !doOverwrite) {
            return UPLOADFILE_EXISTS_ERRORKEY;
        }
        InputStream stream = null;
        try {
            stream = thisFile.getInputStream();
            FileOutputStream bos = null;
            try {
                bos = new FileOutputStream(targetFile);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)bos).write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (bos != null) {
                    ((OutputStream)bos).close();
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return OK;
    }

    protected void setMetadataFromLayerSource(Layer layer, Layer oldLayer, B3PCredentials credentials) {
        String mdUrl = null;
        Set ldrs = layer.getDomainResource();
        if (ldrs != null && !ldrs.isEmpty()) {
            LayerDomainResource ldr2 = null;
            for (LayerDomainResource ldr2 : ldrs) {
                if (!"MetadataURL".equalsIgnoreCase(ldr2.getDomain())) continue;
                mdUrl = ldr2.getUrl();
                break;
            }
        }
        if (mdUrl == null || mdUrl.length() == 0) {
            return;
        }
        String newMetadata = null;
        try {
            newMetadata = this.collectMetadata(mdUrl, credentials);
        }
        catch (Exception ldri) {
            // empty catch block
        }
        String currentMetadata = null;
        if (oldLayer != null) {
            currentMetadata = oldLayer.getMetadata();
        }
        layer.setMetadata(this.convertMetadata(newMetadata, currentMetadata));
    }

    private String convertMetadata(String newMetadata, String currentMetadata) {
        if (currentMetadata != null && currentMetadata.length() > 0) {
            return currentMetadata;
        }
        return newMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String collectMetadata(String url, B3PCredentials credentials) throws IOException, Exception {
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpGet request = new HttpGet(url);
        HttpResponse response = null;
        try {
            String metadata;
            response = hcc.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error((Object)("Error connecting to server. Status code: " + statusCode));
                throw new Exception("Error connecting to server. Status code: " + statusCode);
            }
            String string = metadata = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
    }

    protected Integer getInt(DynaValidatorForm dynaForm, String field) {
        return FormUtils.StringToInteger((String)dynaForm.getString(field));
    }

    public Exception getException() {
        return this.exception;
    }

    public ArrayList<String> getMessages() {
        return this.parseMessages;
    }

    public abstract boolean abbrExists(String var1, EntityManager var2);

    public abstract void addAllowedService(String var1, EntityManager var2) throws Exception;

    public abstract void deleteAllowedService(String var1, EntityManager var2) throws Exception;

    public abstract void deleteAllAllowedServices(EntityManager var1);
}

