/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.ogc.utils.KBCrypter;
import nl.b3p.wms.capabilities.Roles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.securityfilter.filter.SecurityRequestWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserAction
extends KaartenbalieCrudAction {
    private static final Log log = LogFactory.getLog(UserAction.class);
    protected static final String NON_UNIQUE_USERNAME_ERROR_KEY = "error.nonuniqueusername";
    protected static final String USER_NOTFOUND_ERROR_KEY = "error.usernotfound";
    protected static final String NONMATCHING_PASSWORDS_ERROR_KEY = "error.passwordmatch";
    protected static final String NO_PASSWORDS_ERROR_KEY = "error.nopassword";
    protected static final String DELETE_ADMIN_ERROR_KEY = "error.deleteadmin";
    protected static final String DATE_PARSE_ERROR_KEY = "error.dateparse";
    protected static final String DATE_INPUT_ERROR_KEY = "error.dateinput";
    protected static final String CAPABILITY_WARNING_KEY = "warning.saveorganization";
    protected static final String LAST_JOINED_KEY = "beheer.user.last.joined";
    protected static final String NOROLES_WARNING_KEY = "warning.noroles";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = this.getUser(dynaForm, request, false);
        if (user == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.usernotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateUserForm(user, dynaForm, request);
        this.createLists(dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward cancel(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.createLists(dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = this.getUser(dynaForm, request, false);
        if (user == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.usernotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateUserForm(user, dynaForm, request);
        this.createLists(dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer[] roleSelected;
        int size;
        User user = this.getUser(dynaForm, request, true);
        ActionForward af = this.saveCheck(user, mapping, dynaForm, request);
        if (af != null) {
            return af;
        }
        Organization org = user.getMainOrganization();
        if (org != null && !org.getHasValidGetCapabilities()) {
            this.addAlternateMessage(mapping, request, "warning.saveorganization");
        }
        if ((size = (roleSelected = (Integer[])dynaForm.get("roleSelected")).length) < 1) {
            this.addAlternateMessage(mapping, request, "warning.noroles");
        }
        this.populateUserObject(user, dynaForm, request);
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        if (user.getId() == null) {
            em.persist((Object)user);
        } else {
            em.merge((Object)user);
        }
        em.flush();
        this.updatePrincipal(request, user);
        this.populateUserForm(user, dynaForm, request);
        this.createLists(dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward saveCheck(User user, ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        if (user == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        try {
            User dbUser = (User)em.createQuery("from User u where lower(u.username) = lower(:username) ").setParameter("username", (Object)FormUtils.nullIfEmpty((String)dynaForm.getString("username"))).getSingleResult();
            if (dbUser != null && dbUser.getId() != user.getId()) {
                this.prepareMethod(dynaForm, request, "edit", "list");
                this.addAlternateMessage(mapping, request, "error.nonuniqueusername");
                return this.getAlternateForward(mapping, request);
            }
        }
        catch (NoResultException dbUser) {
            // empty catch block
        }
        String password = FormUtils.nullIfEmpty((String)dynaForm.getString("password"));
        String repeatpassword = FormUtils.nullIfEmpty((String)dynaForm.getString("repeatpassword"));
        if (user.getId() == null && password == null) {
            this.prepareMethod(dynaForm, request, "edit", "edit");
            this.addAlternateMessage(mapping, request, "error.nopassword");
            return this.getAlternateForward(mapping, request);
        }
        if (!(password == null && repeatpassword == null || password != null && password.equals(repeatpassword))) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.passwordmatch");
            return this.getAlternateForward(mapping, request);
        }
        Date oldDate = user.getTimeout();
        Date newDate = FormUtils.FormStringToDate((String)dynaForm.getString("timeout"), (Locale)request.getLocale());
        if (newDate == null && oldDate != null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.dateparse");
            return this.getAlternateForward(mapping, request);
        }
        return null;
    }

    public ActionForward deleteConfirm(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        User user = this.getUser(dynaForm, request, false);
        if (user == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        User sessionUser = (User)request.getUserPrincipal();
        if (sessionUser.getId().equals(user.getId())) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.deleteadmin");
            return this.getAlternateForward(mapping, request);
        }
        MessageResources messages = this.getResources(request);
        Locale locale = this.getLocale(request);
        String lastJoinedMessage = messages.getMessage(locale, "beheer.user.last.joined");
        Organization org = user.getMainOrganization();
        Set userList = null;
        if (org != null) {
            userList = org.getUsers();
        }
        if (userList == null || userList.size() <= 1) {
            this.addAlternateMessage(mapping, request, null, lastJoinedMessage);
        }
        this.prepareMethod(dynaForm, request, "delete", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        User user = this.getUser(dynaForm, request, false);
        if (user == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        User sessionUser = (User)request.getUserPrincipal();
        if (sessionUser.getId().equals(user.getId())) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.deleteadmin");
            return this.getAlternateForward(mapping, request);
        }
        if (user.getMainOrganization() == null) {
            user.setMainOrganization(sessionUser.getMainOrganization());
            em.merge((Object)user);
            em.flush();
        }
        em.remove((Object)user);
        em.flush();
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        super.createLists(form, request);
        List userList = em.createQuery("from User order by username").getResultList();
        request.setAttribute("userlist", (Object)userList);
        Date now = new Date();
        List invalidUsers = em.createQuery("from User where timeout < :date").setParameter("date", (Object)now).getResultList();
        ArrayList<Integer> invalidUserIds = new ArrayList<Integer>();
        for (User u : invalidUsers) {
            invalidUserIds.add(u.getId());
        }
        request.setAttribute("invalidUserIds", invalidUserIds);
        List organizationlist = em.createQuery("from Organization order by name").getResultList();
        request.setAttribute("organizationlist", (Object)organizationlist);
        List roles = em.createQuery("from Roles order by id").getResultList();
        request.setAttribute("userrolelist", (Object)roles);
    }

    protected Integer getID(DynaValidatorForm dynaForm) {
        return FormUtils.StringToInteger((String)dynaForm.getString("id"));
    }

    protected User getUser(DynaValidatorForm dynaForm, HttpServletRequest request, boolean createNew) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        User sessUser = (User)request.getUserPrincipal();
        if (!request.isUserInRole("beheerder") && !createNew) {
            if (sessUser == null) {
                return null;
            }
            return (User)em.createQuery("from User u where u.id = :id").setParameter("id", (Object)sessUser.getId()).getSingleResult();
        }
        User user = null;
        Integer id = this.getID(dynaForm);
        if (null == id && createNew) {
            user = new User();
        } else if (null != id) {
            user = (User)em.find(User.class, (Object)new Integer(id));
        }
        if (user == null) {
            return sessUser;
        }
        return user;
    }

    protected boolean updatePrincipal(HttpServletRequest request, User user) {
        User sessUser = (User)request.getUserPrincipal();
        if (!sessUser.equals((Object)user)) {
            return false;
        }
        if (request instanceof SecurityRequestWrapper) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            srw.setUserPrincipal((Principal)user);
            return true;
        }
        return false;
    }

    private Organization getOrganization(Integer id) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        return (Organization)em.find(Organization.class, (Object)id);
    }

    protected void populateUserForm(User user, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        dynaForm.set("id", (Object)FormUtils.IntegerToString((Integer)user.getId()));
        dynaForm.set("firstname", (Object)user.getFirstName());
        dynaForm.set("surname", (Object)user.getSurname());
        dynaForm.set("emailAddress", (Object)user.getEmailAddress());
        dynaForm.set("username", (Object)user.getUsername());
        dynaForm.set("personalURL", (Object)user.getPersonalURL(request));
        dynaForm.set("currentAddress", (Object)request.getRemoteAddr());
        dynaForm.set("password", (Object)"");
        dynaForm.set("repeatpassword", (Object)"");
        Integer[] roleSelected = null;
        Set uroles = user.getRoles();
        if (uroles != null && !uroles.isEmpty()) {
            ArrayList roleSet = new ArrayList(uroles);
            roleSelected = new Integer[roleSet.size()];
            for (int i = 0; i < roleSet.size(); ++i) {
                Roles role = (Roles)roleSet.get(i);
                roleSelected[i] = role.getId();
            }
        }
        dynaForm.set("roleSelected", roleSelected);
        String[] orgSelected = null;
        Set orgs = user.getAllOrganizations();
        ArrayList orgSet = new ArrayList(orgs);
        Organization mainOrg = user.getMainOrganization();
        orgSelected = new String[orgSet.size()];
        for (int i = 0; i < orgSet.size(); ++i) {
            Organization org = (Organization)orgSet.get(i);
            orgSelected[i] = FormUtils.IntegerToString((Integer)org.getId());
        }
        if (orgSelected.length > 0) {
            dynaForm.set("orgSelected", (Object)orgSelected);
        }
        if (mainOrg != null) {
            dynaForm.set("mainOrganization", (Object)FormUtils.IntegerToString((Integer)mainOrg.getId()));
        }
        StringBuilder registeredIP = new StringBuilder();
        Set userips = user.getIps();
        if (userips != null && !userips.isEmpty()) {
            for (String ipaddress : userips) {
                if (registeredIP.length() > 0) {
                    registeredIP.append(",");
                }
                registeredIP.append(ipaddress);
            }
        } else {
            registeredIP.append(request.getRemoteAddr());
        }
        dynaForm.set("registeredIP", (Object)registeredIP.toString());
        Date timeout = user.getTimeout();
        if (timeout == null) {
            timeout = this.getDefaultTimeOut(3);
        }
        dynaForm.set("timeout", (Object)FormUtils.DateToFormString((Date)timeout, (Locale)request.getLocale()));
        if (mainOrg == null) {
            dynaForm.set("organizationName", (Object)"");
            dynaForm.set("organizationTelephone", (Object)"");
        } else {
            dynaForm.set("organizationName", (Object)mainOrg.getName());
            dynaForm.set("organizationTelephone", (Object)mainOrg.getTelephone());
        }
    }

    protected void populateUserObject(User user, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = UserAction.getEntityManager();
        user.setFirstName(FormUtils.nullIfEmpty((String)dynaForm.getString("firstname")));
        user.setSurname(FormUtils.nullIfEmpty((String)dynaForm.getString("surname")));
        user.setEmailAddress(FormUtils.nullIfEmpty((String)dynaForm.getString("emailAddress")));
        user.setUsername(FormUtils.nullIfEmpty((String)dynaForm.getString("username")));
        String password = FormUtils.nullIfEmpty((String)dynaForm.getString("password"));
        String repeatpassword = FormUtils.nullIfEmpty((String)dynaForm.getString("repeatpassword"));
        if (password != null && repeatpassword != null) {
            if (password.equals(repeatpassword)) {
                String encpw = KBCrypter.encryptText((String)FormUtils.nullIfEmpty((String)dynaForm.getString("password")));
                user.setPassword(encpw);
            } else {
                throw new Exception("New passwords do not match!");
            }
        }
        String mainOrgId = dynaForm.getString("mainOrganization");
        String[] orgSelected = dynaForm.getStrings("orgSelected");
        HashSet<String> orgSelectedSet = new HashSet<String>();
        for (int i = 0; i < orgSelected.length; ++i) {
            orgSelectedSet.add(orgSelected[i]);
        }
        if (!orgSelectedSet.contains(mainOrgId)) {
            orgSelectedSet.add(mainOrgId);
        }
        user.setOrganizations(new HashSet());
        List orgList = em.createQuery("from Organization").getResultList();
        for (String orgId : orgSelectedSet) {
            for (Organization org : orgList) {
                if (!org.getId().toString().equals(orgId)) continue;
                user.addOrganization(org);
                if (!org.getId().toString().equals(mainOrgId)) continue;
                user.setMainOrganization(org);
            }
        }
        Integer[] rolesSelected = (Integer[])dynaForm.get("roleSelected");
        if (rolesSelected != null && rolesSelected.length == 0) {
            user.getRoles().clear();
        }
        if (rolesSelected != null && rolesSelected.length > 0 && rolesSelected[0] != -1) {
            List newRoles = em.createQuery("from Roles where id in (:ids)").setParameter("ids", Arrays.asList(rolesSelected)).getResultList();
            user.getRoles().retainAll(newRoles);
            user.getRoles().addAll(newRoles);
        }
        String regip = dynaForm.getString("registeredIP");
        HashSet<String> newset = new HashSet<String>();
        if (regip.length() > 0) {
            String[] registeredIP = regip.split(",");
            int ipsize = registeredIP.length;
            for (int i = 0; i < ipsize; ++i) {
                if (registeredIP[i] == null || registeredIP[i].length() <= 0) continue;
                newset.add(registeredIP[i]);
            }
        }
        user.setIps(this.compareSets(user.getIps(), newset));
        this.setPersonalUrlandTimeout(user, dynaForm, request);
    }

    protected void setPersonalUrlandTimeout(User user, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Date oldDate = user.getTimeout();
        Date newDate = FormUtils.FormStringToDate((String)dynaForm.getString("timeout"), (Locale)request.getLocale());
        if (newDate == null) {
            newDate = this.getDefaultTimeOut(120);
        }
        boolean urlNeedsRefresh = true;
        String persURL = user.getPersonalURL();
        if (persURL != null && persURL.length() > 0 && oldDate != null) {
            urlNeedsRefresh = false;
            if (oldDate.before(newDate)) {
                urlNeedsRefresh = true;
            } else if (persURL.startsWith("http")) {
                urlNeedsRefresh = true;
            }
        }
        if (!urlNeedsRefresh) {
            return;
        }
        user.setPersonalURL(User.createCode());
        user.setTimeout(newDate);
        user.setLastLoginStatus(null);
    }

    public Set compareSets(Set oldset, Set newset) {
        if (oldset == null) {
            oldset = new HashSet<String>();
        }
        HashSet<String> tempRemoveSet = new HashSet<String>();
        Iterator it = oldset.iterator();
        while (newset != null && it.hasNext()) {
            String userip = (String)it.next();
            if (newset.contains(userip)) continue;
            tempRemoveSet.add(userip);
        }
        for (String removableIP : tempRemoveSet) {
            oldset.remove(removableIP);
        }
        for (String userip : newset) {
            if (oldset.contains(userip)) continue;
            oldset.add(userip);
        }
        return oldset;
    }

    public Date getDefaultTimeOut(int months) {
        GregorianCalendar gc = new GregorianCalendar();
        ((Calendar)gc).add(2, months);
        return gc.getTime();
    }
}

