/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import nl.b3p.kaartenbalie.core.server.persistence.BaseDAO;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WFSProviderDAO
extends BaseDAO {
    private static final Log log = LogFactory.getLog(WFSProviderDAO.class);

    public WFSProviderDAO() {
        try {
            this.em = MyEMFDatabase.getEntityManager((String)"mainEM");
        }
        catch (Exception e) {
            log.error((Object)"WfsProviderDao initialization failed.");
        }
    }

    public WFSProviderDAO(EntityManager em) {
        this.em = em;
    }

    public String[] getAuthorizedFeatureTypeNames(Integer[] orgIds, String version, boolean isAdmin) throws Exception {
        Query q;
        String query;
        List spLayers = null;
        if (!isAdmin) {
            query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true',sp) from Organization o join o.wfsLayers l join l.wfsServiceProvider sp where o.id in (:orgIds)";
            if (version != null) {
                query = query + " and sp.wfsVersion = :version";
            }
            q = this.em.createQuery(query);
            q.setParameter("orgIds", Arrays.asList(orgIds));
            if (version != null) {
                q.setParameter("version", (Object)version);
            }
            spLayers = q.getResultList();
        } else {
            query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true',sp) from WfsLayer l join l.wfsServiceProvider sp";
            if (version != null) {
                query = query + " where sp.wfsVersion = :version";
            }
            q = this.em.createQuery(query);
            if (version != null) {
                q.setParameter("version", (Object)version);
            }
            spLayers = q.getResultList();
        }
        ArrayList<String> layers = new ArrayList<String>();
        for (SpLayerSummary spls : spLayers) {
            String ln = OGCCommunication.attachSp((String)spls.getSpAbbr(), (String)spls.getLayerName());
            layers.add(ln);
        }
        return layers.toArray(new String[0]);
    }

    public SpLayerSummary getAuthorizedFeatureTypeSummary(String layer, Integer[] orgIds, boolean b3pLayering) throws Exception {
        String query = "select distinct new nl.b3p.ogc.utils.SpLayerSummary(l, 'true') from WfsLayer l, Organization o, WfsServiceProvider sp join o.wfsLayers ol where l = ol and l.wfsServiceProvider = sp and o.id in (:orgIds) and l.name = :layerName and sp.abbr = :layerCode";
        return this.getValidLayerObjects(query, layer, orgIds, b3pLayering);
    }

    protected SpLayerSummary getValidLayerObjects(String query, String layer, Integer[] orgIds, boolean b3pLayering) throws Exception {
        String[] layerCodeAndName = OGCCommunication.toCodeAndName((String)layer);
        String layerCode = layerCodeAndName[0];
        String layerName = layerCodeAndName[1];
        log.debug((Object)("Collect layer info for layer: " + layerName + " and service provider: " + layerCode));
        if (b3pLayering) {
            if (layerCode.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
                SpLayerSummary layerInfo = new SpLayerSummary(new Integer(-1), new Integer(-1), layerName, KBConfiguration.SERVICEPROVIDER_BASE_HTTP, KBConfiguration.SERVICEPROVIDER_BASE_ABBR, null, null);
                return layerInfo;
            }
            return null;
        }
        if (layerCode.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
            return null;
        }
        List result = this.em.createQuery(query).setParameter("orgIds", Arrays.asList(orgIds)).setParameter("layerName", (Object)layerName).setParameter("layerCode", (Object)layerCode).getResultList();
        if (result == null || result.isEmpty()) {
            log.error((Object)("layer not valid or no rights, name: " + layer));
            throw new Exception(KBConfiguration.REQUEST_NORIGHTS_EXCEPTION + ": " + layer);
        }
        if (result.size() > 1) {
            log.error((Object)("layers with duplicate names, name: " + layer));
            throw new Exception(KBConfiguration.REQUEST_DUPLICATE_EXCEPTION + ": " + layer);
        }
        return (SpLayerSummary)result.get(0);
    }
}

