/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroupParser
extends KaartenbalieCrudAction {
    protected static final Log log = LogFactory.getLog(GroupParser.class);
    private EntityManager em;

    public GroupParser() {
        try {
            this.em = GroupParser.getEntityManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Organization> getGroups() {
        List groups = this.em.createQuery("from Organization order by id asc").getResultList();
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGroupsAsXML(HttpServletResponse response, OutputStream sos) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        try {
            List groups = this.getGroups();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("Organizations");
            doc.appendChild(rootElement);
            for (Organization org : groups) {
                rootElement.appendChild(this.toXml(doc, org));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            response.setContentType("text/xml");
            transformer.transform(source, new StreamResult(sos));
        }
        catch (Exception ex) {
            log.error((Object)"Error creating XML-document", (Throwable)ex);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter pw = new PrintWriter(sos);
            pw.write(ex.getMessage());
        }
        finally {
            sos.close();
        }
    }

    public Element toXml(Document doc, Organization org) {
        Element orgNode = doc.createElement("organization");
        if (org.getId() != null) {
            orgNode.setAttribute("id", org.getId().toString());
        }
        orgNode.setAttribute("name", org.getName());
        orgNode.setAttribute("code", org.getCode());
        return orgNode;
    }

    public static void addRightsForAllLayers(String[] orgSelected, WfsServiceProvider sp, EntityManager em) throws Exception {
        if (orgSelected == null || sp == null) {
            return;
        }
        for (int i = 0; i < orgSelected.length; ++i) {
            Organization org = (Organization)em.find(Organization.class, (Object)new Integer(orgSelected[i]));
            GroupParser.addAllLayersToGroup((Organization)org, (WfsServiceProvider)sp, (EntityManager)em);
        }
    }

    public static void addRightsForAllLayers(String[] orgSelected, ServiceProvider sp, EntityManager em) throws Exception {
        if (orgSelected == null || sp == null) {
            return;
        }
        for (int i = 0; i < orgSelected.length; ++i) {
            Organization org = (Organization)em.find(Organization.class, (Object)new Integer(orgSelected[i]));
            GroupParser.addAllLayersToGroup((Organization)org, (ServiceProvider)sp, (EntityManager)em);
        }
    }

    public static void addAllLayersToGroup(Organization org, WfsServiceProvider sp, EntityManager em) throws Exception {
        log.info((Object)("Updating WFS rights for :" + org.getName()));
        HashSet<WfsLayer> wfsLayers = new HashSet<WfsLayer>();
        Set orgWfsLayerSet = org.getWfsLayers();
        for (WfsLayer l : orgWfsLayerSet) {
            WfsServiceProvider layerSp = l.getWfsServiceProvider();
            if (layerSp.getAbbr().equals(sp.getAbbr())) continue;
            wfsLayers.add(l);
            log.info((Object)("Org wfs layer :" + l.getName()));
        }
        Set selectedLayers = sp.getWfsLayers();
        for (WfsLayer l : selectedLayers) {
            wfsLayers.add(l);
            log.info((Object)("Wfs layer :" + l.getName()));
        }
        org.setWfsLayers(wfsLayers);
        em.merge((Object)org);
        em.flush();
    }

    public static void addAllLayersToGroup(Organization org, ServiceProvider sp, EntityManager em) throws Exception {
        HashSet<Layer> wmsLayers = new HashSet<Layer>();
        Set orgWmsLayerSet = org.getLayers();
        for (Layer l : orgWmsLayerSet) {
            ServiceProvider layerSp = l.getServiceProvider();
            if (layerSp.getAbbr().equals(sp.getAbbr())) continue;
            wmsLayers.add(l);
        }
        Set selectedLayers = sp.getAllLayers();
        for (Layer l : selectedLayers) {
            wmsLayers.add(l);
        }
        org.setLayers(wmsLayers);
        em.merge((Object)org);
        em.flush();
    }
}

