/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.accounting;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.NoResultException;
import nl.b3p.kaartenbalie.core.server.accounting.LayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.LayerNotAvailableException;
import nl.b3p.kaartenbalie.core.server.accounting.NoPrizingException;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtLayerCalculator
extends LayerCalculator {
    private static final Log log = LogFactory.getLog(ExtLayerCalculator.class);

    public ExtLayerCalculator() throws Exception {
        this.identity = MyEMFDatabase.createEntityManager((String)"mainEM");
        log.debug((Object)"Getting entity manager ......");
        this.em = MyEMFDatabase.getEntityManager((String)"mainEM");
    }

    protected Layer getWMSLayer(String spAbbr, String layerName) {
        ServiceProvider prov = (ServiceProvider)this.em.createQuery("FROM ServiceProvider sp WHERE sp.abbr = :serverProviderPrefix").setParameter("serverProviderPrefix", (Object)spAbbr).getSingleResult();
        int serverid = prov.getId();
        List lagen = this.em.createQuery("FROM Layer AS l WHERE l.name = :layerName ").setParameter("layerName", (Object)layerName).getResultList();
        Layer laag = null;
        for (Layer layer : lagen) {
            if (layer.getServiceProvider().getId() != serverid) continue;
            laag = layer;
        }
        return laag;
    }

    protected BigDecimal calculateLayer(LayerPriceComposition tLC, String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws LayerNotAvailableException, NoPrizingException {
        BigDecimal layerPrice = null;
        try {
            layerPrice = super.calculateLayer(spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
        }
        catch (NoPrizingException npe) {
            layerPrice = this.calculateParentAndChildLayers(tLC, spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
        }
        return layerPrice;
    }

    protected BigDecimal calculateParentAndChildLayers(LayerPriceComposition tLC, String spAbbr, String layerName, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws NoPrizingException {
        Layer layer = null;
        try {
            layer = this.getWMSLayer(spAbbr, layerName);
        }
        catch (NoResultException e) {
            log.debug((Object)("Geen layer gevonden: " + layerName));
            throw new NoPrizingException();
        }
        BigDecimal layerPrice = null;
        try {
            layerPrice = this.calculateParentLayer(layer, validationDate, projection, scale, units, planType, service, operation);
            tLC.setMethod(1);
        }
        catch (NoPrizingException npe) {
            layerPrice = this.calculateChildLayers(layer, validationDate, projection, scale, units, planType, service, operation);
            tLC.setMethod(2);
        }
        return layerPrice;
    }

    protected BigDecimal addToLayerPrice(BigDecimal returnValue, BigDecimal addValue) {
        if (addValue != null) {
            if (returnValue == null) {
                returnValue = new BigDecimal("0");
            }
            returnValue = returnValue.add(addValue);
        }
        return returnValue;
    }

    protected BigDecimal calculateChildLayers(Layer layer, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws NoPrizingException {
        BigDecimal layerPrice = null;
        boolean hasNoPrice = true;
        Set childLayers = layer.getLayers();
        log.debug((Object)("Controleer of " + layer.getName() + " childlayers heeft."));
        if (childLayers != null && childLayers.size() > 0) {
            for (Layer childLayer : childLayers) {
                try {
                    String spAbbr = childLayer.getSpAbbr();
                    String layerName = childLayer.getName();
                    BigDecimal thisLayerPrice = this.calculateLayer(spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
                    layerPrice = this.addToLayerPrice(layerPrice, thisLayerPrice);
                    hasNoPrice = false;
                    log.debug((Object)("Pricing gevonden in layer: " + childLayer.getName()));
                }
                catch (Exception npe) {
                    log.debug((Object)("Geen pricing gevonden in layer: " + childLayer.getName() + ", oorzaak: "), (Throwable)npe);
                    try {
                        BigDecimal thisLayerPrice = this.calculateChildLayers(childLayer, validationDate, projection, scale, units, planType, service, operation);
                        layerPrice = this.addToLayerPrice(layerPrice, thisLayerPrice);
                        hasNoPrice = false;
                        log.debug((Object)("Pricing in childlayers gevonden van layer: " + childLayer.getName()));
                    }
                    catch (Exception npe2) {
                        log.debug((Object)("Geen pricing in childlayers gevonden van layer: " + childLayer.getName() + ", oorzaak: "), (Throwable)npe2);
                    }
                }
            }
        }
        if (hasNoPrice) {
            log.debug((Object)("Geen pricing gevonden in layer: " + layer.getName()));
            throw new NoPrizingException();
        }
        return layerPrice;
    }

    protected BigDecimal calculateParentLayer(Layer layer, Date validationDate, String projection, BigDecimal scale, BigDecimal units, int planType, String service, String operation) throws NoPrizingException {
        log.debug((Object)("Controleer of " + layer.getName() + " een parentlayer heeft."));
        BigDecimal layerPrice = null;
        Layer parentLayer = layer.getParent();
        if (parentLayer != null) {
            try {
                String spAbbr = parentLayer.getSpAbbr();
                String layerName = parentLayer.getName();
                layerPrice = this.calculateLayer(spAbbr, layerName, validationDate, projection, scale, units, planType, service, operation);
                log.debug((Object)("Pricing gevonden voor layer: " + parentLayer.getName()));
            }
            catch (Exception ex) {
                log.debug((Object)("Geen pricing gevonden voor layer: " + parentLayer.getName() + " oorzaak: " + ex.getLocalizedMessage()));
                layerPrice = this.calculateParentLayer(parentLayer, validationDate, projection, scale, units, planType, service, operation);
            }
        } else {
            log.debug((Object)("Geen parent gevonden van layer: " + layer.getName()));
            throw new NoPrizingException();
        }
        return layerPrice;
    }
}

