/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetFeatureInfoRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(GetFeatureInfoRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        OGCRequest ogcrequest = dw.getOgcrequest();
        String value = "";
        if (ogcrequest.containsParameter("INFO_FORMAT")) {
            String fileName = null;
            value = ogcrequest.getParameter("application/vnd.ogc.gml");
            if (value != null && value.length() > 0) {
                dw.setContentType(value);
                if (value.equalsIgnoreCase("text/html")) {
                    fileName = "GetFeature.htm";
                } else if (value.equalsIgnoreCase("application/vnd.ogc.wms_gml") || value.equalsIgnoreCase("application/vnd.ogc.gml")) {
                    fileName = "GetFeature.gml";
                } else if (value.equalsIgnoreCase("application/vnd.ogc.wms_xml") || value.equalsIgnoreCase("application/vnd.ogc.xml")) {
                    fileName = "GetFeature.xml";
                }
            } else {
                dw.setContentType("application/vnd.ogc.wms_xml");
                fileName = "GetFeature.xml";
            }
            if (fileName != null) {
                dw.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\";");
            }
        }
        Long timeFromStart = new Long(dw.getRequestReporting().getMSSinceStart());
        this.user = user;
        this.url = user.getPersonalURL(dw.getRequest(), dw.getOgcrequest().getServiceProviderName());
        Integer[] orgIds = this.user.getOrganizationIds();
        OGCRequest ogc = dw.getOgcrequest();
        String spInUrl = ogc.getServiceProviderName();
        String[] la = ogc.getParameter("QUERY_LAYERS").split(",");
        List lsl = LayerSummary.createLayerSummaryList(Arrays.asList(la), (String)spInUrl, (spInUrl == null ? 1 : 0) != 0);
        List spUrls = this.getServiceProviderURLS(lsl, orgIds, true, dw, false);
        if (spUrls == null || spUrls.isEmpty()) {
            log.error((Object)"No urls qualify for request.");
            throw new Exception(KBConfiguration.FEATUREINFO_QUERYABLE_EXCEPTION);
        }
        ArrayList<ServiceProviderRequest> urlWrapper = new ArrayList<ServiceProviderRequest>();
        for (SpLayerSummary spInfo : spUrls) {
            ServiceProviderRequest firWrapper = new ServiceProviderRequest();
            firWrapper.setMsSinceRequestStart(timeFromStart);
            Integer serviceProviderId = spInfo.getServiceproviderId();
            if (serviceProviderId != null && serviceProviderId == -1) continue;
            firWrapper.setServiceProviderId(serviceProviderId);
            String abbr = spInfo.getSpAbbr();
            firWrapper.setServiceProviderAbbreviation(abbr);
            B3PCredentials credentials = new B3PCredentials();
            credentials.setUserName(spInfo.getUsername());
            credentials.setPassword(spInfo.getPassword());
            firWrapper.setCredentials(credentials);
            String layersList = spInfo.getLayersAsString();
            StringBuilder url = new StringBuilder();
            url.append(spInfo.getSpUrl());
            if (url.indexOf("?") != url.length() - 1 && url.indexOf("&") != url.length() - 1) {
                if (url.indexOf("?") >= 0) {
                    url.append("&");
                } else {
                    url.append("?");
                }
            }
            String[] params = dw.getOgcrequest().getParametersArray();
            for (int i = 0; i < params.length; ++i) {
                String[] keyValuePair = params[i].split("=");
                if (keyValuePair[0].equalsIgnoreCase("LAYERS")) {
                    url.append("LAYERS");
                    url.append("=");
                    url.append(layersList);
                    url.append("&");
                    continue;
                }
                if (keyValuePair[0].equalsIgnoreCase("QUERY_LAYERS")) {
                    url.append("QUERY_LAYERS");
                    url.append("=");
                    url.append(layersList);
                    url.append("&");
                    continue;
                }
                url.append(params[i]);
                url.append("&");
            }
            firWrapper.setProviderRequestURI(url.toString());
            urlWrapper.add(firWrapper);
        }
        this.getOnlineData(dw, urlWrapper, false, "GetFeatureInfo");
    }
}

