/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.accounting.LayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPricing;
import nl.b3p.kaartenbalie.struts.PricingAction;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class WmsPricingAction
extends PricingAction {
    private static final Log log = LogFactory.getLog(WmsPricingAction.class);
    private static final String START_END_ERROR_KEY = "error.dateinput";
    private static final String LAYER_PLACEHOLDER_ERROR_KEY = "beheer.princing.placeholder.error";
    private static final String SCALE_ERROR_KEY = "beheer.pricing.scale.error";

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigDecimal unitPrice;
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WmsPricingAction.getEntityManager();
        request.setAttribute("id", (Object)request.getParameter("id"));
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Date validFrom = FormUtils.FormStringToDate((String)dynaForm.getString("validFrom"), null);
        Date validUntil = FormUtils.FormStringToDate((String)dynaForm.getString("validUntil"), null);
        if (validUntil != null && validFrom != null && validUntil.before(validFrom)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.dateinput");
            return this.getAlternateForward(mapping, request);
        }
        LayerPricing lp = this.getLayerPricing(dynaForm, request, true);
        if (lp == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        lp.setValidFrom(validFrom);
        lp.setValidUntil(validUntil);
        Layer layer = null;
        String id = FormUtils.nullIfEmpty((String)this.getLayerID(dynaForm));
        if (id != null) {
            layer = this.getLayerByUniqueName(id);
        }
        if (layer == null || layer.getName() == null || layer.getName().trim().length() == 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "beheer.princing.placeholder.error");
            return this.getAlternateForward(mapping, request);
        }
        lp.setServerProviderPrefix(layer.getSpAbbr());
        lp.setLayerName(layer.getName());
        lp.setPlanType(FormUtils.StringToInt((String)dynaForm.getString("planType")));
        String service = dynaForm.getString("service");
        String operation = null;
        if (service != null && service.equalsIgnoreCase("WMS")) {
            operation = dynaForm.getString("operationWMS");
        } else if (service != null && service.equalsIgnoreCase("WFS")) {
            operation = dynaForm.getString("operationWFS");
        } else {
            service = null;
        }
        if (operation != null && operation.trim().length() == 0) {
            operation = null;
        }
        lp.setService(service);
        lp.setOperation(operation);
        BigDecimal minScale = FormUtils.bdValueNull((String)dynaForm.getString("minScale"));
        BigDecimal maxScale = FormUtils.bdValueNull((String)dynaForm.getString("maxScale"));
        String projection = dynaForm.getString("projection");
        if (projection != null && projection.trim().length() == 0) {
            projection = null;
        }
        if (projection != null && (minScale != null || maxScale != null)) {
            boolean scaleOK = false;
            if (minScale != null && minScale.doubleValue() > 0.0 && maxScale != null && maxScale.doubleValue() > 0.0 && maxScale.compareTo(minScale) > 0) {
                scaleOK = true;
            }
            if (!scaleOK) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, "beheer.pricing.scale.error");
                return this.getAlternateForward(mapping, request);
            }
            if (minScale != null) {
                lp.setMinScale(minScale.setScale(2, RoundingMode.HALF_UP));
            }
            if (maxScale != null) {
                lp.setMaxScale(maxScale.setScale(2, RoundingMode.HALF_UP));
            }
            lp.setProjection(projection);
        }
        if ((unitPrice = FormUtils.bdValueNull((String)dynaForm.getString("unitPrice"))) != null && unitPrice.doubleValue() > 0.0) {
            lp.setUnitPrice(unitPrice.setScale(2, RoundingMode.HALF_UP));
        } else {
            lp.setLayerIsFree(Boolean.TRUE);
        }
        em.persist((Object)lp);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        String id;
        super.createLists(form, request);
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = WmsPricingAction.getEntityManager();
        request.setAttribute("projections", (Object)KBConfiguration.SUPPORTED_PROJECTIONS);
        request.setAttribute("wmsRequests", (Object)KBConfiguration.ACCOUNTING_WMS_REQUESTS);
        request.setAttribute("wfsRequests", (Object)KBConfiguration.ACCOUNTING_WFS_REQUESTS);
        if (form.getString("service") == null || form.getString("service").trim().length() == 0) {
            form.set("service", (Object)new String("WMS"));
            form.set("operationWMS", (Object)new String("GetMap"));
        }
        if ((id = FormUtils.nullIfEmpty((String)this.getLayerID(form))) == null) {
            return;
        }
        Layer layer = this.getLayerByUniqueName(id);
        if (layer == null || layer.getName() == null || layer.getName().trim().length() == 0) {
            return;
        }
        String layerName = layer.getName();
        String spAbbr = layer.getSpAbbr();
        ServiceProvider sp = layer.getServiceProvider();
        request.setAttribute("spName", (Object)sp.getTitle());
        request.setAttribute("lName", (Object)layer.getName());
        request.setAttribute("layerPricings", (Object)em.createQuery("FROM LayerPricing AS lp WHERE lp.layerName = :layerName AND lp.serverProviderPrefix = :serverProviderPrefix AND lp.service = :service ORDER BY  lp.deletionDate ASC, lp.creationDate DESC").setParameter("layerName", (Object)layer.getName()).setParameter("serverProviderPrefix", (Object)layer.getSpAbbr()).setParameter("service", (Object)"WMS").getResultList());
        LayerCalculator lc = new LayerCalculator();
        Object[][] tableData = new Object[KBConfiguration.ACCOUNTING_WMS_REQUESTS.length][3];
        Date now = new Date();
        BigDecimal units = new BigDecimal("1");
        int totalWMSRequests = KBConfiguration.ACCOUNTING_WMS_REQUESTS.length;
        for (int i = 0; i < totalWMSRequests; ++i) {
            tableData[i][0] = "WMS";
            tableData[i][1] = KBConfiguration.ACCOUNTING_WMS_REQUESTS[i];
            try {
                tableData[i][2] = lc.calculateLayerComplete(spAbbr, layerName, now, KBConfiguration.DEFAULT_PROJECTION, null, units, 1, "WMS", KBConfiguration.ACCOUNTING_WMS_REQUESTS[i]);
                continue;
            }
            catch (NoResultException nre) {
                tableData[i][2] = null;
            }
        }
        request.setAttribute("tableData", (Object)tableData);
    }
}

