/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WMSRequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetMapRequestHandler
extends WMSRequestHandler {
    private static final Log log = LogFactory.getLog(GetMapRequestHandler.class);

    public void getRequest(DataWrapper dw, User user) throws IOException, Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        this.user = user;
        this.url = user.getPersonalURL(dw.getRequest(), dw.getOgcrequest().getServiceProviderName());
        Integer[] orgIds = user.getOrganizationIds();
        OGCRequest ogc = dw.getOgcrequest();
        String value = "";
        if (ogc.containsParameter("FORMAT")) {
            value = ogc.getParameter("FORMAT");
            if (value != null && value.length() > 0) {
                dw.setContentType(value);
            } else {
                dw.setContentType("application/vnd.ogc.wms_xml");
            }
        }
        Long timeFromStart = new Long(dw.getRequestReporting().getMSSinceStart());
        Integer width = null;
        try {
            width = new Integer(ogc.getParameter("WIDTH"));
        }
        catch (NumberFormatException nfe) {
            width = new Integer(-1);
        }
        Integer height = null;
        try {
            height = new Integer(ogc.getParameter("HEIGHT"));
        }
        catch (NumberFormatException nfe) {
            height = new Integer(-1);
        }
        String givenSRS = ogc.getParameter("SRS");
        String spInUrl = ogc.getServiceProviderName();
        String[] la = ogc.getParameter("LAYERS").split(",");
        List lsl = LayerSummary.createLayerSummaryList(Arrays.asList(la), (String)spInUrl, (spInUrl == null ? 1 : 0) != 0);
        List spUrls = this.getServiceProviderURLS(lsl, orgIds, false, dw, true);
        if (spUrls == null || spUrls.isEmpty()) {
            log.error((Object)"No urls qualify for request.");
            throw new Exception(KBConfiguration.GETMAP_EXCEPTION);
        }
        spUrls = this.prepareAccounting(user.getMainOrganizationId(), dw, spUrls);
        ArrayList<ServiceProviderRequest> urlWrapper = new ArrayList<ServiceProviderRequest>();
        for (SpLayerSummary spInfo : spUrls) {
            ServiceProviderRequest gmrWrapper = new ServiceProviderRequest();
            gmrWrapper.setMsSinceRequestStart(timeFromStart);
            gmrWrapper.setWidth(width);
            gmrWrapper.setHeight(height);
            gmrWrapper.setWmsVersion(ogc.getParameter("VERSION"));
            gmrWrapper.setSrs(null);
            gmrWrapper.setFormat(ogc.getParameter("FORMAT"));
            gmrWrapper.setBoundingBox(ogc.getParameter("BBOX"));
            Integer serviceProviderId = spInfo.getServiceproviderId();
            B3PCredentials credentials = new B3PCredentials();
            credentials.setUserName(spInfo.getUsername());
            credentials.setPassword(spInfo.getPassword());
            if (serviceProviderId != null && serviceProviderId == -1) {
                StringBuffer url = this.createOnlineUrl(spInfo, ogc, dw.getRequest().getRequestURL().toString());
                String serviceRequestURI = url.toString();
                if (serviceRequestURI.contains("QUERY_LAYERS=&")) {
                    serviceRequestURI = serviceRequestURI.replace("QUERY_LAYERS=&", "");
                }
                gmrWrapper.setProviderRequestURI(serviceRequestURI);
                gmrWrapper.setCredentials(credentials);
                urlWrapper.add(gmrWrapper);
                continue;
            }
            gmrWrapper.setServiceProviderId(serviceProviderId);
            boolean srsFound = false;
            List llsl = spInfo.getLayers();
            for (LayerSummary ls : llsl) {
                srsFound = false;
                Set sqlQuery = this.getSRS(ls.getLayerId().intValue(), em);
                if (sqlQuery != null) {
                    for (String srs : sqlQuery) {
                        if (srs == null || !srs.equals(givenSRS)) continue;
                        srsFound = true;
                    }
                }
                if (srsFound) continue;
                break;
            }
            if (!srsFound) {
                log.error((Object)"No suitable srs found.");
                throw new Exception(KBConfiguration.SRS_EXCEPTION);
            }
            StringBuffer url = this.createOnlineUrl(spInfo, ogc, dw.getRequest().getRequestURL().toString());
            String serviceRequestURI = url.toString();
            if (serviceRequestURI.contains("QUERY_LAYERS=&")) {
                serviceRequestURI = serviceRequestURI.replace("QUERY_LAYERS=&", "");
            }
            gmrWrapper.setProviderRequestURI(serviceRequestURI);
            gmrWrapper.setCredentials(credentials);
            urlWrapper.add(gmrWrapper);
        }
        this.doAccounting(user.getMainOrganizationId(), dw, user);
        this.getOnlineData(dw, urlWrapper, true, "GetMap");
    }

    private Set<String> getSRS(int layerId, EntityManager em) {
        Layer l = (Layer)em.find(Layer.class, (Object)layerId);
        if (l == null) {
            log.warn((Object)("getSRS(): layer with id " + layerId + " not found"));
            return new HashSet<String>();
        }
        HashSet<String> srses = new HashSet<String>();
        srses.addAll(this.getSRSStrings(l.getSrsbb()));
        while (l.getParent() != null) {
            l = l.getParent();
            srses.addAll(this.getSRSStrings(l.getSrsbb()));
        }
        return srses;
    }

    private Set<String> getSRSStrings(Set<SrsBoundingBox> entities) {
        HashSet<String> result = new HashSet<String>();
        if (entities != null) {
            for (SrsBoundingBox srsbb : entities) {
                result.add(srsbb.getSrs());
            }
        }
        return result;
    }
}

