/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.ogc.utils.OGCRequest;

public class TextToImage {
    private String imageType;

    public void createImage(String message, DataWrapper data) throws IOException {
        this.imageType = this.imageType;
        Color background = Color.white;
        Color textColor = Color.black;
        Font font = new Font("Serif", 0, 14);
        BufferedImage buffer = new BufferedImage(1, 1, 1);
        Graphics2D g2 = buffer.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontRenderContext fc = g2.getFontRenderContext();
        OGCRequest ogcrequest = data.getOgcrequest();
        int width = Integer.parseInt(ogcrequest.getParameter("WIDTH"));
        int height = Integer.parseInt(ogcrequest.getParameter("HEIGHT"));
        if (width <= 0) {
            width = 200;
        }
        if (height <= 0) {
            height = 200;
        }
        buffer = new BufferedImage(width, height, 1);
        g2 = buffer.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(font);
        g2.setColor(background);
        g2.fillRect(0, 0, width, height);
        g2.setColor(textColor);
        ArrayList sentences = this.cutMessage(message, width, height);
        Iterator it = sentences.iterator();
        int x = 0;
        while (it.hasNext()) {
            String sentence = (String)it.next();
            g2.drawString(sentence, 0, x + 30);
            x += 15;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String requestedImageType = ogcrequest.getParameter("FORMAT");
        if (requestedImageType.equalsIgnoreCase("image/jpeg")) {
            this.imageType = "JPEG";
        } else if (requestedImageType.equalsIgnoreCase("image/png")) {
            this.imageType = "PNG";
        } else if (requestedImageType.equalsIgnoreCase("image/gif")) {
            this.imageType = "GIF";
        }
        ImageIO.write((RenderedImage)buffer, this.imageType, baos);
        data.write(baos);
    }

    private ArrayList cutMessage(String message, int width, int height) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (message != null) {
            int length = message.length();
            int divide = width / 7;
            int parts = length / divide;
            int leftOver = length - parts * divide;
            for (int part = 0; part <= parts; ++part) {
                int begin = part * divide;
                int end = part * divide + divide;
                if (part == parts) {
                    end = part * divide + leftOver;
                }
                String curString = message.substring(begin, end);
                sentences.add(curString);
            }
        }
        return sentences;
    }
}

